/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.PointDistanceAreaImpl;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.origin.AbstractOriginPoint;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import org.w3c.dom.Element;

public class OriginPointDistance
extends AbstractOriginPoint
implements OriginSubsetter {
    private double min = this.getMin().convertTo(UnitImpl.DEGREE).get_value();
    private double max = this.getMax().convertTo(UnitImpl.DEGREE).get_value();

    public OriginPointDistance(Element config) throws Exception {
        super(config);
    }

    @Override
    public StringTree accept(CacheEvent event, EventAttrImpl eventAttr, OriginImpl origin) {
        double oLat = origin.getLocation().latitude;
        double oLon = origin.getLocation().longitude;
        DistAz distaz = new DistAz(this.latitude, this.longitude, oLat, oLon);
        double delta = distaz.getDelta();
        return new StringTreeLeaf(this, this.min <= delta && this.max >= delta);
    }

    public Area getArea() {
        return new PointDistanceAreaImpl((float)this.latitude, (float)this.longitude, (Quantity)new QuantityImpl(this.min, (Unit)UnitImpl.DEGREE), (Quantity)new QuantityImpl(this.max, (Unit)UnitImpl.DEGREE));
    }
}

