/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.InstrumentationLoader;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.subsetter.channel.HasResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasSensitivity
implements ChannelSubsetter {
    private Logger logger = LoggerFactory.getLogger(HasResponse.class);

    @Override
    public StringTree accept(ChannelImpl channel, NetworkSource network) {
        try {
            QuantityImpl sens = network.getSensitivity(channel);
            return new StringTreeLeaf(this, InstrumentationLoader.isValidSensitivity((QuantityImpl)sens));
        }
        catch (ChannelNotFound e) {
            return new Fail((Object)this, "No instrumentation");
        }
        catch (InvalidResponse e) {
            return new Fail((Object)this, "Invalid instrumentation: " + e.getMessage());
        }
        catch (SodSourceException e) {
            return new Fail((Object)this, "Error getting instrumentation: " + e.getMessage());
        }
    }
}

