/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.seismogram.FixedDataCenter;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.channel.ChannelEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.subsetter.channel.RecentRequest;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class HadDataLastWeek
implements ChannelSubsetter {
    private HashMap<String, RecentRequest> recentRequests = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(HadDataLastWeek.class);
    private FixedDataCenter fixDC;
    private TimeInterval MAX_CACHE = new TimeInterval(1.0, UnitImpl.HOUR);

    public HadDataLastWeek(Element el) throws Exception {
        this.fixDC = new FixedDataCenter(DOMHelper.getElement((Element)el, (String)"fixedDataCenter"));
    }

    @Override
    public StringTree accept(ChannelImpl channel, NetworkSource network) throws Exception {
        MicroSecondDate now = ClockUtil.now();
        ChannelEffectiveTimeOverlap overlap = new ChannelEffectiveTimeOverlap(now.subtract(this.makeDayInterval(7)), now);
        if (!overlap.accept(channel, network).isSuccess()) {
            return new StringTreeLeaf(this, false, "Channel Ended");
        }
        String key = ChannelIdUtil.toStringNoDates((Channel)channel);
        if (this.recentRequests.containsKey(key)) {
            RecentRequest r = this.recentRequests.get(key);
            if (r.when.add(this.MAX_CACHE).after((Date)ClockUtil.now())) {
                return new StringTreeLeaf(this, r.hadData);
            }
            this.recentRequests.remove(r);
        }
        RequestFilter[] reqs = new RequestFilter[7];
        for (int i = 0; i < reqs.length; ++i) {
            reqs[i] = new RequestFilter(channel.get_id(), now.subtract(this.makeDayInterval(i + 1)).getFissuresTime(), now.subtract(this.makeDayInterval(i)).getFissuresTime());
        }
        if (this.fixDC.getDataCenter().available_data(reqs).length > 0) {
            logger.debug(ChannelIdUtil.toStringNoDates((Channel)channel) + " had data");
            this.recentRequests.put(key, new RecentRequest(channel.get_id(), ClockUtil.now(), true));
            return new StringTreeLeaf(this, true);
        }
        logger.debug(ChannelIdUtil.toStringNoDates((Channel)channel) + " didn't have data");
        this.recentRequests.put(key, new RecentRequest(channel.get_id(), ClockUtil.now(), false));
        return new StringTreeLeaf(this, false);
    }

    private TimeInterval makeDayInterval(int days) {
        return new TimeInterval((double)days, UnitImpl.DAY);
    }
}

