/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter;

import edu.iris.Fissures.Unit;
import edu.iris.Fissures.UnitRange;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodElement;
import edu.sc.seis.sod.SodUtil;
import org.w3c.dom.Element;

public class DistanceRangeSubsetter
implements SodElement {
    private UnitRangeImpl unitRange;

    public DistanceRangeSubsetter(Element config) throws ConfigurationException {
        this.processConfig(config);
    }

    public void processConfig(Element config) throws ConfigurationException {
        this.unitRange = SodUtil.loadUnitRange(config);
        if (((UnitImpl)this.unitRange.the_units).isConvertableTo(UnitImpl.KILOMETER)) {
            QuantityImpl min = new QuantityImpl(this.unitRange.getMinValue(), (Unit)this.unitRange.getUnit());
            QuantityImpl max = new QuantityImpl(this.unitRange.getMaxValue(), (Unit)this.unitRange.getUnit());
            this.unitRange = new UnitRangeImpl(DistAz.kilometersToDegrees((double)min.getValue(UnitImpl.KILOMETER)), DistAz.kilometersToDegrees((double)max.getValue(UnitImpl.KILOMETER)), (Unit)UnitImpl.DEGREE);
        }
    }

    public UnitRange getUnitRange() {
        return this.unitRange;
    }

    public QuantityImpl getMin() {
        return new QuantityImpl(this.getUnitRange().min_value, this.getUnitRange().the_units);
    }

    public QuantityImpl getMax() {
        return new QuantityImpl(this.getUnitRange().max_value, this.getUnitRange().the_units);
    }
}

