/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.waveformArm;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.AbstractVelocityStatus;
import edu.sc.seis.sod.status.networkArm.NetworkMonitor;
import edu.sc.seis.sod.status.networkArm.VelocityStationGetter;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.w3c.dom.Element;

public class WaveformNetworkStatus
extends AbstractVelocityStatus
implements WaveformMonitor,
NetworkMonitor {
    protected String networkListTemplate;

    public WaveformNetworkStatus(Element config) throws SQLException, MalformedURLException, IOException {
        super(config);
        String networkListLoc = WaveformNetworkStatus.getNestedTextForElement("networkListTemplate", config);
        this.networkListTemplate = this.loadTemplate(networkListLoc);
        if (Start.getNetworkArm() != null) {
            Start.getNetworkArm().add(this);
        }
    }

    @Override
    public int getNumDirDeep() {
        return 1;
    }

    @Override
    public void update(EventNetworkPair ecp) {
    }

    @Override
    public void update(EventStationPair ecp) {
    }

    @Override
    public void update(EventChannelPair ecp) {
        this.change(ecp.getChannel().getSite().getStation(), ecp.getStatus());
    }

    @Override
    public void update(EventVectorPair ecp) {
        this.change(ecp.getChannelGroup().getChannels()[0].getSite().getStation(), ecp.getStatus());
    }

    @Override
    public void setArmStatus(String status) throws Exception {
    }

    @Override
    public void change(Station station, Status s) {
        try {
            VelocityContext context = new VelocityContext();
            NetworkAttrImpl net = Start.getNetworkArm().getNetwork(station.getNetworkAttr().get_id());
            context.put("network", (Object)net);
            context.put("stations", (Object)new VelocityStationGetter(station.getNetworkAttr().get_id()));
            String id = NetworkIdUtil.toStringNoDates((NetworkId)station.getNetworkAttr().get_id());
            this.scheduleOutput("waveformStations/" + id + ".html", (Context)context);
        }
        catch (Throwable e) {
            GlobalExceptionHandler.handle((String)("Can't set status(" + s + ") for " + StationIdUtil.toString((StationId)station.get_id())), (Throwable)e);
        }
    }

    @Override
    public void change(Channel channel, Status s) {
    }

    @Override
    public void change(NetworkAttrImpl net, Status s) {
        if (s.getStanding().equals(Standing.SUCCESS)) {
            VelocityContext context = new VelocityContext();
            context.put("network", (Object)net);
            this.scheduleOutput("waveformStations/waveformNetworks.html", (Context)context, this.networkListTemplate);
        }
    }

    @Override
    public void change(Site site, Status s) {
    }
}

