/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.util.Timer;
import java.util.TimerTask;

public abstract class PeriodicAction {
    private boolean scheduled = false;
    private static final TimeInterval ACTION_INTERVAL = new TimeInterval(2.0, UnitImpl.MINUTE);
    private static final long ACTION_INTERVAL_MILLIS = (long)ACTION_INTERVAL.convertTo(UnitImpl.MILLISECOND).get_value();
    private MicroSecondDate lastAct = ClockUtil.now().subtract(ACTION_INTERVAL);
    private Object schedulingLock = new Object();
    private static Timer t = new Timer();

    public abstract void act();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actIfPeriodElapsed() {
        Object object = this.schedulingLock;
        synchronized (object) {
            if (ClockUtil.now().subtract(this.lastAct).greaterThan((QuantityImpl)ACTION_INTERVAL)) {
                this.actNow();
            } else if (!this.scheduled) {
                t.schedule((TimerTask)new ScheduledActor(), ACTION_INTERVAL_MILLIS);
                this.scheduled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actNow() {
        Object object = this.schedulingLock;
        synchronized (object) {
            this.lastAct = ClockUtil.now();
            this.scheduled = false;
        }
        try {
            this.act();
        }
        catch (Throwable t) {
            GlobalExceptionHandler.handle((String)"Trouble running periodic action", (Throwable)t);
        }
    }

    private class ScheduledActor
    extends TimerTask {
        private ScheduledActor() {
        }

        @Override
        public void run() {
            PeriodicAction.this.actNow();
        }
    }
}

