/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.sc.seis.fissuresUtil.map.OpenMap;
import edu.sc.seis.fissuresUtil.map.colorizer.event.EventColorizer;
import edu.sc.seis.fissuresUtil.map.layers.EventLayer;
import edu.sc.seis.fissuresUtil.map.layers.ShapeLayerPropertiesHandler;
import edu.sc.seis.fissuresUtil.map.layers.StationLayer;

public class MapPool {
    private static MapPool defaultPool;
    private boolean[] free;
    private OpenMap[] maps;

    public MapPool(int mapCount) {
        this.maps = new OpenMap[mapCount];
        this.free = new boolean[mapCount];
        for (int i = 0; i < this.maps.length; ++i) {
            this.maps[i] = new OpenMap(ShapeLayerPropertiesHandler.getProperties());
            this.maps[i].setEtopoLayer("edu/sc/seis/mapData");
            this.maps[i].setStationLayer(new StationLayer());
            this.maps[i].overrideProjChangedInOMLayers(true);
            this.free[i] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public OpenMap getMap(EventColorizer colorizer) {
        while (true) {
            for (int i = 0; i < this.maps.length; ++i) {
                boolean[] blArray = this.free;
                // MONITORENTER : this.free
                if (this.free[i]) {
                    this.free[i] = false;
                    this.maps[i].setEventLayer(new EventLayer(this.maps[i], colorizer));
                    // MONITOREXIT : blArray
                    return this.maps[i];
                }
                // MONITOREXIT : blArray
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void returnMap(OpenMap map) {
        this.clear(map);
        int i = 0;
        while (i < this.maps.length) {
            if (this.maps[i] == map) {
                boolean[] blArray = this.free;
                // MONITORENTER : this.free
                this.free[i] = true;
                // MONITOREXIT : blArray
            }
            ++i;
        }
    }

    private void clear(OpenMap map) {
        map.getEventLayer().eventDataCleared();
        map.getStationLayer().stationDataCleared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapPool getDefaultPool() {
        Class<MapPool> clazz = MapPool.class;
        synchronized (MapPool.class) {
            if (defaultPool == null) {
                defaultPool = new MapPool(1);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultPool;
        }
    }
}

