/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionReporter;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.exceptionHandler.HTMLReporter;
import edu.sc.seis.sod.AbstractWaveformRecipe;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.EventArm;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.NetworkArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.process.waveform.LocalSeismogramTemplateGenerator;
import edu.sc.seis.sod.status.FileWritingTemplate;
import edu.sc.seis.sod.status.RelativeLocationTemplate;
import edu.sc.seis.sod.status.TemplateFileLoader;
import edu.sc.seis.sod.status.eventArm.EventStatusTemplate;
import edu.sc.seis.sod.status.eventArm.MapEventStatus;
import edu.sc.seis.sod.status.networkArm.NetworkInfoTemplateGenerator;
import edu.sc.seis.sod.status.waveformArm.WaveformEventTemplateGenerator;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import edu.sc.seis.sod.status.waveformArm.WaveformNetworkStatus;
import edu.sc.seis.sod.status.waveformArm.WaveformStationStatus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;

public class IndexTemplate
extends FileWritingTemplate
implements WaveformMonitor {
    private MapEventStatus mapEventStatus;
    private static String indexLoc = "jar:edu/sc/seis/sod/data/templates/index.xml";
    private static String cssLoc = "jar:edu/sc/seis/sod/data/templates/main.css";
    private static String sortLoc = "jar:edu/sc/seis/sod/data/templates/sorttable.js";
    private static String rulLoc = "jar:edu/sc/seis/sod/data/templates/tableRuler.js";
    private static String footPosLoc = "jar:edu/sc/seis/sod/data/templates/footerPositioner.js";
    private static String helpMark = "jar:edu/sc/seis/sod/data/templates/defaults/helpmark.png";
    private static String up = "jar:edu/sc/seis/sod/data/templates/defaults/up.gif";
    private static String down = "jar:edu/sc/seis/sod/data/templates/defaults/down.gif";
    private static String none = "jar:edu/sc/seis/sod/data/templates/defaults/none.gif";
    private static String key = "jar:edu/sc/seis/sod/data/templates/defaults/mapkey.gif";
    private static String individualKey = "jar:edu/sc/seis/sod/data/templates/defaults/individualEventMapKey.gif";
    private static String eventPageHelp = "jar:edu/sc/seis/sod/data/templates/defaults/eventPageHelp.xml";
    private static String xslWrapperFileLoc = "jar:edu/sc/seis/sod/data/xmlverbatimwrapper.xsl";
    private static String supportXslFileLoc = "jar:edu/sc/seis/sod/data/xmlverbatim.xsl";
    private static String cssFileLoc = "jar:edu/sc/seis/sod/data/xmlverbatim.css";
    private static String configFile;

    public IndexTemplate() throws IOException {
        this(FileWritingTemplate.getBaseDirectoryName());
    }

    public IndexTemplate(String dirName) throws IOException {
        super(dirName, "index.html");
        try {
            this.initExceptionHandler();
            String configFileLoc = Start.getConfigFileName();
            configFile = new File(configFileLoc).getName();
            Element template = TemplateFileLoader.getTemplate(this.getClass().getClassLoader(), indexLoc);
            this.parse(template);
            this.write();
            FileWritingTemplate help = new FileWritingTemplate(dirName, "/help/eventPageHelp.html");
            help.parse(TemplateFileLoader.getTemplate(this.getClass().getClassLoader(), eventPageHelp));
            help.write();
            SodUtil.copyFile(cssLoc, dirName + "/main.css");
            SodUtil.copyFile(sortLoc, dirName + "/sorttable.js");
            SodUtil.copyFile(rulLoc, dirName + "/tableRuler.js");
            SodUtil.copyFile(footPosLoc, dirName + "/footerPositioner.js");
            SodUtil.copyFile(helpMark, dirName + "/images/helpmark.png");
            SodUtil.copyFile(up, dirName + "/images/up.gif");
            SodUtil.copyFile(down, dirName + "/images/down.gif");
            SodUtil.copyFile(none, dirName + "/images/none.gif");
            SodUtil.copyFile(key, dirName + "/images/mapkey.gif");
            SodUtil.copyFile(individualKey, dirName + "/images/individualEventMapKey.gif");
            SodUtil.copyFile(Start.getConfigFileName(), FileWritingTemplate.getBaseDirectoryName() + "/" + configFile);
            this.convertToHTML(dirName);
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle((String)"unexpected problem creating index.html page", (Throwable)e);
        }
    }

    public static String getCopiedConfigFileLocation() {
        return configFile;
    }

    public static String getHtmlConfigFileName() {
        String configFileLoc = IndexTemplate.getCopiedConfigFileLocation();
        String fileName = configFileLoc.substring(0, configFileLoc.indexOf(".xml"));
        fileName = fileName + ".html";
        return fileName;
    }

    @Override
    public void update(EventNetworkPair ecp) {
        this.write();
    }

    @Override
    public void update(EventStationPair ecp) {
        this.write();
    }

    @Override
    public void update(EventChannelPair ecp) {
        this.write();
    }

    @Override
    public void update(EventVectorPair ecp) {
        this.write();
    }

    public void performRegistration() throws Exception {
        if (Start.getEventArm() != null) {
            Start.getEventArm().add(this.mapEventStatus);
        }
        this.loadStatusTemplates();
        if (Start.getWaveformRecipe() != null) {
            Start.getWaveformRecipe().addStatusMonitor(this);
        }
    }

    private void loadStatusTemplates() throws Exception {
        AbstractWaveformRecipe waveformArm;
        NetworkArm net;
        ClassLoader cl = this.getClass().getClassLoader();
        Element statusConfig = TemplateFileLoader.getTemplate(cl, "jar:edu/sc/seis/sod/data/statusPageConfig.xml");
        EventArm event = Start.getEventArm();
        if (event != null) {
            Element eventStatusEl = DOMHelper.extractElement((Element)statusConfig, (String)"eventStatusTemplate");
            event.add(new EventStatusTemplate(eventStatusEl));
        }
        if ((net = Start.getNetworkArm()) != null) {
            Element netInfoEl = DOMHelper.extractElement((Element)statusConfig, (String)"networkInfoTemplateGenerator");
            net.add(new NetworkInfoTemplateGenerator(netInfoEl));
        }
        if ((waveformArm = Start.getWaveformRecipe()) != null) {
            Element seisTempEl = DOMHelper.extractElement((Element)statusConfig, (String)"localSeismogramTemplateGenerator");
            waveformArm.add(new LocalSeismogramTemplateGenerator(seisTempEl));
            Element waveformEventTempEl = DOMHelper.extractElement((Element)statusConfig, (String)"waveformEventTemplateGenerator");
            waveformArm.addStatusMonitor(new WaveformEventTemplateGenerator(waveformEventTempEl));
            Element waveformStationEl = DOMHelper.extractElement((Element)statusConfig, (String)"waveformStationStatus");
            waveformArm.addStatusMonitor(new WaveformStationStatus(waveformStationEl));
            Element waveformNetworkEl = DOMHelper.extractElement((Element)statusConfig, (String)"waveformNetworkStatus");
            WaveformNetworkStatus wns = new WaveformNetworkStatus(waveformNetworkEl);
            waveformArm.addStatusMonitor(wns);
            wns.change((NetworkAttrImpl)null, Status.get(Stage.PROCESSOR, Standing.SUCCESS));
        }
    }

    @Override
    protected Object getTemplate(String tagName, Element el) throws ConfigurationException {
        if (tagName.equals("eventMap")) {
            this.mapEventStatus = new MapEventStatus(el);
            return new RelativeLocationTemplate(this.getOutputLocation(), this.mapEventStatus.getLocation());
        }
        return super.getTemplate(tagName, el);
    }

    protected void initExceptionHandler() throws IOException {
        File errorDir = new File(this.getOutputDirectory(), "Errors");
        errorDir.mkdirs();
        GlobalExceptionHandler.add((ExceptionReporter)new HTMLReporter(errorDir));
    }

    private void convertToHTML(String statusDir) throws TransformerException, FileNotFoundException, TransformerConfigurationException, IOException {
        String wrapperFile = statusDir + "/xmlverbatimwrapper.xsl";
        String mainXSL = statusDir + "/xmlverbatim.xsl";
        SodUtil.copyFile(xslWrapperFileLoc, wrapperFile);
        SodUtil.copyFile(supportXslFileLoc, mainXSL);
        SodUtil.copyFile(cssFileLoc, statusDir + "/xmlverbatim.css");
        String htmlFile = statusDir + "/" + IndexTemplate.getHtmlConfigFileName();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer t = tFactory.newTransformer(new StreamSource(wrapperFile));
        t.transform(new StreamSource(statusDir + "/" + configFile), new StreamResult(new FileOutputStream(htmlFile)));
        new File(wrapperFile).delete();
        new File(mainXSL).delete();
    }
}

