/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodElement;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.seismogram.ElapsedTime;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceException;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DownloadStatistics
implements SeismogramSourceLocator {
    ElapsedTime best;
    ElapsedTime worst;
    LinkedList<ElapsedTime> lastDownloads = new LinkedList();
    int maxElapsedListSize = 10;
    long runBegin;
    long totalPoints = 0L;
    SeismogramSourceLocator wrapped;

    public DownloadStatistics(Element config) throws ConfigurationException {
        NodeList childNodes = config.getChildNodes();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            SodElement sodElement;
            Node node = childNodes.item(counter);
            if (!(node instanceof Element) || !((sodElement = (SodElement)SodUtil.load((Element)node, new String[]{"seismogram"})) instanceof SeismogramSourceLocator)) continue;
            this.wrapped = (SeismogramSourceLocator)sodElement;
        }
        Timer t = new Timer("Download Stats", true);
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                System.out.println(DownloadStatistics.this.summarizeStats());
            }
        }, 5000L, 5000L);
        this.runBegin = System.currentTimeMillis();
    }

    @Override
    public SeismogramSource getSeismogramSource(final CacheEvent event, final ChannelImpl channel, final RequestFilter[] infilters, final CookieJar cookieJar) throws Exception {
        return new SeismogramSource(){
            SeismogramSource wrappedSource;
            {
                this.wrappedSource = DownloadStatistics.this.wrapped.getSeismogramSource(event, channel, infilters, cookieJar);
            }

            @Override
            public List<RequestFilter> availableData(List<RequestFilter> request) throws SeismogramSourceException {
                return this.wrappedSource.availableData(request);
            }

            @Override
            public List<LocalSeismogramImpl> retrieveData(List<RequestFilter> request) throws SeismogramSourceException {
                ElapsedTime elapsed = new ElapsedTime();
                List<LocalSeismogramImpl> out = this.wrappedSource.retrieveData(request);
                elapsed.end();
                int dataPoints = 0;
                for (LocalSeismogramImpl ls : out) {
                    dataPoints += ls.getNumPoints();
                }
                elapsed.setNpts(dataPoints);
                DownloadStatistics.this.addElapsed(elapsed);
                return out;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addElapsed(ElapsedTime elapsed) {
        LinkedList<ElapsedTime> linkedList = this.lastDownloads;
        synchronized (linkedList) {
            this.totalPoints += (long)elapsed.npts;
            this.lastDownloads.addFirst(elapsed);
            if (this.lastDownloads.size() > this.maxElapsedListSize) {
                this.lastDownloads.removeLast();
            }
            if (this.best == null || elapsed.getKiloSamplesPerSec() > this.best.getKiloSamplesPerSec()) {
                this.best = elapsed;
            }
            if (this.worst == null || elapsed.getKiloSamplesPerSec() < this.worst.getKiloSamplesPerSec()) {
                this.worst = elapsed;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String summarizeStats() {
        long wallTime;
        long timeTotal = 0L;
        int nptsTotal = 0;
        long totalRunTime = System.currentTimeMillis() - this.runBegin;
        LinkedList<ElapsedTime> linkedList = this.lastDownloads;
        synchronized (linkedList) {
            for (ElapsedTime e : this.lastDownloads) {
                timeTotal += e.getElapsed();
                nptsTotal += e.npts;
            }
            wallTime = this.lastDownloads.getFirst().end - this.lastDownloads.getLast().begin;
        }
        String out = "Last " + this.maxElapsedListSize + ": download=" + (float)nptsTotal * 1.0f / (float)timeTotal + " wall=" + (float)nptsTotal * 1.0f / (float)wallTime + "\n";
        out = out + "Best: " + this.best.getKiloSamplesPerSec() + "  Worst: " + this.worst.getKiloSamplesPerSec() + "\n";
        out = out + "Total Runtime: " + (float)totalRunTime * 1.0f / (float)this.totalPoints + "  over " + totalRunTime / 1000L + " sec";
        return out;
    }
}

