/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.network.WrappingNetworkSource;
import java.io.IOException;
import java.util.List;

public class RetryNetworkSource
extends WrappingNetworkSource
implements NetworkSource {
    NetworkSource wrapped;

    public RetryNetworkSource(NetworkSource sodElement) {
        super(sodElement);
        this.wrapped = sodElement;
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public TimeInterval getRefreshInterval() {
        return this.wrapped.getRefreshInterval();
    }

    @Override
    public CacheNetworkAccess getNetwork(NetworkAttrImpl attr) {
        return this.wrapped.getNetwork(attr);
    }

    @Override
    public List<? extends CacheNetworkAccess> getNetworkByName(String name) throws NetworkNotFound {
        return this.wrapped.getNetworkByName(name);
    }

    @Override
    public List<? extends NetworkAttrImpl> getNetworks() throws SodSourceException {
        int count = 0;
        try {
            return this.wrapped.getNetworks();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (SodSourceException t) {
            SodSourceException latest;
            if (t.getCause() instanceof IOException || t.getCause() != null && t.getCause().getCause() instanceof IOException) {
                latest = t;
            } else {
                throw t;
            }
            while (this.wrapped.getRetryStrategy().shouldRetry((Throwable)latest, (Object)this, count++)) {
                try {
                    List<? extends NetworkAttrImpl> result = this.wrapped.getNetworks();
                    this.wrapped.getRetryStrategy().serverRecovered((Object)this);
                    return result;
                }
                catch (SodSourceException t2) {
                    if (t2.getCause() instanceof IOException || t2.getCause() != null && t2.getCause().getCause() instanceof IOException) {
                        latest = t2;
                        continue;
                    }
                    throw t2;
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
            }
            throw latest;
        }
    }

    @Override
    public List<? extends StationImpl> getStations(NetworkAttrImpl net) throws SodSourceException {
        int count = 0;
        try {
            return this.wrapped.getStations(net);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (SodSourceException t) {
            SodSourceException latest;
            if (t.getCause() instanceof IOException || t.getCause() != null && t.getCause().getCause() instanceof IOException) {
                latest = t;
            } else {
                throw t;
            }
            while (this.wrapped.getRetryStrategy().shouldRetry((Throwable)latest, (Object)this, count++)) {
                try {
                    List<? extends StationImpl> result = this.wrapped.getStations(net);
                    this.wrapped.getRetryStrategy().serverRecovered((Object)this);
                    return result;
                }
                catch (SodSourceException t2) {
                    if (t2.getCause() instanceof IOException || t2.getCause() != null && t2.getCause().getCause() instanceof IOException) {
                        latest = t2;
                        continue;
                    }
                    throw t2;
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
            }
            throw latest;
        }
    }

    @Override
    public List<? extends ChannelImpl> getChannels(StationImpl station) throws SodSourceException {
        int count = 0;
        try {
            return this.wrapped.getChannels(station);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (SodSourceException t) {
            SodSourceException latest;
            if (t.getCause() instanceof IOException || t.getCause() != null && t.getCause().getCause() instanceof IOException) {
                latest = t;
            } else {
                throw t;
            }
            while (this.wrapped.getRetryStrategy().shouldRetry((Throwable)latest, (Object)this, count++)) {
                try {
                    List<? extends ChannelImpl> result = this.wrapped.getChannels(station);
                    this.wrapped.getRetryStrategy().serverRecovered((Object)this);
                    return result;
                }
                catch (SodSourceException t2) {
                    if (t2.getCause() instanceof IOException || t2.getCause() != null && t2.getCause().getCause() instanceof IOException) {
                        latest = t2;
                        continue;
                    }
                    throw t2;
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
            }
            throw latest;
        }
    }

    @Override
    public QuantityImpl getSensitivity(ChannelImpl chan) throws ChannelNotFound, InvalidResponse, SodSourceException {
        int count = 0;
        try {
            return this.wrapped.getSensitivity(chan);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (SodSourceException t) {
            SodSourceException latest;
            if (t.getCause() instanceof IOException || t.getCause() != null && t.getCause().getCause() instanceof IOException) {
                latest = t;
            } else {
                throw t;
            }
            while (this.wrapped.getRetryStrategy().shouldRetry((Throwable)latest, (Object)this, count++)) {
                try {
                    QuantityImpl result = this.wrapped.getSensitivity(chan);
                    this.wrapped.getRetryStrategy().serverRecovered((Object)this);
                    return result;
                }
                catch (SodSourceException t2) {
                    if (t2.getCause() instanceof IOException || t2.getCause() != null && t2.getCause().getCause() instanceof IOException) {
                        latest = t2;
                        continue;
                    }
                    throw t2;
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
            }
            throw latest;
        }
    }

    @Override
    public Instrumentation getInstrumentation(ChannelImpl chan) throws ChannelNotFound, InvalidResponse, SodSourceException {
        int count = 0;
        try {
            return this.wrapped.getInstrumentation(chan);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (SodSourceException t) {
            SodSourceException latest;
            if (t.getCause() instanceof IOException || t.getCause() != null && t.getCause().getCause() instanceof IOException) {
                latest = t;
            } else {
                throw t;
            }
            while (this.wrapped.getRetryStrategy().shouldRetry((Throwable)latest, (Object)this, count++)) {
                try {
                    Instrumentation result = this.wrapped.getInstrumentation(chan);
                    this.wrapped.getRetryStrategy().serverRecovered((Object)this);
                    return result;
                }
                catch (SodSourceException t2) {
                    if (t2.getCause() instanceof IOException || t2.getCause() != null && t2.getCause().getCause() instanceof IOException) {
                        latest = t2;
                        continue;
                    }
                    throw t2;
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
            }
            throw latest;
        }
    }

    @Override
    public void setConstraints(NetworkQueryConstraints constraints) {
        this.wrapped.setConstraints(constraints);
    }
}

