/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.MotionVectorArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.process.waveform.ForkProcess;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.vector.ANDWaveformProcessWrapper;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorProcess;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeBranch;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.availableData.vector.VectorAvailableDataLogicalSubsetter;
import edu.sc.seis.sod.subsetter.availableData.vector.VectorAvailableDataSubsetter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WaveformVectorFork
implements WaveformVectorProcess,
Threadable {
    public static final List<String> packages = new LinkedList<String>();
    private static final Logger logger;
    protected List<WaveformVectorProcess> processes = new ArrayList<WaveformVectorProcess>();

    public WaveformVectorFork(Element config) throws ConfigurationException {
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            WaveformVectorProcess sodElement = WaveformVectorFork.load((Element)node);
            this.processes.add(sodElement);
        }
    }

    public List<String> getPackages() {
        return packages;
    }

    protected Subsetter getSubsetter(Subsetter s) throws ConfigurationException {
        return WaveformVectorFork.createSubsetter(s);
    }

    public static WaveformVectorProcess load(Element el) throws ConfigurationException {
        Object o = SodUtil.load(el, packages);
        if (o instanceof Subsetter) {
            return WaveformVectorFork.createSubsetter((Subsetter)o);
        }
        throw new ConfigurationException("Not a Subsetter: " + o.getClass().getName());
    }

    public static WaveformVectorProcess createSubsetter(final Subsetter s) throws ConfigurationException {
        if (s instanceof WaveformVectorProcess) {
            return (WaveformVectorProcess)s;
        }
        if (s instanceof WaveformProcess) {
            return new ANDWaveformProcessWrapper((WaveformProcess)s);
        }
        return new WaveformVectorProcess(){
            VectorAvailableDataSubsetter ecs;
            {
                this.ecs = VectorAvailableDataLogicalSubsetter.createSubsetter(s);
            }

            @Override
            public WaveformVectorResult accept(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] request, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, CookieJar cookieJar) throws Exception {
                return new WaveformVectorResult(seismograms, this.ecs.accept(event, channelGroup, request, available, cookieJar));
            }
        };
    }

    @Override
    public WaveformVectorResult accept(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] request, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, CookieJar cookieJar) throws Exception {
        return new WaveformVectorResult(WaveformVectorFork.copySeismograms(seismograms), this.doAND(event, channelGroup, request, available, seismograms, cookieJar).getReason());
    }

    public WaveformVectorResult doAND(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] request, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, CookieJar cookieJar) throws Exception {
        LinkedList<StringTree> reasons = new LinkedList<StringTree>();
        Iterator<WaveformVectorProcess> it = this.processes.iterator();
        WaveformVectorResult result = new WaveformVectorResult(seismograms, new StringTreeLeaf(this, true));
        while (it.hasNext() && result.isSuccess()) {
            WaveformVectorProcess processor = it.next();
            result = MotionVectorArm.runProcessorThreadCheck(processor, event, channelGroup, request, available, result.getSeismograms(), cookieJar);
            reasons.addLast(result.getReason());
        }
        return new WaveformVectorResult(result.getSeismograms(), new StringTreeBranch((Object)this, result.isSuccess(), reasons.toArray(new StringTree[0])));
    }

    public static LocalSeismogramImpl[][] copySeismograms(LocalSeismogramImpl[][] seismograms) {
        LocalSeismogramImpl[][] out = new LocalSeismogramImpl[seismograms.length][];
        for (int i = 0; i < out.length; ++i) {
            out[i] = ForkProcess.copySeismograms(seismograms[i]);
        }
        return out;
    }

    public WaveformVectorProcess[] getWrappedProcessors() {
        return this.processes.toArray(new WaveformVectorProcess[0]);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    static {
        packages.add("waveform.vector");
        packages.addAll(VectorAvailableDataLogicalSubsetter.packages);
        packages.addAll(ForkProcess.packages);
        logger = LoggerFactory.getLogger(WaveformVectorFork.class);
    }
}

