/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.IfTimeSeries.EncodedData;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CompressionType
implements WaveformProcess {
    int[] types;

    public CompressionType(Element el) {
        NodeList nl = el.getElementsByTagName("type");
        this.types = new int[nl.getLength()];
        for (int i = 0; i < nl.getLength(); ++i) {
            this.types[i] = DOMHelper.extractInt((Element)((Element)nl.item(i)), (String)".", (int)-1);
        }
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        for (int s = 0; s < seismograms.length; ++s) {
            if (!seismograms[s].is_encoded()) continue;
            EncodedData[] edata = seismograms[s].get_as_encoded();
            for (int i = 0; i < edata.length; ++i) {
                boolean found = false;
                for (int t = 0; t < this.types.length; ++t) {
                    if (edata[i].compression != this.types[t]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return new WaveformResult(false, seismograms, this, "type " + edata[i].compression + " not accepted");
            }
        }
        return new WaveformResult(true, seismograms, this);
    }
}

