/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Version;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Args {
    private static final String COMMAND_NAME = "sod";
    private JSAPResult result;
    private JSAP jsap = new JSAP();
    private List parameters = new ArrayList();
    private String[] args;
    public static final String CLEAN_SWITCH = "clean";
    public static final String QUIT_ON_ERROR_SWITCH = "quitOnError";
    public static final String PRINT_RECIPE_SWITCH = "print-recipe";
    private static final Logger logger = LoggerFactory.getLogger(Args.class);

    public Args(String[] args) throws JSAPException {
        this.args = args;
        ArrayList<String> toParse = new ArrayList<String>(args.length);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-conf")) {
                args[i] = "-f";
            }
            for (int j = 0; j < Initializer.POSSIBLE_PROP_OPTION_NAMES.length; ++j) {
                if (!args[i].equals(Initializer.POSSIBLE_PROP_OPTION_NAMES[j])) continue;
                args[i] = "-p";
            }
            if (args[i].equals("-demo") || args[i].equals("--demo")) {
                toParse.add("-f");
                toParse.add("jar:edu/sc/seis/sod/data/configFiles/demo.xml");
                continue;
            }
            if (args[i].equals("-hsql")) {
                ++i;
                continue;
            }
            toParse.add(args[i]);
        }
        this.add((Parameter)new Switch("debug", '\u0000', "debug", "extra debug output to log file"));
        this.add((Parameter)new Switch("help", 'h', "help", "Print out this message"));
        this.add((Parameter)new Switch("event-arm", 'e', "event-arm", "Only run the event arm"));
        this.add((Parameter)new Switch("network-arm", 'n', "network-arm", "Only run the network arm"));
        this.add((Parameter)new Switch("validate", 'V', "validate", "Validate the recipe and exit"));
        this.add((Parameter)new Switch(CLEAN_SWITCH, 'c', CLEAN_SWITCH, "Clean the database before starting, any existing results are lost."));
        this.add((Parameter)new Switch("quick", 'q', "quick", "Run quick and dirty, the database is not saved to disk, hence no crash recovery"));
        this.add((Parameter)new Switch("invalid", 'i', "invalid", "The recipe is known to be invalid so skip the 10 second wait"));
        this.add((Parameter)new Switch(PRINT_RECIPE_SWITCH, 'r', PRINT_RECIPE_SWITCH, "Print the created recipe to stdout instead of running it"));
        this.add((Parameter)new Switch("replace-recipe", '\u0000', "replace-recipe", "Replace the recipe in the db with this one"));
        this.add((Parameter)new Switch("version", 'v', "version", "Print SOD's version and exit"));
        this.add((Parameter)new Switch(QUIT_ON_ERROR_SWITCH, '\u0000', QUIT_ON_ERROR_SWITCH, "Exit on the first error instead of retrying"));
        this.add((Parameter)new FlaggedOption("props", (StringParser)new FileParser(), null, false, 'p', "props", "A properties file to configure SOD"));
        this.add((Parameter)new FlaggedOption("recipe", (StringParser)JSAP.STRING_PARSER, null, true, 'f', "recipe", "The recipe to run"));
        this.add((Parameter)new Switch("demo", '\u0000', "demo", "Run an demo recipe. Use with -r to see the demo recipe."));
        this.result = this.jsap.parse(toParse.toArray(new String[0]));
        if (this.result.getBoolean("version")) {
            System.out.println("SOD " + Version.current().getVersion());
            System.exit(0);
        }
        if (this.result.getBoolean("help")) {
            System.err.println(Args.makeHelp(COMMAND_NAME, this.parameters));
            System.exit(0);
        }
        if (this.result.userSpecified("event-arm") && this.result.userSpecified("network-arm")) {
            this.result.addException("General", (Exception)new RuntimeException("Only one of -e and -n may be specified"));
        }
        if (!this.result.success()) {
            Start.exit(Args.makeError(COMMAND_NAME, this.parameters, this.result));
        }
    }

    public static String makeUsage(String command, List params) {
        StringBuffer builder = new StringBuffer("Usage: " + command + " [-");
        for (Parameter p : params) {
            if (!(p instanceof Switch) || ((Switch)p).getShortFlagCharacter() == null) continue;
            builder.append(((Switch)p).getShortFlagCharacter());
        }
        builder.append("] ");
        for (Parameter p : params) {
            if (!(p instanceof FlaggedOption)) continue;
            FlaggedOption fo = (FlaggedOption)p;
            if (!fo.required()) {
                builder.append('[');
            }
            if (((FlaggedOption)p).getShortFlag() != '\u0000') {
                builder.append('-');
                builder.append(((FlaggedOption)p).getShortFlag());
            } else {
                builder.append("--");
                builder.append(((FlaggedOption)p).getLongFlag());
            }
            builder.append(" <");
            builder.append(p.getID());
            builder.append('>');
            if (!fo.required()) {
                builder.append(']');
            }
            builder.append(' ');
        }
        builder.append('\n');
        return builder.toString();
    }

    public static String makeHelp(String command, List params) {
        StringBuffer buff = new StringBuffer();
        buff.append(Args.makeUsage(command, params));
        buff.append('\n');
        for (Parameter sw : params) {
            buff.append("  ");
            if (((Flagged)sw).getShortFlag() != '\u0000') {
                buff.append('-');
                buff.append(((Flagged)sw).getShortFlag());
                buff.append('/');
            }
            buff.append("--");
            buff.append(((Flagged)sw).getLongFlag());
            buff.append(' ');
            if (sw instanceof FlaggedOption) {
                FlaggedOption fo = (FlaggedOption)sw;
                if (fo.isList()) {
                    buff.append(fo.getShortFlag());
                    buff.append("1,");
                    buff.append(fo.getShortFlag());
                    buff.append("2,...,");
                    buff.append(fo.getShortFlag());
                    buff.append('n');
                } else {
                    buff.append('<');
                    buff.append(sw.getID());
                    buff.append('>');
                }
            }
            buff.append("  ");
            buff.append(sw.getHelp());
            buff.append('\n');
        }
        return buff.toString();
    }

    public static String makeError(String command, List params, JSAPResult result) {
        StringBuffer buff = new StringBuffer();
        buff.append(Args.makeUsage(command, params));
        buff.append('\n');
        Iterator it = result.getErrorMessageIterator();
        while (it.hasNext()) {
            buff.append(it.next());
            buff.append('\n');
        }
        return buff.toString();
    }

    private void add(Parameter p) throws JSAPException {
        this.jsap.registerParameter(p);
        this.parameters.add(p);
    }

    public boolean hasProps() {
        return this.result.contains("props");
    }

    public InputStream getProps() {
        try {
            return new BufferedInputStream(new FileInputStream(this.result.getFile("props")));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getInitialArgs() {
        return this.args;
    }

    public String getRecipe() {
        return this.result.getString("recipe");
    }

    public boolean isQuickAndDirty() {
        return this.result.getBoolean("quick");
    }

    public boolean isQuitOnError() {
        return this.result.getBoolean(QUIT_ON_ERROR_SWITCH);
    }

    public boolean isClean() {
        return this.result.getBoolean(CLEAN_SWITCH);
    }

    public boolean isPrintRecipe() {
        return this.result.getBoolean(PRINT_RECIPE_SWITCH);
    }

    public boolean isDebug() {
        return this.result.getBoolean("debug");
    }

    public boolean onlyValidate() {
        return this.result.getBoolean("validate");
    }

    public boolean doEventArm() {
        return this.result.getBoolean("event-arm") || !this.result.getBoolean("network-arm");
    }

    public boolean doNetArm() {
        return !this.result.getBoolean("event-arm") || this.result.getBoolean("network-arm");
    }

    public boolean doWaveformArm() {
        return !this.result.getBoolean("event-arm") && !this.result.getBoolean("network-arm");
    }

    public boolean waitOnError() {
        return !this.onlyValidate() && !this.result.getBoolean("invalid");
    }

    public boolean replaceDBConfig() {
        return this.result.getBoolean("replace-recipe");
    }

    public String toString() {
        String out = "";
        for (int i = 0; i < this.args.length; ++i) {
            out = out + " " + this.args[i];
        }
        return out;
    }

    private static class FileParser
    extends StringParser {
        private FileParser() {
        }

        public Object parse(String arg) throws ParseException {
            File f = new File(arg);
            if (!f.exists()) {
                throw new ParseException("'" + arg + "' doesn't exist");
            }
            return f;
        }
    }
}

