/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.waveserver;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.MSeedQueryClient;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.waveserver.MenuItem;
import edu.sc.seis.seisFile.waveserver.WaveServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WaveServerClient
extends MSeedQueryClient {
    String host = "eeyore.seis.sc.edu";
    int port = 16022;
    int recordSize = 12;
    boolean doSteim1 = false;
    boolean doMenu = false;

    public WaveServerClient(String[] args) throws SeisFileException {
        super(args);
        List<String> unknownArgs = this.params.getUnknownArgs();
        ArrayList<String> reallyUnknownArgs = new ArrayList<String>();
        for (int i = 0; i < unknownArgs.size(); ++i) {
            if (unknownArgs.get(i).equals("--steim1")) {
                this.doSteim1 = true;
                continue;
            }
            if (unknownArgs.get(i).equals("--menu")) {
                this.doMenu = true;
                continue;
            }
            if (i < unknownArgs.size() - 1) {
                if (unknownArgs.get(i).equals("--recLen")) {
                    this.recordSize = Integer.parseInt(unknownArgs.get(i + 1));
                    ++i;
                    continue;
                }
                if (unknownArgs.get(i).equals("-h") || unknownArgs.get(i).equals("--help")) {
                    this.host = unknownArgs.get(i + 1);
                    ++i;
                    continue;
                }
                if (unknownArgs.get(i).equals("-p")) {
                    this.port = Integer.parseInt(unknownArgs.get(i + 1));
                    ++i;
                    continue;
                }
                reallyUnknownArgs.add(unknownArgs.get(i));
                continue;
            }
            reallyUnknownArgs.add(unknownArgs.get(i));
        }
        if (reallyUnknownArgs.size() != 0) {
            String s = "";
            for (String a : reallyUnknownArgs) {
                s = s + " " + a;
            }
            System.out.println("Unknown args: " + s);
            System.out.println(this.getHelp());
            System.exit(-1);
        }
        if (this.params.getOutFile() == null) {
            this.params.setOutFile("output.mseed");
        }
        this.reader = new WaveServer(this.host, this.port);
        ((WaveServer)this.reader).setDoSteim1(this.doSteim1);
        ((WaveServer)this.reader).setRecordSize(this.recordSize);
    }

    public static void main(String[] args) throws Exception {
        WaveServerClient client = new WaveServerClient(args);
        client.readData();
    }

    @Override
    public void readData() throws IOException, SeisFileException {
        if (!(this.doMenu || this.params.getNetwork() != null && this.params.getStation() != null && this.params.getChannel() != null)) {
            System.out.println(BuildVersion.getDetailedVersion() + " one of scnl is null: n=" + this.params.getNetwork() + " s=" + this.params.getStation() + " l=" + this.params.getLocation() + " c=" + this.params.getChannel());
            System.out.println("LocId null is ok for scn, but needed for scnl");
            return;
        }
        if (this.doMenu) {
            List<MenuItem> ans = ((WaveServer)this.reader).getMenu();
            Date now = new Date();
            for (MenuItem item : ans) {
                long latency = (now.getTime() - item.getEndDate().getTime()) / 1000L;
                System.out.println(item + "  " + latency + " sec");
            }
        } else {
            super.readData();
        }
    }

    @Override
    public String getHelp() {
        return "java " + WaveServerClient.class.getName() + " " + QueryParams.getStandardHelpOptions() + "[-h host][-p port][--menu][--steim1][--recLen len(8-12)]";
    }
}

