/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.ChannelTimeWindow;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQueryParams;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.DataRecordIterator;
import edu.sc.seis.seisFile.syncFile.SyncFile;
import edu.sc.seis.seisFile.syncFile.SyncFileCompare;
import edu.sc.seis.seisFile.syncFile.SyncFileWriter;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.BasicConfigurator;

public class RefineSyncFile {
    public static void main(String[] args) throws IOException, SeisFileException {
        BasicConfigurator.configure();
        RefineSyncFile rsf = new RefineSyncFile();
        rsf.refine(args[0]);
    }

    public void refine(String syncfilename) throws IOException, SeisFileException {
        String inFilename = syncfilename;
        SyncFile sf = SyncFile.load(new File(inFilename));
        System.out.println("SyncFile " + sf.size() + " lines");
        String fileBase = SyncFileCompare.trimDotSync(inFilename);
        SyncFileWriter outSF = new SyncFileWriter(sf.getDccName() + " refined", fileBase + "_refined.sync");
        for (SyncLine sl : sf) {
            outSF.appendLine(this.refineTimes(sl, 10));
        }
        outSF.close();
    }

    ChannelTimeWindow windowDate(String n, String s, String l, String c, Date d) {
        return new ChannelTimeWindow(n, s, l, c, new Date(d.getTime() - 1L), 1);
    }

    List<ChannelTimeWindow> windowSyncLine(SyncLine sl) {
        ArrayList<ChannelTimeWindow> windowList = new ArrayList<ChannelTimeWindow>();
        windowList.add(this.windowDate(sl.getNet(), sl.getSta(), sl.getLoc(), sl.getChan(), sl.getStartTime()));
        Date endMinusOneSample = new Date(sl.getEndTime().getTime() - (long)(2 * Math.round(1.0f / RefineSyncFile.minSPSForChanCode(sl.getChan()))));
        windowList.add(this.windowDate(sl.getNet(), sl.getSta(), sl.getLoc(), sl.getChan(), endMinusOneSample));
        return windowList;
    }

    public SyncLine refineTimes(SyncLine sl, int retries) throws SeisFileException {
        int numRetry = 0;
        SeisFileException last = null;
        while (retries == 0 || numRetry < retries) {
            try {
                return this.refineTimes(sl);
            }
            catch (SeisFileException e) {
                ++numRetry;
                last = e;
                if (e.getCause() instanceof SocketTimeoutException) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw e;
            }
        }
        throw last;
    }

    public SyncLine refineTimes(SyncLine sl) throws SeisFileException {
        System.out.println("SyncLine: " + sl);
        FDSNDataSelectQueryParams queryParams = new FDSNDataSelectQueryParams();
        List<ChannelTimeWindow> windowList = this.windowSyncLine(sl);
        FDSNDataSelectQuerier querier = new FDSNDataSelectQuerier(queryParams, windowList);
        DataRecordIterator it = querier.getDataRecordIterator();
        Date s = sl.getStartTime();
        Date e = sl.getEndTime();
        ArrayList<DataRecord> drList = new ArrayList<DataRecord>();
        try {
            while (it.hasNext()) {
                drList.add(it.next());
            }
            if (drList.size() == 0) {
                return sl;
            }
            Object prev = null;
            boolean gapFound = false;
            for (DataRecord dr : drList) {
                System.out.println(dr.getHeader().getStartTime() + "  " + dr.getHeader().getEndTime() + " " + dr.getHeader().getPredictedNextStartBtime());
            }
            Date drS = ((DataRecord)drList.get(0)).getHeader().getStartBtime().convertToCalendar().getTime();
            Date drE = ((DataRecord)drList.get(drList.size() - 1)).getHeader().getPredictedNextStartBtime().convertToCalendar().getTime();
            if (Math.abs(s.getTime() - drS.getTime()) < 1000L) {
                s = drS;
            }
            if (Math.abs(e.getTime() - drE.getTime()) < 1000L) {
                e = drE;
            }
            SyncLine out = new SyncLine(sl, s, e);
            System.out.println("Out " + out);
            return out;
        }
        catch (IOException ee) {
            throw new SeisFileException(ee);
        }
    }

    public static float minSPSForChanCode(String chan) {
        char c = chan.charAt(0);
        switch (c) {
            case 'F': 
            case 'G': {
                return 1000.0f;
            }
            case 'C': 
            case 'D': {
                return 250.0f;
            }
            case 'E': 
            case 'H': {
                return 80.0f;
            }
            case 'B': 
            case 'S': {
                return 10.0f;
            }
            case 'L': 
            case 'M': {
                return 1.0f;
            }
            case 'V': {
                return 0.1f;
            }
            case 'U': {
                return 0.01f;
            }
            case 'R': {
                return 1.0E-4f;
            }
            case 'P': {
                return 1.0E-5f;
            }
            case 'T': {
                return 1.0E-6f;
            }
            case 'Q': {
                return 1.0E-6f;
            }
        }
        return 1.0f;
    }
}

