/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.MissingBlockette1000;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class MiniSeedRead {
    protected int numRead = 0;
    protected DataInput inStream;
    protected int recordSize;
    protected boolean readData;

    protected MiniSeedRead() {
    }

    public MiniSeedRead(DataInput inStream) throws IOException {
        this.inStream = inStream;
    }

    public void close() throws IOException {
        this.inStream = null;
    }

    public SeedRecord getNextRecord() throws SeedFormatException, IOException {
        return this.getNextRecord(0);
    }

    public SeedRecord getNextRecord(int defaultRecordSize) throws SeedFormatException, IOException {
        return SeedRecord.read(this.inStream, defaultRecordSize);
    }

    public int getNumRecordsRead() {
        return this.numRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FilterInputStream ls = null;
        PrintWriter out = new PrintWriter(System.out, true);
        int maxPackets = -1;
        try {
            out.println("open socket");
            if (args.length == 0) {
                out.println("Usage: java " + MiniSeedRead.class.getName() + " filename");
            } else {
                ls = new DataInputStream(new BufferedInputStream(new FileInputStream(args[0]), 4096));
            }
            MiniSeedRead rf = new MiniSeedRead((DataInput)((Object)ls));
            for (int i = 0; maxPackets == -1 || i < maxPackets; ++i) {
                SeedRecord sr;
                try {
                    sr = rf.getNextRecord();
                }
                catch (MissingBlockette1000 e) {
                    out.println("Missing Blockette1000, trying with record size of 4096");
                    sr = rf.getNextRecord(4096);
                }
                sr.writeASCII(out, "    ");
                if (!(sr instanceof DataRecord)) continue;
                DataRecord dr = (DataRecord)sr;
                byte[] byArray = dr.getData();
            }
        }
        catch (EOFException e) {
            System.out.println("EOF, so done.");
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        finally {
            try {
                if (ls != null) {
                    ls.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

