/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.gcf;

import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import edu.sc.seis.seisFile.gcf.GCFBlock;
import edu.sc.seis.seisFile.gcf.GCFFormatException;
import edu.sc.seis.seisFile.gcf.GCFHeader;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Convert {
    public static final int NOV_17_DAY_OF_YEAR = 321;
    Map<String, String[]> sysId_streamIdToSCNL;
    public static final TimeZone TZ_GMT = TimeZone.getTimeZone("GMT");
    private static final Logger logger = LoggerFactory.getLogger(Convert.class);

    public Convert(Map<String, String[]> sysId_streamIdToSCNL) {
        this.sysId_streamIdToSCNL = sysId_streamIdToSCNL;
    }

    public TraceBuf2 toTraceBuf(GCFBlock block) throws GCFFormatException {
        GCFHeader h = block.getHeader();
        String[] scnl = this.sysId_streamIdToSCNL.get(h.getSystemId() + "_" + h.getStreamId());
        if (scnl == null) {
            scnl = new String[]{h.getStreamId().substring(0, 4), "EN" + h.getStreamId().charAt(4), "XX", "0" + h.getStreamId().charAt(5)};
            this.sysId_streamIdToSCNL.put(h.getSystemId() + "_" + h.getStreamId(), scnl);
            logger.warn("Unknown stream id: " + h.getSystemId() + "_" + h.getStreamId());
        }
        Calendar startTime = Convert.convertTime(h.getDayNumber(), h.getSecondsInDay(), (float)h.getStartOffsetNumerator() / h.getStartOffsetDenominator());
        TraceBuf2 out = new TraceBuf2(0, h.getNumPoints(), (double)startTime.getTimeInMillis() / 1000.0, (double)h.getSps(), scnl[0], scnl[2], scnl[1], scnl[3], block.getUndiffData());
        return out;
    }

    public static Calendar convertTime(int dayNumber, int secInDay, float fracSeconds) {
        Calendar cal = Calendar.getInstance(TZ_GMT);
        cal.set(1, 1989);
        cal.set(6, 321);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(6, dayNumber);
        cal.add(13, secInDay);
        cal.add(14, Math.round(fracSeconds * 1000.0f));
        return cal;
    }

    public static int[] convertTime(Date dateTime) {
        int[] daySec = new int[2];
        Calendar cal = Calendar.getInstance(TZ_GMT);
        cal.setTime(dateTime);
        daySec[0] = 45;
        daySec[0] = daySec[0] + 365 * (cal.get(1) - 1990);
        if (cal.get(1) % 4 == 0 && cal.get(6) >= 60) {
            daySec[0] = daySec[0] - 1;
        }
        daySec[0] = daySec[0] + (cal.get(6) - 1);
        daySec[0] = daySec[0] + (cal.get(1) - 1988) / 4;
        daySec[1] = cal.get(13);
        daySec[1] = daySec[1] + cal.get(12) * 60;
        daySec[1] = daySec[1] + cal.get(11) * 3600;
        return daySec;
    }
}

