/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatNoUnitType;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class FloatType
extends FloatNoUnitType {
    String unit;

    public FloatType(XMLEventReader reader, String tagName) throws StationXMLException, XMLStreamException {
        this(reader, tagName, null);
    }

    public FloatType(XMLEventReader reader, String tagName, String fixedUnit) throws StationXMLException, XMLStreamException {
        super(tagName);
        StartElement startE = StaxUtil.expectStartElement(tagName, reader);
        super.parseAttributes(startE);
        super.parseValue(reader);
        this.parseUnitAttr(startE, fixedUnit);
    }

    void parseUnitAttr(StartElement startE, String fixedUnit) throws StationXMLException {
        String unitStr = StaxUtil.pullAttributeIfExists(startE, "unit");
        this.unit = unitStr != null ? unitStr : fixedUnit;
    }

    public String toString() {
        String out = "" + this.getValue();
        if (this.hasPlusError() || this.hasMinusError()) {
            out = out + "(";
            if (this.hasPlusError()) {
                out = out + "+" + this.getPlusError();
            }
            if (this.hasMinusError()) {
                if (this.hasPlusError()) {
                    out = out + " ";
                }
                out = out + this.getMinusError();
            }
            out = out + ")";
        }
        return out;
    }

    public String getUnit() {
        return this.unit;
    }
}

