/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class FloatNoUnitType {
    String tagName;
    float value;
    Float plusError;
    Float minusError;

    FloatNoUnitType(String tagName) throws XMLStreamException, StationXMLException {
        this.tagName = tagName;
    }

    public FloatNoUnitType(XMLEventReader reader, String tagName) throws XMLStreamException, StationXMLException {
        this(tagName);
        StartElement startE = StaxUtil.expectStartElement(tagName, reader);
        this.parseAttributes(startE);
        this.parseValue(reader);
    }

    void parseAttributes(StartElement startE) throws StationXMLException {
        String plusErrorStr = StaxUtil.pullAttributeIfExists(startE, "plusError");
        String minusErrorStr = StaxUtil.pullAttributeIfExists(startE, "minusError");
        if (plusErrorStr != null) {
            this.plusError = Float.valueOf(Float.parseFloat(plusErrorStr));
        }
        if (minusErrorStr != null) {
            this.minusError = Float.valueOf(Float.parseFloat(minusErrorStr));
        }
    }

    void parseValue(XMLEventReader reader) throws StationXMLException, XMLStreamException {
        this.value = Float.parseFloat(StaxUtil.pullContiguousText(reader));
    }

    public FloatNoUnitType(float coefficient, Float plusError, Float minusError, String tagName) throws StationXMLException, XMLStreamException {
        this(tagName);
        this.value = coefficient;
        this.plusError = plusError;
        this.minusError = minusError;
    }

    public String getTagName() {
        return this.tagName;
    }

    public float getValue() {
        return this.value;
    }

    public Float getPlusError() {
        return this.plusError;
    }

    public Float getMinusError() {
        return this.minusError;
    }

    public boolean hasPlusError() {
        return this.plusError != null;
    }

    public boolean hasMinusError() {
        return this.minusError != null;
    }
}

