/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.Comment;
import edu.sc.seis.seisFile.fdsnws.stationxml.DataAvailability;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class BaseNodeType {
    String code;
    String startDate;
    String endDate;
    String historicalCode;
    String alternateCode;
    String restrictedStatus;
    String description;
    List<Comment> commentList = new ArrayList<Comment>();
    DataAvailability dataAvailability;

    void parseAttributes(StartElement startE) throws StationXMLException {
        this.code = StaxUtil.pullAttribute(startE, "code");
        this.startDate = StaxUtil.pullAttributeIfExists(startE, "startDate");
        this.endDate = StaxUtil.pullAttributeIfExists(startE, "endDate");
        this.historicalCode = StaxUtil.pullAttributeIfExists(startE, "historicalCode");
        this.alternateCode = StaxUtil.pullAttributeIfExists(startE, "alternateCode");
        this.restrictedStatus = StaxUtil.pullAttributeIfExists(startE, "restrictedStatus");
    }

    boolean parseSubElement(String elName, XMLEventReader reader) throws StationXMLException, XMLStreamException {
        if (elName.equals("Description")) {
            this.description = StaxUtil.pullText(reader, "Description");
            return true;
        }
        if (elName.equals("Comment")) {
            this.commentList.add(new Comment(reader, "Comment"));
            return true;
        }
        if (elName.equals("DataAvailability")) {
            this.dataAvailability = new DataAvailability(reader);
            return true;
        }
        return false;
    }

    public String getCode() {
        return this.code;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getHistoricalCode() {
        return this.historicalCode;
    }

    public String getAlternateCode() {
        return this.alternateCode;
    }

    public String getRestrictedStatus() {
        return this.restrictedStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public DataAvailability getDataAvailability() {
        return this.dataAvailability;
    }
}

