/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.fdsnws.QueryTime;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeQueryLog {
    static int totalQueries = 0;
    static HashMap<String, LinkedList<QueryTime>> recentQueries = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(TimeQueryLog.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(URI uri) {
        ++totalQueries;
        QueryTime current = new QueryTime(uri);
        LinkedList<QueryTime> byHost = null;
        HashMap<String, LinkedList<QueryTime>> hashMap = recentQueries;
        synchronized (hashMap) {
            byHost = recentQueries.get(uri.getHost());
            if (byHost == null) {
                byHost = new LinkedList();
                recentQueries.put(uri.getHost(), byHost);
            }
        }
        int numLastSec = 1;
        long secondAgo = new Date().getTime() - 1000L;
        LinkedList<QueryTime> linkedList = byHost;
        synchronized (linkedList) {
            Iterator iterator = byHost.iterator();
            while (iterator.hasNext()) {
                QueryTime timeQuery = (QueryTime)iterator.next();
                if (timeQuery.getWhen().getTime() > secondAgo) {
                    ++numLastSec;
                    continue;
                }
                iterator.remove();
            }
            byHost.add(current);
            if (numLastSec >= 10) {
                logger.warn("More than 10 queries in last second for " + uri.getHost() + "!!! " + numLastSec);
                for (QueryTime timeQuery : byHost) {
                    logger.warn("  " + timeQuery.getWhen() + "  " + timeQuery.getURI());
                }
            }
        }
    }
}

