/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.HexNumberFormat;
import com.ice.jni.registry.NoSuchKeyException;
import com.ice.jni.registry.NoSuchValueException;
import com.ice.jni.registry.RegBinaryValue;
import com.ice.jni.registry.RegDWordValue;
import com.ice.jni.registry.RegMultiStringValue;
import com.ice.jni.registry.RegStringValue;
import com.ice.jni.registry.RegistryException;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Registry {
    public static RegistryKey HKEY_CLASSES_ROOT;
    public static RegistryKey HKEY_CURRENT_USER;
    public static RegistryKey HKEY_LOCAL_MACHINE;
    public static RegistryKey HKEY_USERS;
    public static RegistryKey HKEY_PERFORMANCE_DATA;
    public static RegistryKey HKEY_CURRENT_CONFIG;
    public static RegistryKey HKEY_DYN_DATA;
    private static RegistryKey HKEY_ICE_TESTKEY;
    private static String[] preDefines;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_INVALID_HANDLE = 6;
    public static final int ERROR_INVALID_PARAMETER = 87;
    public static final int ERROR_CALL_NOT_IMPLEMENTED = 120;
    public static final int ERROR_INSUFFICIENT_BUFFER = 122;
    public static final int ERROR_LOCK_FAILED = 167;
    public static final int ERROR_TRANSFER_TOO_LONG = 222;
    public static final int ERROR_MORE_DATA = 234;
    public static final int ERROR_NO_MORE_ITEMS = 259;
    public static final int ERROR_BADDB = 1009;
    public static final int ERROR_BADKEY = 1010;
    public static final int ERROR_CANTOPEN = 1011;
    public static final int ERROR_CANTREAD = 1012;
    public static final int ERROR_CANTWRITE = 1013;
    public static final int ERROR_REGISTRY_RECOVERED = 1014;
    public static final int ERROR_REGISTRY_CORRUPT = 1015;
    public static final int ERROR_REGISTRY_IO_FAILED = 1016;
    public static final int ERROR_NOT_REGISTRY_FILE = 1017;
    public static final int ERROR_KEY_DELETED = 1018;
    private static final int ROW_BYTES = 16;
    private static final int ROW_QTR1 = 3;
    private static final int ROW_HALF = 7;
    private static final int ROW_QTR2 = 11;
    private static String saveKey;
    private static Hashtable topLevelKeys;
    public boolean debugLevel;

    public static RegistryKey getTopLevelKey(String keyName) {
        return (RegistryKey)topLevelKeys.get(keyName);
    }

    public static RegistryKey openSubkey(RegistryKey topKey, String keyName, int access) {
        RegistryKey subKey = null;
        try {
            subKey = topKey.openSubKey(keyName, access);
        }
        catch (NoSuchKeyException ex) {
            subKey = null;
        }
        catch (RegistryException ex) {
            subKey = null;
        }
        return subKey;
    }

    public static String getErrorMessage(int errCode) {
        switch (errCode) {
            case 0: {
                return "success";
            }
            case 2: {
                return "key or value not found";
            }
            case 5: {
                return "access denied";
            }
            case 6: {
                return "invalid handle";
            }
            case 87: {
                return "invalid parameter";
            }
            case 120: {
                return "call not implemented";
            }
            case 122: {
                return "insufficient buffer";
            }
            case 167: {
                return "lock failed";
            }
            case 222: {
                return "transfer was too long";
            }
            case 234: {
                return "more data buffer needed";
            }
            case 259: {
                return "no more items";
            }
            case 1009: {
                return "bad database";
            }
            case 1010: {
                return "bad key";
            }
            case 1011: {
                return "can not open";
            }
            case 1012: {
                return "can not read";
            }
            case 1013: {
                return "can not write";
            }
            case 1014: {
                return "registry recovered";
            }
            case 1015: {
                return "registry corrupt";
            }
            case 1016: {
                return "registry IO failed";
            }
            case 1017: {
                return "not a registry file";
            }
            case 1018: {
                return "key has been deleted";
            }
        }
        return "errCode=".concat(String.valueOf(String.valueOf(errCode)));
    }

    public static void exportRegistryKey(String pathName, RegistryKey key, boolean descend) throws RegistryException, NoSuchKeyException, IOException {
        PrintWriter out = new PrintWriter(new FileWriter(pathName));
        out.println("REGEDIT4");
        out.println("");
        key.export(out, descend);
        out.flush();
        out.close();
    }

    public static void main(String[] argv) {
        preDefines = new String[10];
        Registry.preDefines[0] = "HKLM\\System\\CurrentControlSet\\control";
        Registry.preDefines[1] = "HKLM\\Software";
        Registry.preDefines[2] = "HKLM\\Software\\Miscrosoft";
        Registry.preDefines[3] = "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion";
        Registry.preDefines[4] = "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\ProfileList";
        Registry.preDefines[5] = "HKCU\\Software";
        Registry.preDefines[6] = "HKCU\\Software\\Microsoft";
        Registry.preDefines[7] = "HKCU\\AppEvents";
        Registry.preDefines[8] = "HKCU\\AppEvents\\Schemes";
        Registry.preDefines[9] = "HKCU\\AppEvents\\Schemes";
        try {
            HKEY_ICE_TESTKEY = HKEY_CURRENT_USER.openSubKey("Software\\ICE Engineering\\test");
        }
        catch (NoSuchKeyException noSuchKeyException) {
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        if (argv.length > 0) {
            Registry.subMain(argv);
        } else {
            String saveLine = null;
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                String[] subArgs;
                String inLine;
                System.out.print("command: ");
                System.out.flush();
                try {
                    inLine = input.readLine();
                }
                catch (IOException ex) {
                    inLine = null;
                }
                System.out.println("command is ".concat(String.valueOf(String.valueOf(inLine))));
                if (inLine == null || inLine.length() == 0) break;
                if (inLine.equalsIgnoreCase("help")) {
                    Registry.usage(null);
                    continue;
                }
                if (inLine.equals("!!") && saveLine != null) {
                    subArgs = Registry.parseArgumentString(saveLine);
                } else {
                    subArgs = Registry.parseArgumentString(inLine);
                    saveLine = inLine;
                }
                Registry.subMain(subArgs);
            }
        }
    }

    public static void usage(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println("keys regKey -- print the key names");
        System.err.println("values regKey -- print the value names");
        System.err.println("data regKey subKey -- print the key's data");
        System.err.println("string regKey subKey -- print REG_SZ key's string");
        System.err.println("setbin regKey subKey  binaryString -- set REG_BINARY");
        System.err.println("setdw regKey subKey int -- set REG_DWORD");
        System.err.println("setstr regKey subKey string -- set REG_SZ");
        System.err.println("setmulti regKey subKey semiColonString -- set REG_MULTI_SZ");
        System.err.println("delkey regKey subKey -- delete key 'subKey' of regKey");
        System.err.println("delval regKey subKey -- delete value 'subKey' of regKey");
        System.err.println("export regKey fileName -- export registry key to fileName");
        System.err.println("expand regKey valueName -- expand string value");
        System.err.println("");
        System.err.println("!! -- repeats last command");
        System.err.println("$$ -- re-uses previous keyname");
        System.err.println("Predefined Key Prefixes: (e.g. $0-9)");
        for (int idx = 0; idx < preDefines.length; ++idx) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("   $").append(idx).append("=").append(preDefines[idx]))));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void subMain(String[] argv) {
        void var8_16;
        void var8_12;
        int index;
        void var8_10;
        RegistryKey topKey = null;
        boolean isRemote = false;
        String topKeyName = null;
        String hostName = null;
        if (argv.length < 1 || argv[0].equals("help")) {
            Registry.usage(null);
            return;
        }
        if (argv.length < 2) {
            Registry.usage(null);
            return;
        }
        String string = argv[1];
        if (saveKey != null && string.equals("$$")) {
            String string2 = saveKey;
        } else if (string.equals("@@")) {
            String string3 = "HKCU\\Software\\ICE Engineering\\test";
        } else {
            char ch1 = string.charAt(0);
            char ch2 = string.charAt(1);
            if (ch1 == '$' && ch2 >= '0' && ch2 <= '9') {
                int pIdx = ch2 - 48;
                if (preDefines[pIdx] == null) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Predefine '").append(string).append("' not defined."))));
                    return;
                }
                if (string.length() < 3) {
                    String string4 = preDefines[pIdx];
                } else {
                    String string5 = String.valueOf(String.valueOf(preDefines[pIdx])).concat(String.valueOf(String.valueOf(string.substring(2))));
                }
            } else {
                saveKey = argv[1];
            }
        }
        if (var8_10.startsWith("\\\\")) {
            isRemote = true;
            index = var8_10.indexOf(92, 2);
            hostName = var8_10.substring(2, index);
            String string6 = var8_10.substring(index + 1);
        }
        if ((index = var8_12.indexOf(92)) < 0) {
            topKeyName = var8_12;
            Object var8_13 = null;
        } else {
            if (index < 4) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("Invalid key '").append((String)var8_12).append("', top level key name too short."))));
                return;
            }
            topKeyName = var8_12.substring(0, index);
            if (index + 1 >= var8_12.length()) {
                Object var8_14 = null;
            } else {
                String string7 = var8_12.substring(index + 1);
            }
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("topKeyName is >").append(topKeyName).append("<"))));
        topKey = Registry.getTopLevelKey(topKeyName);
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("topKey is >").append(topKey).append("<"))));
        if (topKey == null) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR, toplevel key '").append(topKeyName).append("' not resolved!"))));
            return;
        }
        if (isRemote) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("REMOTE Key host='").append(hostName).append("'"))));
            RegistryKey remoteKey = null;
            try {
                remoteKey = topKey.connectRegistry(hostName);
            }
            catch (NoSuchKeyException ex) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR No such key connecting to '").append(hostName).append("', ").append(ex.getMessage()))));
                return;
            }
            catch (RegistryException ex) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR errCode=").append(ex.getErrorCode()).append("' connecting to '").append(hostName).append("', ").append(ex.getMessage()))));
                return;
            }
            if (remoteKey != null) {
                topKey = remoteKey;
            }
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("topKeyName is >").append(topKeyName).append("<"))));
        if (argv[0].equalsIgnoreCase("create")) {
            Registry.createCommand(topKey, (String)var8_16);
            return;
        }
        if (argv[0].equalsIgnoreCase("setbin")) {
            Registry.setBinaryCommand(topKey, (String)var8_16, argv[2], argv[3]);
            return;
        }
        if (argv[0].equalsIgnoreCase("setdw")) {
            Registry.setBinaryCommand(topKey, (String)var8_16, argv[2], argv[3]);
            return;
        }
        if (argv[0].equalsIgnoreCase("setstr")) {
            Registry.setStringCommand(topKey, (String)var8_16, argv[2], argv[3]);
            return;
        }
        if (argv[0].equalsIgnoreCase("setmulti")) {
            Registry.setMultiStringCommand(topKey, (String)var8_16, argv[2], argv[3]);
            return;
        }
        if (argv[0].equalsIgnoreCase("keys")) {
            Registry.listKeysCommand(topKey, (String)var8_16);
            return;
        }
        if (argv[0].equalsIgnoreCase("values")) {
            Registry.listValuesCommand(topKey, (String)var8_16);
            return;
        }
        if (argv[0].equalsIgnoreCase("delkey")) {
            Registry.deleteKeyCommand(topKey, (String)var8_16, argv[2]);
            return;
        }
        if (argv[0].equalsIgnoreCase("delval")) {
            Registry.deleteValueCommand(topKey, (String)var8_16, argv[2]);
            return;
        }
        if (argv[0].equalsIgnoreCase("data")) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("topkey is >").append(topKey).append("<"))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("keyname is >").append((String)var8_16).append("<"))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("argv[2] is >").append(argv[2]).append("<"))));
            Registry.getDataCommand(topKey, (String)var8_16, argv[2]);
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("topKeyName is >").append(topKeyName).append("<"))));
            topKey = Registry.getTopLevelKey(topKeyName);
            return;
        }
        if (argv[0].equalsIgnoreCase("string")) {
            Registry.getStringCommand(topKey, (String)var8_16, argv[2]);
            return;
        }
        if (argv[0].equalsIgnoreCase("export")) {
            Registry.exportKeyCommand(topKey, (String)var8_16, argv[2]);
            return;
        }
        if (!argv[0].equalsIgnoreCase("expand")) return;
        Registry.expandStringCommand(topKey, (String)var8_16, argv[2]);
    }

    private static void exportKeyCommand(RegistryKey topKey, String keyName, String pathName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        try {
            Registry.exportRegistryKey(pathName, subKey, true);
        }
        catch (IOException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("IO Exception: '").append(ex.getMessage()).append("'"))));
        }
        catch (NoSuchKeyException ex) {
            System.err.println("Error, encountered non-existent key during export.");
        }
        catch (RegistryException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR registry error=").append(ex.getErrorCode()).append(", ").append(ex.getMessage()))));
        }
    }

    public static void getDataCommand(RegistryKey topKey, String keyName, String valueName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        RegistryValue data = null;
        try {
            data = subKey.getValue(valueName);
        }
        catch (NoSuchValueException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("Value '").append(valueName).append("' does not exist."))));
            return;
        }
        catch (RegistryException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR registry error=").append(ex.getErrorCode()).append(", ").append(ex.getMessage()))));
            return;
        }
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("Value '").append(valueName).append("' is ").append(data.toString()))));
        if (data instanceof RegStringValue) {
            RegStringValue val = (RegStringValue)data;
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("REG_SZ '").append(val.getData()).append("'"))));
        } else if (data instanceof RegMultiStringValue) {
            RegMultiStringValue val = (RegMultiStringValue)data;
            String[] args = val.getData();
            for (int idx = 0; idx < args.length; ++idx) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("REG_MULTI_SZ[").append(idx).append("] '").append(args[idx]).append("'"))));
            }
        } else if (data instanceof RegDWordValue) {
            RegDWordValue val = (RegDWordValue)data;
            HexNumberFormat xFmt = new HexNumberFormat("XXXXXXXX");
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("REG_DWORD").append(5 == val.getType() ? "_BIG_ENDIAN" : "").append(" '").append(val.getData()).append("' [x").append(xFmt.format(val.getData())).append("]"))));
        } else {
            RegBinaryValue val = (RegBinaryValue)data;
            Registry.dumpHexData(System.err, String.valueOf(String.valueOf(new StringBuffer("REG_BINARY '").append(val.getName()).append("', len=").append(val.getLength()))), val.getData(), val.getLength());
        }
    }

    private static void getStringCommand(RegistryKey topKey, String keyName, String valueName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        try {
            String value = subKey.getStringValue(valueName);
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("String Value ").append(valueName).append("='").append(value).append("'"))));
        }
        catch (RegistryException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR getting value '").append(valueName).append("', ").append(ex.getMessage()))));
            return;
        }
    }

    private static void expandStringCommand(RegistryKey topKey, String keyName, String valueName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        try {
            String value = subKey.getStringValue(valueName);
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("String Value ").append(valueName).append("='").append(value).append("'"))));
            value = RegistryKey.expandEnvStrings(value);
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("Expanded Value ").append(valueName).append("='").append(value).append("'"))));
        }
        catch (RegistryException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR getting value '").append(valueName).append("', ").append(ex.getMessage()))));
            return;
        }
    }

    private static void deleteKeyCommand(RegistryKey topKey, String keyName, String deleteKeyName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        try {
            subKey.deleteSubKey(deleteKeyName);
        }
        catch (NoSuchKeyException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("Key '").append(keyName).append("\\").append(deleteKeyName).append("' does not exist."))));
            return;
        }
        catch (RegistryException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR deleting key '").append(keyName).append("', ").append(ex.getMessage()))));
            return;
        }
    }

    private static void deleteValueCommand(RegistryKey topKey, String keyName, String valueName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        try {
            subKey.deleteValue(valueName);
        }
        catch (NoSuchValueException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("Value '").append(valueName).append("' does not exist."))));
            return;
        }
        catch (RegistryException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR deleting value '").append(valueName).append("', ").append(ex.getMessage()))));
            return;
        }
    }

    private static void listKeysCommand(RegistryKey topKey, String keyName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        try {
            Enumeration enumeration = subKey.keyElements();
            int kIdx = 0;
            while (enumeration.hasMoreElements()) {
                String keyStr = (String)enumeration.nextElement();
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("Subkey[").append(kIdx).append("] = '").append(keyStr).append("'"))));
                ++kIdx;
            }
        }
        catch (RegistryException ex) {
            System.err.println("ERROR getting key enumerator, ".concat(String.valueOf(String.valueOf(ex.getMessage()))));
            return;
        }
    }

    private static void listValuesCommand(RegistryKey topKey, String keyName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        try {
            Enumeration enumeration = subKey.valueElements();
            int kIdx = 0;
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("Value Name[").append(kIdx).append("] = '").append(name).append("'"))));
                ++kIdx;
            }
        }
        catch (RegistryException ex) {
            System.err.println("ERROR getting value enumerator, ".concat(String.valueOf(String.valueOf(ex.getMessage()))));
            return;
        }
    }

    private static void setDWordCommand(RegistryKey topKey, String keyName, String valueName, String data) {
        int anInt;
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        try {
            anInt = Integer.parseInt(data);
        }
        catch (NumberFormatException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR bad int: '").append(ex.getMessage()).append("'"))));
            return;
        }
        RegDWordValue val = new RegDWordValue(subKey, valueName);
        val.setData(anInt);
        Registry.setValue(subKey, val);
    }

    private static void setMultiStringCommand(RegistryKey topKey, String keyName, String valueName, String data) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        String[] strArray = Registry.splitString(data, ";");
        RegMultiStringValue val = new RegMultiStringValue(subKey, valueName, strArray);
        Registry.setValue(subKey, val);
    }

    private static void setStringCommand(RegistryKey topKey, String keyName, String valueName, String data) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        RegStringValue val = new RegStringValue(subKey, valueName, data);
        Registry.setValue(subKey, val);
    }

    private static void setBinaryCommand(RegistryKey topKey, String keyName, String valueName, String data) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        byte[] binData = data.getBytes();
        RegBinaryValue val = new RegBinaryValue(subKey, valueName, binData);
        Registry.setValue(subKey, val);
    }

    private static void createCommand(RegistryKey topKey, String keyName) {
        RegistryKey subKey;
        try {
            subKey = topKey.createSubKey(keyName, "", 2);
        }
        catch (RegistryException ex) {
            subKey = null;
            System.err.println("ERROR creating subKey: ".concat(String.valueOf(String.valueOf(ex.getMessage()))));
        }
        if (subKey != null) {
            try {
                subKey.flushKey();
                subKey.closeKey();
            }
            catch (RegistryException ex) {
                subKey = null;
                System.err.println("ERROR flushing and closing key: ".concat(String.valueOf(String.valueOf(ex.getMessage()))));
            }
        }
        if (subKey != null) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("SUCCEEDED ").append(subKey.wasCreated() ? "Creating" : "Opening via create").append(" Key '").append(keyName).append("'"))));
        } else {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("FAILED Creating Key '").append(keyName).append("'"))));
        }
    }

    private static RegistryKey openSubKeyVerbose(RegistryKey topKey, String keyName, int access) {
        RegistryKey subKey = null;
        try {
            subKey = topKey.openSubKey(keyName, access);
        }
        catch (NoSuchKeyException ex) {
            subKey = null;
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("Key '").append(keyName).append("' does not exist."))));
        }
        catch (RegistryException ex) {
            subKey = null;
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR registry error=").append(ex.getErrorCode()).append(", ").append(ex.getMessage()))));
        }
        return subKey;
    }

    private static void setValue(RegistryKey subKey, RegistryValue value) {
        try {
            subKey.setValue(value);
            subKey.flushKey();
        }
        catch (RegistryException ex) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR setting MULTI_SZ value '").append(value.getName()).append("', ").append(ex.getMessage()))));
        }
    }

    public static void dumpHexData(PrintStream out, String title, byte[] buf, int numBytes) {
        PrintWriter wrtr = new PrintWriter(new OutputStreamWriter(out));
        Registry.dumpHexData(wrtr, title, buf, 0, numBytes);
    }

    public static void dumpHexData(PrintWriter out, String title, byte[] buf, int offset, int numBytes) {
        String saveStr;
        int j;
        String idxStr;
        int hexVal;
        int i;
        byte[] save_buf = new byte[18];
        char[] hex_buf = new char[4];
        char[] idx_buf = new char[8];
        char[] hex_chars = new char[20];
        hex_chars[0] = 48;
        hex_chars[1] = 49;
        hex_chars[2] = 50;
        hex_chars[3] = 51;
        hex_chars[4] = 52;
        hex_chars[5] = 53;
        hex_chars[6] = 54;
        hex_chars[7] = 55;
        hex_chars[8] = 56;
        hex_chars[9] = 57;
        hex_chars[10] = 65;
        hex_chars[11] = 66;
        hex_chars[12] = 67;
        hex_chars[13] = 68;
        hex_chars[14] = 69;
        hex_chars[15] = 70;
        out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(title))).append(" - ").append(numBytes).append(" bytes."))));
        int rows = numBytes >> 4;
        int residue = numBytes & 0xF;
        for (i = 0; i < rows; ++i) {
            hexVal = i * 16;
            idx_buf[0] = hex_chars[hexVal >> 12 & 0xF];
            idx_buf[1] = hex_chars[hexVal >> 8 & 0xF];
            idx_buf[2] = hex_chars[hexVal >> 4 & 0xF];
            idx_buf[3] = hex_chars[hexVal & 0xF];
            idxStr = new String(idx_buf, 0, 4);
            out.print(String.valueOf(String.valueOf(idxStr)).concat(": "));
            for (j = 0; j < 16; ++j) {
                save_buf[j] = buf[offset + i * 16 + j];
                hex_buf[0] = hex_chars[save_buf[j] >> 4 & 0xF];
                hex_buf[1] = hex_chars[save_buf[j] & 0xF];
                out.print(hex_buf[0]);
                out.print(hex_buf[1]);
                out.print(' ');
                if (j == 3 || j == 7 || j == 11) {
                    out.print(" ");
                }
                if (save_buf[j] >= 32 && save_buf[j] <= 126) continue;
                save_buf[j] = 46;
            }
            saveStr = new String(save_buf, 0, j);
            out.println(String.valueOf(String.valueOf(new StringBuffer(" | ").append(saveStr).append(" |"))));
        }
        if (residue > 0) {
            hexVal = i * 16;
            idx_buf[0] = hex_chars[hexVal >> 12 & 0xF];
            idx_buf[1] = hex_chars[hexVal >> 8 & 0xF];
            idx_buf[2] = hex_chars[hexVal >> 4 & 0xF];
            idx_buf[3] = hex_chars[hexVal & 0xF];
            idxStr = new String(idx_buf, 0, 4);
            out.print(String.valueOf(String.valueOf(idxStr)).concat(": "));
            for (j = 0; j < residue; ++j) {
                save_buf[j] = buf[offset + i * 16 + j];
                hex_buf[0] = hex_chars[save_buf[j] >> 4 & 0xF];
                hex_buf[1] = hex_chars[save_buf[j] & 0xF];
                out.print(hex_buf[0]);
                out.print(hex_buf[1]);
                out.print(' ');
                if (j == 3 || j == 7 || j == 11) {
                    out.print(" ");
                }
                if (save_buf[j] >= 32 && save_buf[j] <= 126) continue;
                save_buf[j] = 46;
            }
            while (j < 16) {
                save_buf[j] = 32;
                out.print("   ");
                if (j == 3 || j == 7 || j == 11) {
                    out.print(" ");
                }
                ++j;
            }
            saveStr = new String(save_buf, 0, j);
            out.println(String.valueOf(String.valueOf(new StringBuffer(" | ").append(saveStr).append(" |"))));
        }
    }

    public static String[] splitString(String splitStr, String delim) {
        StringTokenizer toker = new StringTokenizer(splitStr, delim);
        int count = toker.countTokens();
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            try {
                result[i] = toker.nextToken();
                continue;
            }
            catch (NoSuchElementException ex) {
                result = null;
                break;
            }
        }
        return result;
    }

    public static String[] parseArgumentString(String argStr) {
        Object[] result = null;
        Vector vector = Registry.parseArgumentVector(argStr);
        if (vector != null && vector.size() > 0) {
            result = new String[vector.size()];
            vector.copyInto(result);
        }
        return result;
    }

    public static Vector parseArgumentVector(String argStr) {
        Vector<String> result = new Vector<String>();
        StringBuffer argBuf = new StringBuffer();
        boolean backSlash = false;
        boolean matchSglQuote = false;
        boolean matchDblQuote = false;
        block13: for (int cIdx = 0; cIdx < argStr.length(); ++cIdx) {
            char ch = argStr.charAt(cIdx);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (backSlash) {
                        argBuf.append(ch);
                        backSlash = false;
                        continue block13;
                    }
                    if (matchSglQuote || matchDblQuote) {
                        argBuf.append(ch);
                        continue block13;
                    }
                    if (argBuf.length() <= 0) continue block13;
                    result.addElement(argBuf.toString());
                    argBuf.setLength(0);
                    continue block13;
                }
                case '\\': {
                    if (backSlash) {
                        argBuf.append("\\");
                    }
                    backSlash = !backSlash;
                    continue block13;
                }
                case '\'': {
                    if (backSlash) {
                        argBuf.append("'");
                        backSlash = false;
                        continue block13;
                    }
                    if (matchSglQuote) {
                        result.addElement(argBuf.toString());
                        argBuf.setLength(0);
                        matchSglQuote = false;
                        continue block13;
                    }
                    if (matchDblQuote) continue block13;
                    matchSglQuote = true;
                    continue block13;
                }
                case '\"': {
                    if (backSlash) {
                        argBuf.append("\"");
                        backSlash = false;
                        continue block13;
                    }
                    if (matchDblQuote) {
                        result.addElement(argBuf.toString());
                        argBuf.setLength(0);
                        matchDblQuote = false;
                        continue block13;
                    }
                    if (matchSglQuote) continue block13;
                    matchDblQuote = true;
                    continue block13;
                }
                default: {
                    if (backSlash) {
                        switch (ch) {
                            case 'b': {
                                argBuf.append('\b');
                                break;
                            }
                            case 'f': {
                                argBuf.append('\f');
                                break;
                            }
                            case 'n': {
                                argBuf.append('\n');
                                break;
                            }
                            case 'r': {
                                argBuf.append('\r');
                                break;
                            }
                            case 't': {
                                argBuf.append('\t');
                                break;
                            }
                            default: {
                                char ch2 = argStr.charAt(cIdx + 1);
                                char ch3 = argStr.charAt(cIdx + 2);
                                if (ch >= '0' && ch <= '7' && ch2 >= '0' && ch2 <= '7' && ch3 >= '0' && ch3 <= '7') {
                                    int octal = (ch - 48) * 64 + (ch2 - 48) * 8 + (ch3 - 48);
                                    argBuf.append((char)octal);
                                    cIdx += 2;
                                    break;
                                }
                                if (ch == '0') {
                                    argBuf.append('\u0000');
                                    break;
                                }
                                argBuf.append(ch);
                                break;
                            }
                        }
                    } else {
                        argBuf.append(ch);
                    }
                    backSlash = false;
                }
            }
        }
        if (argBuf.length() > 0) {
            result.addElement(argBuf.toString());
        }
        return result;
    }

    static {
        HKEY_ICE_TESTKEY = null;
        ERROR_SUCCESS = 0;
        ERROR_FILE_NOT_FOUND = 2;
        ERROR_ACCESS_DENIED = 5;
        ERROR_INVALID_HANDLE = 6;
        ERROR_INVALID_PARAMETER = 87;
        ERROR_CALL_NOT_IMPLEMENTED = 120;
        ERROR_INSUFFICIENT_BUFFER = 122;
        ERROR_LOCK_FAILED = 167;
        ERROR_TRANSFER_TOO_LONG = 222;
        ERROR_MORE_DATA = 234;
        ERROR_NO_MORE_ITEMS = 259;
        ERROR_BADDB = 1009;
        ERROR_BADKEY = 1010;
        ERROR_CANTOPEN = 1011;
        ERROR_CANTREAD = 1012;
        ERROR_CANTWRITE = 1013;
        ERROR_REGISTRY_RECOVERED = 1014;
        ERROR_REGISTRY_CORRUPT = 1015;
        ERROR_REGISTRY_IO_FAILED = 1016;
        ERROR_NOT_REGISTRY_FILE = 1017;
        ERROR_KEY_DELETED = 1018;
        ROW_BYTES = 16;
        ROW_QTR1 = 3;
        ROW_HALF = 7;
        ROW_QTR2 = 11;
        saveKey = null;
        topLevelKeys = null;
        try {
            System.loadLibrary("ICE_JNIRegistry");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("ERROR You have not installed the DLL named 'ICE_JNIRegistry.DLL'.\n\t".concat(String.valueOf(String.valueOf(e.getMessage()))));
        }
        catch (SecurityException e) {
            System.err.println("ERROR You do not have permission to load the DLL named 'ICE_JNIRegistry.DLL'.\n\t".concat(String.valueOf(String.valueOf(e.getMessage()))));
        }
        HKEY_CLASSES_ROOT = new RegistryKey(Integer.MIN_VALUE, "HKEY_CLASSES_ROOT");
        HKEY_CURRENT_USER = new RegistryKey(-2147483647, "HKEY_CURRENT_USER");
        HKEY_LOCAL_MACHINE = new RegistryKey(-2147483646, "HKEY_LOCAL_MACHINE");
        HKEY_USERS = new RegistryKey(-2147483645, "HKEY_USERS");
        HKEY_PERFORMANCE_DATA = new RegistryKey(-2147483644, "HKEY_PERFORMANCE_DATA");
        HKEY_CURRENT_CONFIG = new RegistryKey(-2147483643, "HKEY_CURRENT_CONFIG");
        HKEY_DYN_DATA = new RegistryKey(-2147483642, "HKEY_DYN_DATA");
        topLevelKeys = new Hashtable(16);
        topLevelKeys.put("HKCR", HKEY_CLASSES_ROOT);
        topLevelKeys.put("HKEY_CLASSES_ROOT", HKEY_CLASSES_ROOT);
        topLevelKeys.put("HKCU", HKEY_CURRENT_USER);
        topLevelKeys.put("HKEY_CURRENT_USER", HKEY_CURRENT_USER);
        topLevelKeys.put("HKLM", HKEY_LOCAL_MACHINE);
        topLevelKeys.put("HKEY_LOCAL_MACHINE", HKEY_LOCAL_MACHINE);
        topLevelKeys.put("HKU", HKEY_USERS);
        topLevelKeys.put("HKUS", HKEY_USERS);
        topLevelKeys.put("HKEY_USERS", HKEY_USERS);
        topLevelKeys.put("HKPD", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKEY_PERFORMANCE_DATA", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKCC", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKEY_CURRENT_CONFIG", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKDD", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKEY_DYN_DATA", HKEY_PERFORMANCE_DATA);
    }
}

