/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.gmt.GenericCommandExecute;
import edu.sc.seis.fissuresUtil.sac.SacToFissures;
import edu.sc.seis.seisFile.sac.SacConstants;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;

public class SacPSXY {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws FileNotFoundException, IOException, FissuresException, InterruptedException {
        SacTimeSeries sac = new SacTimeSeries();
        sac.read(args[0]);
        StringBuffer buff = new StringBuffer();
        LocalSeismogramImpl seis = SacToFissures.getSeismogram((SacTimeSeries)sac);
        TimeInterval period = seis.getSampling().getPeriod();
        float offset = sac.getHeader().getA() - sac.getHeader().getB();
        if (SacConstants.isUndef((float)sac.getHeader().getA()) || SacConstants.isUndef((float)sac.getHeader().getB())) {
            offset = 0.0f;
        }
        float secondPeriod = (float)period.getValue(UnitImpl.SECOND);
        float[] data = seis.get_as_floats();
        float min = 9999999.0f;
        float max = -9999999.0f;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] < min) {
                min = data[i];
            }
            if (data[i] > max) {
                max = data[i];
            }
            buff.append((float)i * secondPeriod - offset + " " + data[i] + "\n");
        }
        String psFilename = args[1];
        String command = "psxy -R-" + offset + "/" + ((float)data.length * secondPeriod - offset) + "/" + min + "/" + max;
        for (int i = 2; i < args.length; ++i) {
            command = command + " " + args[i];
        }
        try (FileOutputStream fos = new FileOutputStream(psFilename, true);){
            GenericCommandExecute.execute((String)command, (Reader)new StringReader(buff.toString()), (OutputStream)fos, (OutputStream)System.err);
        }
    }
}

