/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.shis;

import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.plugin.WebImagePlugIn;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.Properties;

public class SHISPlugIn
extends WebImagePlugIn
implements ImageServerConstants {
    protected String queryHeader = null;
    protected String imageFormat = null;
    protected String backgroundColor = null;
    protected String transparent = null;
    protected String host = null;
    protected String port = null;
    protected String path = null;
    public static final String HostNameProperty = "host";
    public static final String PortNumberProperty = "port";
    public static final String PathProperty = "path";
    public static final String ImageFormatProperty = "format";
    public static final String BackgroundColorProperty = "backgroundColor";
    public static final String TransparentProperty = "transparent";

    public String createQueryString(Projection p) {
        String layers;
        if (this.queryHeader == null) {
            return null;
        }
        String bbox = "undefined";
        String height = "undefined";
        String width = "undefined";
        StringBuffer buf = new StringBuffer(this.queryHeader);
        buf.append("REQUEST=map&");
        if (p != null) {
            buf.append("PROJTYPE=" + p.getName() + "&" + "SCALE" + "=" + p.getScale() + "&" + "LAT" + "=" + p.getCenter().getLatitude() + "&" + "LON" + "=" + p.getCenter().getLongitude() + "&" + "HEIGHT" + "=" + p.getHeight() + "&" + "WIDTH" + "=" + p.getWidth());
        } else {
            buf.append("PROJTYPE=name_undefined&SCALE=scale_undefined&LAT=center_lat_undefined&LON=center_lon_undefined&HEIGHT=height_undefined&WIDTH=width_undefined");
        }
        if (this.imageFormat != null) {
            buf.append("&FORMAT=" + this.imageFormat);
        }
        if (this.transparent != null) {
            buf.append("&TRANSPARENT=true");
        }
        if (this.backgroundColor != null) {
            buf.append("&BGCOLOR=" + this.backgroundColor);
        }
        if ((layers = this.getLayerMarkers()) != null) {
            buf.append("&" + layers);
        }
        return buf.toString();
    }

    public String getServerName() {
        return this.queryHeader;
    }

    public String getLayerMarkers() {
        return null;
    }

    public void setProperties(String prefix, Properties setList) {
        super.setProperties(prefix, setList);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.host = setList.getProperty(prefix + HostNameProperty);
        this.port = setList.getProperty(prefix + PortNumberProperty);
        this.path = setList.getProperty(prefix + PathProperty);
        this.imageFormat = setList.getProperty(prefix + ImageFormatProperty);
        this.transparent = setList.getProperty(prefix + TransparentProperty);
        this.backgroundColor = setList.getProperty(prefix + BackgroundColorProperty);
        if (this.path == null) {
            this.path = "openmap";
        }
        if (this.host == null || this.port == null) {
            Debug.error("SHISPlugIn needs a host name and port number for the image server.");
            this.queryHeader = null;
            return;
        }
        this.queryHeader = "http://" + (this.host == null ? "localhost" : this.host) + (this.port == null ? "" : ":" + this.port) + "/" + this.path + "?";
        if (Debug.debugging("plugin")) {
            Debug.output("SHISPlugIn: set up with header \"" + this.queryHeader + "\"");
        }
    }

    public Properties getProperties(Properties getList) {
        getList = super.getProperties(getList);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        getList.put(prefix + HostNameProperty, PropUtils.unnull(this.host));
        getList.put(prefix + PortNumberProperty, PropUtils.unnull(this.port));
        getList.put(prefix + PathProperty, PropUtils.unnull(this.path));
        getList.put(prefix + ImageFormatProperty, PropUtils.unnull(this.imageFormat));
        getList.put(prefix + TransparentProperty, PropUtils.unnull(this.transparent));
        getList.put(prefix + BackgroundColorProperty, PropUtils.unnull(this.backgroundColor));
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put("initProperties", "host port path format transparent backgroundColor");
        list.put(HostNameProperty, "This hostname of the server machine.");
        list.put(PortNumberProperty, "The port number the server is running on.");
        list.put(PathProperty, "The path to the server (openmap is default)");
        list.put(ImageFormatProperty, "Image format (JPEG|GIF|PPM|PNG)");
        list.put(TransparentProperty, "Whether background of image should be transparent.");
        list.put("transparent.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(BackgroundColorProperty, "Background color for image.");
        list.put("backgroundColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        return list;
    }
}

