/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.grid;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.SinkGraphic;
import com.bbn.openmap.omGraphics.grid.GridData;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;

public class SimpleColorGenerator
implements OMGridGenerator {
    public OMGraphic generate(OMGrid grid, Projection proj) {
        Debug.message("grid", "SimpleColorGenerator: generating OMRaster from grid");
        OMRaster raster = new OMRaster(grid.point1.x, grid.point1.y, grid.width, grid.height, new int[grid.width * grid.height]);
        if (grid.height == 0 || grid.width == 0) {
            Debug.message("grid", "SimpleColorGenerator: grid height/width ZERO!");
            return raster;
        }
        GridData gd = grid.getData();
        if (!(gd instanceof GridData.Int)) {
            Debug.message("grid", "SimpleColorGenerator: grid doesn't contain integer data.");
            return SinkGraphic.getSharedInstance();
        }
        int rows = grid.getRows();
        int columns = grid.getColumns();
        int[][] data = ((GridData.Int)gd).getData();
        boolean major = grid.getMajor();
        double y_interval = (double)rows / (double)grid.height;
        double x_interval = (double)columns / (double)grid.width;
        Debug.message("grid", "SimpleColorGenerator: y_point_interval = " + y_interval + ", x_point_interval = " + x_interval);
        int x = 0;
        while (x < grid.width) {
            int y = 0;
            while (y < grid.height) {
                int value;
                int post_x = (int)Math.round(x_interval * (double)x);
                int post_y = grid.getRenderType() == 1 ? (int)Math.round(y_interval * ((double)(grid.height - 1) - (double)y)) : (int)Math.round(y_interval * (double)y);
                if (major) {
                    if (post_x >= columns) {
                        post_x = columns - 1;
                    }
                    if (post_y >= rows) {
                        post_y = rows - 1;
                    }
                    value = this.calibratePointValue(data[post_x][post_y]);
                } else {
                    if (post_y >= columns) {
                        post_y = columns - 1;
                    }
                    if (post_x >= rows) {
                        post_x = rows - 1;
                    }
                    value = this.calibratePointValue(data[post_y][post_x]);
                }
                raster.setPixel(x, y, value);
                ++y;
            }
            ++x;
        }
        raster.generate(proj);
        return raster;
    }

    public int calibratePointValue(int source) {
        return source;
    }

    public boolean needGenerateToRender() {
        return true;
    }

    public int[] createGreyscaleColors(int num_colors, int opaqueness) {
        int[] tempColors = new int[num_colors];
        if (num_colors == 0) {
            num_colors = 216;
        }
        int grey_interval = 256 / num_colors;
        int i = 0;
        while (i < num_colors) {
            if (i == 0) {
                tempColors[i] = (opaqueness & 0xFF) << 24 | 0xBF0000 | 0xEF00 | 0xFF;
            } else {
                int color = i * grey_interval + grey_interval / 2;
                tempColors[i] = (opaqueness & 0xFF) << 24 | (color & 0xFF) << 16 | (color & 0xFF) << 8 | color & 0xFF;
            }
            ++i;
        }
        return tempColors;
    }
}

