/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;

public class OMArrowHead {
    public static final int ARROWHEAD_DIRECTION_FORWARD = 0;
    public static final int ARROWHEAD_DIRECTION_BACKWARD = 1;
    public static final int ARROWHEAD_DIRECTION_BOTH = 2;
    protected static int DEFAULT_WINGTIP = 5;
    protected static int DEFAULT_WINGLENGTH = 20;

    public static GeneralPath createArrowHeads(int arrowDirectionType, int location, OMLine line) {
        return OMArrowHead.createArrowHeads(arrowDirectionType, location, line, DEFAULT_WINGTIP, DEFAULT_WINGLENGTH);
    }

    public static GeneralPath createArrowHeads(int arrowDirectionType, int location, OMLine line, int wingTip, int wingLength) {
        Point[] locPoints = OMArrowHead.locateArrowHeads(arrowDirectionType, location, line);
        if (locPoints == null) {
            return null;
        }
        Stroke stroke = line.getStroke();
        float lineWidth = 1.0f;
        if (stroke instanceof BasicStroke) {
            lineWidth = ((BasicStroke)stroke).getLineWidth();
            wingTip = (int)((float)wingTip + lineWidth);
            wingLength = (int)((float)wingLength + lineWidth * 2.0f);
        }
        GeneralPath shape = OMArrowHead.createArrowHead(locPoints[0], locPoints[1], wingTip, wingLength);
        if (locPoints.length > 2) {
            shape.append(OMArrowHead.createArrowHead(locPoints[2], locPoints[3], wingTip, wingLength), false);
        }
        return shape;
    }

    public static void addArrowHeads(int arrowDirectionType, int location, OMLine line) {
        GeneralPath arrowHeads = OMArrowHead.createArrowHeads(arrowDirectionType, location, line);
        if (arrowHeads != null) {
            line.getShape().append(arrowHeads, false);
        }
    }

    protected static GeneralPath createArrowHead(Point from, Point to, int wingTip, int wingLength) {
        int dx = to.x - from.x;
        int dy = to.y - from.y;
        int dd = (int)DrawUtil.distance(to.x, to.y, from.x, from.y);
        if (dd < 6) {
            dd = 6;
        }
        int[] xpts = new int[3];
        int[] ypts = new int[3];
        xpts[0] = to.x + (dy * wingTip - dx * wingLength) / dd;
        ypts[0] = to.y + (dx * -wingTip - dy * wingLength) / dd;
        xpts[1] = to.x;
        ypts[1] = to.y;
        xpts[2] = to.x + (dy * -wingTip - dx * wingLength) / dd;
        ypts[2] = to.y + (dx * wingTip - dy * wingLength) / dd;
        return OMGraphic.createShape(xpts, ypts, true);
    }

    protected static Point[] locateArrowHeads(int arrowDirection, int arrowLocation, OMLine line) {
        if (line.xpoints == null || line.xpoints.length == 0 || line.xpoints[0].length == 0) {
            return null;
        }
        int pointIndex = line.xpoints[0].length - 1;
        if (Debug.debugging("arrowheads")) {
            Debug.output("createArrowHeads(): Number of points = " + pointIndex);
        }
        int drawingLinetype = 0;
        if (pointIndex > 1) {
            drawingLinetype = 1;
        }
        int[] end = new int[2];
        int[] start = new int[2];
        end[0] = pointIndex;
        start[0] = 0;
        end[1] = 0;
        start[1] = pointIndex;
        int origEnd = pointIndex;
        int origStart = 0;
        int numArrows = 1;
        if (arrowDirection == 2) {
            numArrows = 2;
        }
        Point sPoint1 = new Point();
        Point ePoint1 = new Point();
        Point sPoint2 = new Point();
        Point ePoint2 = new Point();
        if (line.arc != null && line.arc.getReversed()) {
            if (arrowDirection == 0) {
                arrowDirection = 1;
            } else if (arrowDirection == 1) {
                arrowDirection = 0;
            }
        }
        switch (drawingLinetype) {
            case 0: {
                float dd;
                int offset;
                int dy;
                int dx;
                int newEndY;
                int newEndX;
                Debug.message("arrowheads", "createArrowHeads(): Inside x-y space");
                if (OMArrowHead.needBackwardArrow(arrowDirection)) {
                    newEndX = line.xpoints[0][origStart];
                    newEndY = line.ypoints[0][origStart];
                    if (arrowLocation != 100) {
                        dx = line.xpoints[0][origStart] - line.xpoints[0][origEnd];
                        dy = line.ypoints[0][origStart] - line.ypoints[0][origEnd];
                        offset = 0;
                        if (dx == 0) {
                            newEndX = line.xpoints[0][origEnd];
                            offset = (int)((float)dy * ((float)arrowLocation / 100.0f));
                            newEndY = line.ypoints[0][origEnd] + offset;
                        } else {
                            dd = Math.abs((float)dy / (float)dx);
                            if (Math.abs(dx) > Math.abs(dy)) {
                                newEndX = line.xpoints[0][origEnd] + (int)((double)dx * ((double)arrowLocation / 100.0));
                                newEndY = line.ypoints[0][origEnd];
                                offset = (int)((float)Math.abs(line.xpoints[0][origEnd] - newEndX) * dd);
                                newEndY = dy < 0 ? (newEndY -= offset) : (newEndY += offset);
                            } else {
                                newEndY = line.ypoints[0][origEnd] + (int)((double)dy * ((double)arrowLocation / 100.0));
                                newEndX = line.xpoints[0][origEnd];
                                offset = (int)((float)Math.abs(line.ypoints[0][origEnd] - newEndY) / dd);
                                newEndX = dx < 0 ? (newEndX -= offset) : (newEndX += offset);
                            }
                        }
                    }
                    if (start[1] < 0) {
                        start[1] = 0;
                    }
                    if (numArrows == 2) {
                        sPoint2.x = line.xpoints[0][origEnd];
                        sPoint2.y = line.ypoints[0][origEnd];
                        ePoint2.x = newEndX;
                        ePoint2.y = newEndY;
                    } else {
                        sPoint1.x = line.xpoints[0][origEnd];
                        sPoint1.y = line.ypoints[0][origEnd];
                        ePoint1.x = newEndX;
                        ePoint1.y = newEndY;
                    }
                }
                if (!OMArrowHead.needForwardArrow(arrowDirection)) break;
                newEndX = line.xpoints[0][origEnd];
                newEndY = line.ypoints[0][origEnd];
                if (arrowLocation != 100) {
                    dx = line.xpoints[0][origEnd] - line.xpoints[0][origStart];
                    dy = line.ypoints[0][origEnd] - line.ypoints[0][origStart];
                    offset = 0;
                    if (dx == 0) {
                        newEndX = line.xpoints[0][origStart];
                        offset = (int)((float)dy * ((float)arrowLocation / 100.0f));
                        newEndY = line.ypoints[0][origStart] + offset;
                    } else {
                        dd = Math.abs((float)dy / (float)dx);
                        if (Math.abs(dx) > Math.abs(dy)) {
                            newEndX = line.xpoints[0][origStart] + (int)((float)dx * ((float)arrowLocation / 100.0f));
                            newEndY = line.ypoints[0][origStart];
                            offset = (int)((float)Math.abs(line.xpoints[0][origStart] - newEndX) * dd);
                            newEndY = dy < 0 ? (newEndY -= offset) : (newEndY += offset);
                        } else {
                            newEndY = line.ypoints[0][origStart] + (int)((double)dy * ((double)arrowLocation / 100.0));
                            newEndX = line.xpoints[0][origStart];
                            offset = (int)((float)Math.abs(line.ypoints[0][origStart] - newEndY) / dd);
                            newEndX = dx < 0 ? (newEndX -= offset) : (newEndX += offset);
                        }
                    }
                }
                sPoint1.x = line.xpoints[0][origStart];
                sPoint1.y = line.ypoints[0][origStart];
                ePoint1.x = newEndX;
                ePoint1.y = newEndY;
                break;
            }
            case 1: {
                Debug.message("arrowheads", "createArrowHeads(): Curved line arrowhead");
                if (OMArrowHead.needBackwardArrow(arrowDirection)) {
                    Debug.message("arrowheads", "createArrowHeads(): direction backward and");
                    int bindex = pointIndex - (int)((float)pointIndex * (float)((double)arrowLocation / 100.0));
                    if (bindex == 0) {
                        bindex = 1;
                    }
                    if (numArrows == 2) {
                        sPoint2.x = line.xpoints[0][bindex];
                        sPoint2.y = line.ypoints[0][bindex];
                        ePoint2.x = line.xpoints[0][bindex - 1];
                        ePoint2.y = line.ypoints[0][bindex - 1];
                    } else {
                        sPoint1.x = line.xpoints[0][bindex];
                        sPoint1.y = line.ypoints[0][bindex];
                        ePoint1.x = line.xpoints[0][bindex - 1];
                        ePoint1.y = line.ypoints[0][bindex - 1];
                    }
                }
                if (!OMArrowHead.needForwardArrow(arrowDirection)) break;
                int findex = (int)((float)pointIndex * (float)((double)arrowLocation / 100.0));
                if (findex == pointIndex) {
                    --findex;
                }
                sPoint1.x = line.xpoints[0][findex];
                sPoint1.y = line.ypoints[0][findex];
                ePoint1.x = line.xpoints[0][findex + 1];
                ePoint1.y = line.ypoints[0][findex + 1];
            }
        }
        Point[] ret = new Point[numArrows * 2];
        ret[0] = sPoint1;
        ret[1] = ePoint1;
        if (numArrows > 1) {
            ret[2] = sPoint2;
            ret[3] = ePoint2;
        }
        return ret;
    }

    private static boolean needBackwardArrow(int arrowDir) {
        return arrowDir == 1 || arrowDir == 2;
    }

    private static boolean needForwardArrow(int arrowDir) {
        return arrowDir == 0 || arrowDir == 2;
    }
}

