/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMText;
import java.awt.Font;

public class FontSizer {
    protected Font font = OMText.DEFAULT_FONT;
    protected Font lastFont = OMText.DEFAULT_FONT;
    protected float baseScale = -1.0f;
    protected float lastScale = -1.0f;
    protected float curScale = -1.0f;
    protected int minPointSize = this.font.getSize();
    protected int maxPointSize = this.font.getSize();
    protected int multiplier = 1;

    public FontSizer(Font font, float baseScale, int multiplier, int minPointSize, int maxPointSize) {
        this(baseScale, multiplier, minPointSize, maxPointSize);
        this.font = font;
    }

    public FontSizer(float baseScale, int multiplier, int minPointSize, int maxPointSize) {
        this.baseScale = baseScale;
        this.multiplier = multiplier;
        this.minPointSize = minPointSize;
        this.maxPointSize = maxPointSize;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont(float scale) {
        this.curScale = scale;
        return this.getScaledFont();
    }

    protected Font getScaledFont() {
        if (this.lastScale != this.curScale) {
            this.lastScale = this.curScale;
            if (this.baseScale < 0.0f || this.curScale < 0.0f) {
                this.lastFont = this.font;
            } else {
                int newFontSize = this.multiplier * (int)(this.baseScale / this.curScale * (float)this.font.getSize());
                if (newFontSize > this.maxPointSize) {
                    newFontSize = this.maxPointSize;
                } else if (newFontSize < this.minPointSize) {
                    newFontSize = this.minPointSize;
                }
                this.lastFont = new Font(this.font.getName(), this.font.getStyle(), newFontSize);
            }
        }
        return this.lastFont;
    }

    public Font getFont() {
        return this.font;
    }

    public void setMultiplier(int mul) {
        this.lastScale = -1.0f;
        this.multiplier = mul;
    }

    public int getMultiplier() {
        return this.multiplier;
    }
}

