/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.DcwRecordFile;
import com.bbn.openmap.layer.vpf.DcwSpatialIndex;
import com.bbn.openmap.layer.vpf.DcwThematicIndex;
import com.bbn.openmap.layer.vpf.VPFUtil;
import com.bbn.openmap.util.Debug;
import java.util.ArrayList;

public class Server {
    public static void main(String[] args) {
        Debug.init(System.getProperties());
        boolean schemaonly = false;
        boolean printall = false;
        boolean parseall = false;
        System.out.println("This class just decodes and print VPF files.");
        System.out.println("use the DcwSpecialist class to run the specialist");
        Debug.put("vpfserver");
        if (Debug.debugging("vpf")) {
            Debug.output("This file doesn't have debugging info.");
        }
        int i = 0;
        while (i < args.length) {
            block25: {
                System.out.println(args[i]);
                if (args[i].equals("-schemaOnly")) {
                    schemaonly = !schemaonly;
                } else if (args[i].equals("-printAll")) {
                    printall = !printall;
                } else if (args[i].equals("-parseAll")) {
                    parseall = !parseall;
                } else if (args[i].equals("-help")) {
                    System.out.println(" -schemaOnly -printAll -parseAll -help [files]");
                }
                if (!args[i].startsWith("-")) {
                    try {
                        DcwRecordFile foo;
                        Object ff;
                        String f = args[i];
                        if (args[i].endsWith("x") || args[i].endsWith("x.")) {
                            System.out.println("Skipping VLI format");
                            break block25;
                        }
                        if (args[i].endsWith("ti")) {
                            System.out.println("Trying Thematic Index format");
                            ff = new DcwThematicIndex(f, false);
                            ((DcwThematicIndex)ff).close();
                            break block25;
                        }
                        if (args[i].endsWith("si") || args[i].endsWith("si.")) {
                            System.out.println("Trying Spatial Index format");
                            ff = new DcwSpatialIndex(f, false);
                            ((DcwSpatialIndex)ff).close();
                            break block25;
                        }
                        if (args[i].endsWith(".doc")) {
                            int[] cols;
                            foo = new DcwRecordFile(f);
                            String[] colname = new String[]{"text"};
                            char[] tschema = new char[]{'T'};
                            int[] lschema = new int[]{-1};
                            try {
                                cols = foo.lookupSchema(colname, true, tschema, lschema, false);
                            }
                            catch (FormatException e) {
                                foo.printSchema();
                                throw e;
                            }
                            ArrayList l = new ArrayList();
                            while (foo.parseRow(l)) {
                                System.out.println(l.get(cols[0]));
                            }
                            System.out.println();
                            foo.close();
                            break block25;
                        }
                        foo = new DcwRecordFile(f);
                        foo.printSchema();
                        if (!schemaonly) {
                            if (printall) {
                                ArrayList l = new ArrayList();
                                while (foo.parseRow(l)) {
                                    System.out.println(VPFUtil.listToString(l));
                                }
                            } else if (parseall) {
                                foo.parseAllRowsAndPrintSome();
                            } else {
                                foo.parseSomeRowsAndPrint();
                            }
                        }
                        foo.close();
                    }
                    catch (FormatException f) {
                        System.err.println("****************************************");
                        System.err.println("*--------------------------------------*");
                        System.err.println("Format error in dealing with " + args[i]);
                        System.err.println(f.getMessage());
                        System.err.println("*--------------------------------------*");
                        System.err.println("****************************************");
                    }
                }
            }
            ++i;
        }
    }
}

