/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.Constants;
import com.bbn.openmap.layer.vpf.CoverageAttributeTable;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.DcwRecordFile;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LibrarySelectionTable {
    public static final int DEFAULT_BROWSE_CUTOFF = 31000000;
    protected int BROWSE_CUTOFF = 31000000;
    private String[] libraryname = null;
    private Map boundrec = new HashMap();
    private Map CATs = new HashMap();
    private static final String[] LATColumns = new String[]{"library_name", "xmin", "ymin", "xmax", "ymax"};
    private static final char[] LATschematype = new char[]{'T', 'F', 'F', 'F', 'F'};
    private static final int[] LATschemalength = new int[]{-1, 1, 1, 1, 1};
    private String databaseName;
    private String databaseDesc;

    public LibrarySelectionTable() {
    }

    public LibrarySelectionTable(String vpfpath) throws FormatException {
        this.addDataPath(vpfpath);
    }

    public LibrarySelectionTable(String[] vpfpaths) throws FormatException {
        int i = 0;
        while (i < vpfpaths.length) {
            this.addDataPath(vpfpaths[i]);
            ++i;
        }
    }

    public void setCutoffScale(int scale) {
        this.BROWSE_CUTOFF = scale;
    }

    public int getCutoffScale() {
        return this.BROWSE_CUTOFF;
    }

    public void addDataPath(String vpfpath) throws FormatException {
        if (Debug.debugging("vpf")) {
            Debug.output("LST.addDataPath(" + vpfpath + ")");
        }
        boolean addSlash = true;
        if (vpfpath.endsWith("/") || vpfpath.endsWith(File.separator)) {
            addSlash = false;
        }
        String latf = vpfpath + (addSlash ? "/" : "") + "lat";
        String dhtf = vpfpath + (addSlash ? "/" : "") + "dht";
        if (!BinaryFile.exists(latf)) {
            latf = latf + ".";
            dhtf = dhtf + ".";
        }
        DcwRecordFile latrf = new DcwRecordFile(latf);
        DcwRecordFile dhtrf = new DcwRecordFile(dhtf);
        List databaseVec = dhtrf.parseRow();
        int dcol = dhtrf.whatColumn("database_name");
        if (dcol != -1) {
            this.databaseName = (String)databaseVec.get(dcol);
        }
        if ((dcol = dhtrf.whatColumn("database_desc")) != -1) {
            this.databaseDesc = (String)databaseVec.get(dcol);
        }
        dhtrf.close();
        dhtrf = null;
        int[] latcols = latrf.lookupSchema(LATColumns, true, LATschematype, LATschemalength, false);
        Debug.message("vpf", "lst.adp: looked up schema");
        ArrayList l = new ArrayList(latrf.getColumnCount());
        while (latrf.parseRow(l)) {
            String lname = ((String)l.get(latcols[0])).toLowerCase();
            float[] br = new float[]{((Float)l.get(latcols[1])).floatValue(), ((Float)l.get(latcols[2])).floatValue(), ((Float)l.get(latcols[3])).floatValue(), ((Float)l.get(latcols[4])).floatValue()};
            try {
                CoverageAttributeTable table = new CoverageAttributeTable(vpfpath, lname);
                this.CATs.put(lname, table);
                this.boundrec.put(lname, br);
                if (!Debug.debugging("vpf")) continue;
                Debug.output(lname + " " + br[0] + " " + br[1] + " " + br[2] + " " + br[3]);
            }
            catch (FormatException fe) {
                if (Debug.debugging("vpf")) {
                    Debug.output("*****\nVPFLayer.LST: Couldn't create CoverageAttributeTable for " + vpfpath + " " + lname + " " + fe.getMessage() + "\n--- Not a problem if you have multiple paths, and " + lname + " is included in another path ---\n*****");
                    fe.printStackTrace();
                    continue;
                }
                Debug.output("VPFLayer.LST: CAT discrepancy (run with -Ddebug.vpf for more details)");
            }
        }
        latrf.close();
        latrf = null;
    }

    public String[] getLibraryNames() {
        return this.CATs.keySet().toArray(Constants.EMPTY_STRING_ARRAY);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseDescription() {
        return this.databaseDesc;
    }

    public CoverageAttributeTable getCAT(String library) throws FormatException {
        return (CoverageAttributeTable)this.CATs.get(library);
    }

    public void drawTile(int scale, int screenwidth, int screenheight, String covname, VPFGraphicWarehouse warehouse, LatLonPoint ll1, LatLonPoint ll2) {
        if (Debug.debugging("vpf")) {
            Debug.output("Library selection table coverage: " + covname);
            Debug.output("Library selection table - edges: " + warehouse.drawEdgeFeatures());
            Debug.output("Library selection table - text: " + warehouse.drawTextFeatures());
            Debug.output("Library selection table - areas: " + warehouse.drawAreaFeatures());
            Debug.output("Warehouse: " + warehouse);
            Debug.output("Warehouse: cutoff scale " + this.BROWSE_CUTOFF);
        }
        if (scale < this.BROWSE_CUTOFF && ll1.getLongitude() > ll2.getLongitude()) {
            this.drawTile(scale, screenwidth, screenheight, covname, warehouse, ll1, new LatLonPoint(ll2.getLatitude(), 179.99998f));
            this.drawTile(scale, screenwidth, screenheight, covname, warehouse, new LatLonPoint(ll1.getLatitude(), -180.0f), ll2);
            return;
        }
        if (Debug.debugging("vpf")) {
            Debug.output("LST.drawTile() with scale of " + scale);
        }
        float dpplat = Math.abs((ll1.getLatitude() - ll2.getLatitude()) / (float)screenheight);
        float dpplon = Math.abs((ll1.getLongitude() - ll2.getLongitude()) / (float)screenwidth);
        int inArea = 0;
        CoverageTable redrawUntiled = null;
        String useLibrary = warehouse.getUseLibrary();
        Iterator i = this.CATs.values().iterator();
        while (i.hasNext()) {
            CoverageAttributeTable cat = (CoverageAttributeTable)i.next();
            if (Debug.debugging("vpf")) {
                Debug.output("LST: checking library: " + cat.getLibraryName());
            }
            if (useLibrary != null && !useLibrary.equalsIgnoreCase(cat.getLibraryName())) continue;
            warehouse.resetForCAT();
            List tiles = cat.tilesInRegion(ll1.getLatitude(), ll2.getLatitude(), ll2.getLongitude(), ll1.getLongitude());
            if (tiles == null) {
                redrawUntiled = cat.getCoverageTable(covname);
                continue;
            }
            if (!cat.isTiledData() || scale >= this.BROWSE_CUTOFF || tiles.isEmpty()) continue;
            CoverageTable c = cat.getCoverageTable(covname);
            if (c == null) {
                if (!Debug.debugging("vpf")) continue;
                Debug.output("|LST.drawTile(): Couldn't get coverage table for " + covname + " " + cat.getLibraryName());
                continue;
            }
            if (Debug.debugging("vpf")) {
                Debug.output("Using coverage table for " + covname + " " + cat.getLibraryName());
            }
            ++inArea;
            Iterator tile = tiles.iterator();
            while (tile.hasNext()) {
                c.drawTile((TileDirectory)tile.next(), warehouse, ll1, ll2, dpplat, dpplon);
            }
        }
        if (redrawUntiled != null && inArea == 0) {
            if (Debug.debugging("vpf")) {
                Debug.output("LST drawing untiled browse data");
            }
            redrawUntiled.drawTile(new TileDirectory(), warehouse, ll1, ll2, dpplat, dpplon);
        }
    }

    public void drawFeatures(int scale, int screenwidth, int screenheight, String covname, VPFFeatureWarehouse warehouse, LatLonPoint ll1, LatLonPoint ll2) {
        if (Debug.debugging("vpf")) {
            Debug.output("LST.drawFeatures(): Coverage name: " + covname);
            Debug.output("Library selection table - edges: " + warehouse.drawEdgeFeatures());
            Debug.output("Library selection table - text: " + warehouse.drawTextFeatures());
            Debug.output("Library selection table - areas: " + warehouse.drawAreaFeatures());
            Debug.output("Warehouse: " + warehouse);
        }
        if (scale < this.BROWSE_CUTOFF && ll1.getLongitude() > ll2.getLongitude()) {
            this.drawFeatures(scale, screenwidth, screenheight, covname, warehouse, ll1, new LatLonPoint(ll2.getLatitude(), 179.99998f));
            this.drawFeatures(scale, screenwidth, screenheight, covname, warehouse, new LatLonPoint(ll1.getLatitude(), -180.0f), ll2);
            return;
        }
        if (Debug.debugging("vpf")) {
            Debug.output("LST.drawFeatures() with scale of " + scale);
        }
        float dpplat = Math.abs((ll1.getLatitude() - ll2.getLatitude()) / (float)screenheight);
        float dpplon = Math.abs((ll1.getLongitude() - ll2.getLongitude()) / (float)screenwidth);
        int inArea = 0;
        CoverageTable redrawUntiled = null;
        String useLibrary = warehouse.getUseLibrary();
        Iterator i = this.CATs.values().iterator();
        while (i.hasNext()) {
            CoverageAttributeTable cat = (CoverageAttributeTable)i.next();
            if (useLibrary != null && !useLibrary.equalsIgnoreCase(cat.getLibraryName())) continue;
            if (scale < this.BROWSE_CUTOFF) {
                CoverageTable c = cat.getCoverageTable(covname);
                if (c == null) {
                    if (!Debug.debugging("vpf")) continue;
                    Debug.output("LST.getFeatures(): Couldn't get coverage table for " + covname + " " + cat.getLibraryName());
                    continue;
                }
                if (Debug.debugging("vpf")) {
                    Debug.output("Using coverage table for " + covname + " " + cat.getLibraryName());
                }
                c.drawFeatures(warehouse, ll1, ll2, dpplat, dpplon);
                ++inArea;
                continue;
            }
            if (Debug.debugging("vpf")) {
                Debug.output("LST.drawTile(): Scale too small (probably) or no tiles in region.");
            }
            redrawUntiled = cat.getCoverageTable(covname);
        }
        if (redrawUntiled != null && inArea == 0) {
            redrawUntiled.drawFeatures(warehouse, ll1, ll2, dpplat, dpplon);
        }
    }

    public String getDescription(String coverageOrFeatureType) throws FormatException {
        boolean DEBUG = Debug.debugging("vpf.lst");
        if (DEBUG) {
            Debug.output("LST.getDescription: " + coverageOrFeatureType);
        }
        String[] libraries = this.getLibraryNames();
        int i = 0;
        while (i < libraries.length) {
            CoverageAttributeTable cat = this.getCAT(libraries[i]);
            if (cat != null) {
                String[] coverages = cat.getCoverageNames();
                int j = 0;
                while (j < coverages.length) {
                    String covname = coverages[j];
                    if (coverageOrFeatureType.equalsIgnoreCase(covname)) {
                        if (DEBUG) {
                            Debug.output("** Matches coverage " + covname);
                        }
                        return cat.getCoverageDescription(covname);
                    }
                    if (DEBUG) {
                        Debug.output("   Checking in coverage table " + covname);
                    }
                    CoverageTable ct = cat.getCoverageTable(covname);
                    Hashtable info = ct.getFeatureTypeInfo();
                    Enumeration enumeration = info.elements();
                    while (enumeration.hasMoreElements()) {
                        CoverageTable.FeatureClassRec fcr = (CoverageTable.FeatureClassRec)enumeration.nextElement();
                        String name = fcr.feature_class;
                        if (coverageOrFeatureType.equalsIgnoreCase(name)) {
                            if (DEBUG) {
                                Debug.output("** Found feature " + name);
                            }
                            return fcr.description;
                        }
                        if (!DEBUG) continue;
                        Debug.output("   checked " + name);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (DEBUG) {
            Debug.output("-- No matches found.");
        }
        return null;
    }

    public static void main(String[] args) {
        Debug.init();
        Debug.put("vpf");
        String dcwbase = null;
        if (args.length > 0) {
            dcwbase = args[0];
        } else {
            System.out.println("Need a path to the VPF lat. file");
        }
        try {
            LibrarySelectionTable lst = new LibrarySelectionTable(dcwbase);
            System.out.println("Database Name " + lst.getDatabaseName());
            String[] liblist = lst.getLibraryNames();
            int j = 0;
            while (j < liblist.length) {
                System.out.println("Library " + liblist[j]);
                lst.getCAT(liblist[j]);
                ++j;
            }
        }
        catch (FormatException f) {
            System.err.println("*****************************************");
            System.err.println("*---------------------------------------*");
            System.err.println("Format error in dealing with LST");
            System.err.println(f.getMessage());
            System.err.println("*---------------------------------------*");
            System.err.println("*****************************************");
        }
    }
}

