/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.layer.vpf.DcwColumnInfo;
import com.bbn.openmap.layer.vpf.FeatureClassInfo;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FeatureDrawingAttributes
extends DrawingAttributes {
    protected JPanel guiPanel;
    protected JPanel attributePanel;
    protected FeatureClassInfo fci;
    protected JComboBox attributeJCB;
    protected JComboBox displayTypeJCB;
    protected String displayType;
    protected int attributeCol;
    protected String attributeColName;
    public static final String DisplayTypeProperty = "attributeDisplay";
    public static final String AttributeProperty = "attribute";

    public FeatureDrawingAttributes() {
    }

    public FeatureDrawingAttributes(Properties props) {
        super(props);
    }

    public FeatureDrawingAttributes(String prefix, Properties props) {
        super(prefix, props);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        if (props == null) {
            return;
        }
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.displayType = props.getProperty(prefix + DisplayTypeProperty);
        this.attributeColName = props.getProperty(prefix + AttributeProperty);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + DisplayTypeProperty, PropUtils.unnull(this.displayType));
        props.put(prefix + AttributeProperty, PropUtils.unnull(this.attributeColName));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.put(DisplayTypeProperty, "How the property should be displayed.");
        props.put("attributeDisplay.label", "Attribute display type");
        props.put("attributeDisplay.editor", "com.bbn.openmap.util.propertyEditor.ComboBoxPropertyEditor");
        props.put("attributeDisplay.options", "none tt il l");
        props.put("attributeDisplay.none", "None");
        props.put("attributeDisplay.tt", "Tooltip");
        props.put("attributeDisplay.il", "Information Line");
        props.put("attributeDisplay.l", "Label");
        props.put(AttributeProperty, "The Name of the Attribute to display.");
        props.put("attribute.label", "Attribute name");
        return props;
    }

    public void setTo(OMGraphic omg, int id) {
        String dt;
        super.setTo(omg);
        if (this.fci != null && (dt = this.getDisplayType()) != null) {
            String tooltip = this.fci.getAttribute(id, this.getAttributeCol(), null);
            if (dt == "Label") {
                OMTextLabeler omtl = new OMTextLabeler(tooltip);
                super.setTo(omtl);
                omg.putAttribute(dt, omtl);
            } else {
                omg.putAttribute(dt, tooltip);
            }
        }
    }

    protected int getAttributeCol() {
        return this.attributeCol;
    }

    protected void setAttributeCol(int col) {
        this.attributeCol = col;
    }

    public Component getGUI() {
        if (this.guiPanel == null) {
            this.guiPanel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.guiPanel.setLayout(gridbag);
            c.gridwidth = 0;
            Component sgui = super.getGUI();
            gridbag.setConstraints(sgui, c);
            this.guiPanel.add(sgui);
            this.attributePanel = new JPanel();
            this.attributePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Attribute Control "));
            GridBagLayout gridbag2 = new GridBagLayout();
            GridBagConstraints c2 = new GridBagConstraints();
            this.attributePanel.setLayout(gridbag2);
            c2.gridwidth = -1;
            c2.anchor = 17;
            JLabel label = new JLabel("Name: ");
            label.setToolTipText("Choose which attribute to display for each instance of this feature type.");
            gridbag2.setConstraints(label, c2);
            this.attributePanel.add(label);
            c2.gridwidth = 0;
            this.attributeJCB = new JComboBox();
            this.attributeJCB.setToolTipText("Choose which attribute to display for each instance of this feature type.");
            this.attributeJCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JComboBox jcb = (JComboBox)ae.getSource();
                    FCIChoice fcic = (FCIChoice)jcb.getSelectedItem();
                    FeatureDrawingAttributes.this.setAttributeCol(fcic.getColumn());
                    FeatureDrawingAttributes.this.setAttributeColName(fcic.getAttribute());
                }
            });
            gridbag2.setConstraints(this.attributeJCB, c2);
            this.attributePanel.add(this.attributeJCB);
            c2.gridwidth = -1;
            label = new JLabel("How: ");
            label.setToolTipText("Choose how to display the attribute.");
            gridbag2.setConstraints(label, c2);
            this.attributePanel.add(label);
            c2.gridwidth = 0;
            DisplayTypeChoice[] dtc = new DisplayTypeChoice[]{new DisplayTypeChoice("None", null), new DisplayTypeChoice("Tooltip", "Tooltip"), new DisplayTypeChoice("Information Line", "Information Line"), new DisplayTypeChoice("Label", "Label")};
            this.displayTypeJCB = new JComboBox<DisplayTypeChoice>(dtc);
            this.displayTypeJCB.setToolTipText("Choose how to display the attribute.");
            this.displayTypeJCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JComboBox jcb = (JComboBox)ae.getSource();
                    DisplayTypeChoice dtc = (DisplayTypeChoice)jcb.getSelectedItem();
                    FeatureDrawingAttributes.this.setDisplayType(dtc.getDisplayCommand());
                }
            });
            if ("Tooltip".equalsIgnoreCase(this.displayType)) {
                this.displayTypeJCB.setSelectedIndex(1);
            } else if ("Information Line".equalsIgnoreCase(this.displayType)) {
                this.displayTypeJCB.setSelectedIndex(2);
            } else if ("Label".equalsIgnoreCase(this.displayType)) {
                this.displayTypeJCB.setSelectedIndex(3);
            }
            gridbag2.setConstraints(this.displayTypeJCB, c2);
            this.attributePanel.add(this.displayTypeJCB);
            this.updateAttributeGUI();
            gridbag.setConstraints(this.attributePanel, c);
            this.guiPanel.add(this.attributePanel);
        }
        return this.guiPanel;
    }

    protected void updateAttributeGUI() {
        if (this.fci != null) {
            this.attributeJCB.removeAllItems();
            DcwColumnInfo[] dci = this.fci.getColumnInfo();
            int colCount = dci.length;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < colCount) {
                FCIChoice fcic = new FCIChoice(dci[i].getColumnName(), dci[i].getColumnDescription(), i);
                this.attributeJCB.addItem(fcic);
                if (dci[i].getColumnName().equalsIgnoreCase(this.attributeColName)) {
                    this.attributeJCB.setSelectedItem(fcic);
                }
                ++i;
            }
            this.attributePanel.setVisible(true);
            this.attributeJCB.setEnabled(true);
            this.displayTypeJCB.setEnabled(true);
        } else {
            this.attributePanel.setVisible(false);
            this.attributeJCB.setEnabled(false);
            this.displayTypeJCB.setEnabled(false);
        }
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public FeatureClassInfo getFci() {
        return this.fci;
    }

    public void setFci(FeatureClassInfo fci) {
        int col;
        this.fci = fci;
        if (this.attributeColName != null && (col = fci.whatColumn(this.attributeColName)) >= 0) {
            this.setAttributeCol(col);
        }
        this.updateAttributeGUI();
    }

    public String getAttributeColName() {
        return this.attributeColName;
    }

    public void setAttributeColName(String attributeColName) {
        this.attributeColName = attributeColName;
    }

    public class FCIChoice {
        protected String attribute;
        protected String description;
        protected int column;

        public FCIChoice(String att, String desc, int col) {
            this.attribute = att;
            this.description = desc;
            this.column = col;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getDescription() {
            return this.description;
        }

        public int getColumn() {
            return this.column;
        }

        public String toString() {
            return this.getDescription() + " (" + this.getAttribute() + ")";
        }
    }

    public class DisplayTypeChoice {
        protected String displayName;
        protected String displayCommand;

        public DisplayTypeChoice(String dn, String dc) {
            this.displayName = dn;
            this.displayCommand = dc;
        }

        public String getDisplayCommand() {
            return this.displayCommand;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

