/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.rpf.RpfAttributes;
import com.bbn.openmap.layer.rpf.RpfColortable;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.io.IOException;

public class RpfFileSections {
    public static final int LOC_BOUNDARIES = 3;
    public static final int LOC_FRAMES = 4;
    public static final int LOC_COVERAGE = 6;
    public static final int LOC_COMPRESSION = 8;
    public static final int LOC_CLUT = 9;
    public static final int LOC_IMAGE = 10;
    public static final int LOC_HEADER_SECTION = 128;
    public static final int LOC_LOCATION_SECTION = 129;
    public static final int LOC_COVERAGE_SECTION = 130;
    public static final int LOC_COMPRESSION_SECTION = 131;
    public static final int LOC_COMPRESSION_LOOKUP_SUBSECTION = 132;
    public static final int LOC_COMPRESSION_PARAMETER_SUBSECTION = 133;
    public static final int LOC_COLORGRAY_SECTION_SUBHEADER = 134;
    public static final int LOC_COLORMAP_SUBSECTION = 135;
    public static final int LOC_IMAGE_DESCR_SUBHEADER = 136;
    public static final int LOC_IMAGE_DISPLAY_PARAM_SUBHEADER = 137;
    public static final int LOC_MASK_SUBSECTION = 138;
    public static final int LOC_COLOR_CONVERTER_SUBSECTION = 139;
    public static final int LOC_SPATIAL_DATA_SUBSECTION = 140;
    public static final int LOC_ATTRIBUTE_SECTION_SUBHEADER = 141;
    public static final int LOC_ATTRIBUTE_SUBSECTION = 142;
    public static final int LOC_EXPLICIT_AREAL_TABLE = 143;
    public static final int LOC_RELATED_IMAGE_SECTION_SUBHEADER = 144;
    public static final int LOC_RELATED_IMAGE_SUBSECTION = 145;
    public static final int LOC_REPLACE_UPDATE_SECTION_SUBHEADER = 146;
    public static final int LOC_REPLACE_UPDATE_TABLE = 147;
    public static final int LOC_BOUNDARY_SECTION_SUBHEADER = 148;
    public static final int LOC_BOUNDARY_RECTANGLE_TABLE = 149;
    public static final int LOC_FRAME_FILE_INDEX_SUBHEADER = 150;
    public static final int LOC_FRAME_FILE_INDEX_SUBSECTION = 151;
    public static final int LOC_COLOR_TABLE_SECTION_SUBHEADER = 152;
    public static final int LOC_COLOR_TABLE_INDEX_RECORD = 153;
    public static final int TOC_LOCATION_KEY = 4;
    public static final int FRAME_LOCATION_KEY = 8;
    public static final int COLOR_LOCATION_KEY = 3;
    RpfLocationSection locationSection;
    RpfLocationRecord[] locationRecords;
    protected boolean DEBUG_RPFDETAIL = false;

    public RpfFileSections() {
    }

    public RpfFileSections(BinaryFile binFile) {
        this.parse(binFile);
    }

    public void parse(BinaryFile binFile) {
        this.DEBUG_RPFDETAIL = Debug.debugging("rpfdetail");
        this.parseLocationSection(binFile);
    }

    public RpfLocationRecord[] getLocations(int key) {
        if (this.locationRecords == null) {
            return null;
        }
        RpfLocationRecord[] locations = new RpfLocationRecord[key];
        int[] ids = new int[key];
        switch (key) {
            case 4: {
                ids[0] = 148;
                ids[1] = 149;
                ids[2] = 150;
                ids[3] = 151;
                break;
            }
            case 8: {
                ids[0] = 131;
                ids[1] = 136;
                ids[2] = 132;
                ids[3] = 140;
                ids[4] = 137;
                ids[5] = 138;
                ids[6] = 141;
                ids[7] = 142;
                break;
            }
            case 3: {
                ids[0] = 134;
                ids[1] = 135;
                ids[2] = 139;
                break;
            }
        }
        int i = 0;
        while (i < key) {
            locations[i] = this.getRpfLocationRecord(ids[i]);
            ++i;
        }
        return locations;
    }

    public RpfLocationRecord getRpfLocationRecord(int locationRecordId) {
        if (this.locationRecords != null) {
            int i = 0;
            while (i < this.locationRecords.length) {
                if (locationRecordId == this.locationRecords[i].id) {
                    return this.locationRecords[i];
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean parseLocationSection(BinaryFile binFile) {
        this.locationSection = new RpfLocationSection();
        try {
            this.locationSection.length = binFile.readShort();
            this.locationSection.tableOffset = binFile.readInteger();
            this.locationSection.numberRecords = binFile.readShort();
            this.locationSection.recordLength = binFile.readShort();
            this.locationSection.aggregateLength = binFile.readInteger();
            if (this.DEBUG_RPFDETAIL) {
                Debug.output(this.locationSection.toString());
            }
            this.locationRecords = new RpfLocationRecord[this.locationSection.numberRecords];
            int i = 0;
            while (i < this.locationSection.numberRecords) {
                this.locationRecords[i] = new RpfLocationRecord();
                this.locationRecords[i].id = binFile.readShort();
                this.locationRecords[i].componentLength = binFile.readInteger();
                this.locationRecords[i].componentLocation = binFile.readInteger();
                if (this.DEBUG_RPFDETAIL) {
                    Debug.output("** record " + i + ": " + this.locationRecords[i].toString());
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            Debug.error("RpfFileSections: IO ERROR parsing locations!\n" + ioe);
            return false;
        }
        catch (FormatException fe) {
            Debug.error("RpfFileSections: Format ERROR parsing locations!\n" + fe);
            return false;
        }
        return true;
    }

    public RpfCoverageSection parseCoverageSection(BinaryFile binFile) {
        RpfLocationRecord lr = this.getRpfLocationRecord(130);
        if (lr == null) {
            return null;
        }
        try {
            binFile.seek(lr.componentLocation);
            RpfCoverageSection coverage = new RpfCoverageSection();
            if (coverage.read(binFile)) {
                if (this.DEBUG_RPFDETAIL) {
                    Debug.output(coverage.toString());
                }
                return coverage;
            }
        }
        catch (IOException ioe) {
            Debug.error("RpfFileSections: IO ERROR parsing coverage!\n" + ioe);
        }
        return null;
    }

    public RpfAttributes parseAttributes(BinaryFile binFile) {
        RpfLocationRecord lr = this.getRpfLocationRecord(141);
        if (lr == null) {
            if (this.DEBUG_RPFDETAIL) {
                Debug.error("RpfFileSections: attribute section not found!");
            }
            return null;
        }
        RpfAttributes attributes = new RpfAttributes();
        if (attributes.read(binFile, lr.componentLocation)) {
            if (this.DEBUG_RPFDETAIL) {
                Debug.output(attributes.toString());
            }
            return attributes;
        }
        return null;
    }

    public Color[] parseColorSection(BinaryFile binFile, RpfColortable colortable) {
        if (this.locationRecords == null) {
            return null;
        }
        return colortable.parseColorLookUpTable(binFile, this.getLocations(3));
    }

    public static class RpfLocationRecord {
        public short id;
        public long componentLength;
        public long componentLocation;

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("RpfLocationRecord:\n");
            s.append(" id = " + this.id + "\n");
            s.append(" component length  = " + this.componentLength + "\n");
            s.append(" component location = " + this.componentLocation + "\n");
            return s.toString();
        }
    }

    public static class RpfLocationSection {
        public int length;
        public long tableOffset;
        public int numberRecords;
        public int recordLength;
        public long aggregateLength;

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("RpfLocationSection:\n");
            s.append(" length = " + this.length + "\n");
            s.append(" table offset = " + this.tableOffset + "\n");
            s.append(" number of records = " + this.numberRecords + "\n");
            s.append(" record length = " + this.recordLength + "\n");
            s.append(" aggregate length = " + this.aggregateLength + "\n");
            return s.toString();
        }
    }

    public static class RpfCoverageSection {
        public double nwlat;
        public double nwlon;
        public double swlat;
        public double swlon;
        public double nelat;
        public double nelon;
        public double selat;
        public double selon;
        public double nsVertRes;
        public double ewHorRes;
        public double latInterval;
        public double lonInterval;

        public synchronized boolean read(BinaryFile binFile) {
            try {
                this.nwlat = binFile.readDouble();
                this.nwlon = binFile.readDouble();
                this.swlat = binFile.readDouble();
                this.swlon = binFile.readDouble();
                this.nelat = binFile.readDouble();
                this.nelon = binFile.readDouble();
                this.selat = binFile.readDouble();
                this.selon = binFile.readDouble();
                this.nsVertRes = binFile.readDouble();
                this.ewHorRes = binFile.readDouble();
                this.latInterval = binFile.readDouble();
                this.lonInterval = binFile.readDouble();
            }
            catch (IOException ioe) {
                Debug.error("RpfFileSections: IO ERROR parsing coverage!\n" + ioe);
                return false;
            }
            catch (FormatException fe) {
                Debug.error("RpfFileSections: Format ERROR parsing coverage!\n" + fe);
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("Coverage Section:\n");
            s.append(" nwlat = " + this.nwlat + "\n");
            s.append(" nwlon = " + this.nwlon + "\n");
            s.append(" swlat = " + this.swlat + "\n");
            s.append(" swlon = " + this.swlon + "\n");
            s.append(" nelat = " + this.nelat + "\n");
            s.append(" nelon = " + this.nelon + "\n");
            s.append(" selat = " + this.selat + "\n");
            s.append(" selon = " + this.selon + "\n");
            s.append(" ns vertical resolution = " + this.nsVertRes + "\n");
            s.append(" ew horizontal resolution = " + this.ewHorRes + "\n");
            s.append(" lat interval = " + this.latInterval + "\n");
            s.append(" lon interval = " + this.lonInterval + "\n");
            return s.toString();
        }
    }
}

