/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.plotLayer;

import com.bbn.openmap.layer.plotLayer.GLOBESite;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class ScatterGraph {
    private final Paint plot_color_ = Color.black;
    private final Paint graph_bg_color = Color.white;
    private final Paint select_color_ = Color.red;
    protected OMGraphicList plot_graphics_ = null;
    protected OMGraphicList plot_points_ = null;
    protected OMGraphicList plot_background_ = null;
    private final int border_width_ = 50;
    private boolean axes_displayed_ = false;
    private float temp_scale_ = Float.NaN;
    private float year_scale_ = Float.NaN;
    private float max_year_ = Float.NaN;
    private float min_year_ = Float.NaN;
    private float max_temp_ = Float.NaN;
    private float min_temp_ = Float.NaN;
    private Vector sites_displayed_ = null;
    private int frame_x;
    private int frame_y;
    private int frame_height_;
    private int frame_width_;
    private int plot_height_;
    private int plot_width_;
    private int frame_xoffset_;
    private int frame_yoffset_;
    private static final byte[] datapoint_bits_ = new byte[]{14, 31, 27, 31, 14};

    private void initialize(int height, int width, int xoffset, int yoffset, Vector sites, float minyear, float maxyear, float mintemp, float maxtemp) {
        this.plot_graphics_ = new OMGraphicList();
        this.plot_points_ = new OMGraphicList();
        this.plot_background_ = new OMGraphicList();
        this.plot_graphics_.setTraverseMode(0);
        this.plot_points_.setTraverseMode(0);
        this.plot_background_.setTraverseMode(0);
        this.frame_xoffset_ = xoffset;
        this.frame_yoffset_ = yoffset;
        this.max_year_ = maxyear;
        this.min_year_ = minyear;
        this.max_temp_ = maxtemp;
        this.min_temp_ = mintemp;
        this.resizeGraph(this.frame_x, this.frame_y, height, width);
        this.setDataPoints(sites);
        this.resetScale();
        this.plotData();
    }

    public ScatterGraph(int height, int width, Vector sites, float minyear, float maxyear, float mintemp, float maxtemp) {
        this.initialize(height, width, 0, 0, sites, minyear, maxyear, mintemp, maxtemp);
    }

    public ScatterGraph(int height, int width, int xoffset, int yoffset, Vector sites, float minyear, float maxyear, float mintemp, float maxtemp) {
        this.initialize(height, width, xoffset, yoffset, sites, minyear, maxyear, mintemp, maxtemp);
    }

    public void resize(int x, int y, int newwidth, int newheight) {
        this.plot_graphics_.clear();
        this.plot_points_.clear();
        this.plot_background_.clear();
        this.resizeGraph(x, y, newheight, newwidth);
        this.axes_displayed_ = false;
        this.plotData();
    }

    private void resizeGraph(int x, int y, int height, int width) {
        this.frame_x = x;
        this.frame_y = y;
        this.frame_width_ = width;
        this.frame_height_ = height;
        this.plot_width_ = this.frame_width_ - 100;
        this.plot_height_ = this.frame_height_ - 100;
        this.resetScale();
    }

    private void setScale(float minyear, float maxyear, float mintemp, float maxtemp) {
        this.min_year_ = minyear;
        this.max_year_ = maxyear;
        this.min_temp_ = mintemp;
        this.max_temp_ = maxtemp;
        this.temp_scale_ = (float)this.plot_height_ / (maxtemp - mintemp);
        this.year_scale_ = (float)this.plot_width_ / (maxyear - minyear);
    }

    private void resetScale() {
        this.setScale(this.min_year_, this.max_year_, this.min_temp_, this.max_temp_);
    }

    public void setDataPoints(Vector sites) {
        this.sites_displayed_ = sites != null ? sites : new Vector();
    }

    private int findPointOnScale(float value, float scale, float offset) {
        float newvalue = (value - offset) * scale;
        return (int)newvalue;
    }

    private int findTempPoint(float value) {
        return this.frame_y + this.frame_height_ - (50 + this.findPointOnScale(value, this.temp_scale_, this.min_temp_));
    }

    private int findYearPoint(float value) {
        return this.frame_x + 50 + this.findPointOnScale(value, this.year_scale_, this.min_year_);
    }

    private OMLine createPlotLine(int x1, int y1, int x2, int y2, Paint color) {
        OMLine line = new OMLine(x1, y1, x2, y2);
        line.setLinePaint(color);
        line.setSelectPaint(Color.white);
        return line;
    }

    private OMLine createGraphLine(float year1, float temp1, float year2, float temp2) {
        int x1 = this.findYearPoint(year1);
        int y1 = this.findTempPoint(temp1);
        int x2 = this.findYearPoint(year2);
        int y2 = this.findTempPoint(temp2);
        OMLine line = this.createPlotLine(x1, y1, x2, y2, this.plot_color_);
        line.setLinePaint(this.plot_color_);
        line.setSelectPaint(this.select_color_);
        return line;
    }

    private OMText createLabel(String text, int x, int y, Paint color, int justification) {
        Font default_font = new Font("TimesRoman", 0, 10);
        OMText label = new OMText(x, y, text, default_font, justification);
        label.setLinePaint(color);
        label.setSelectPaint(Color.white);
        return label;
    }

    private OMText createLabel(String text, int x, int y) {
        return this.createLabel(text, x, y, this.plot_color_, 0);
    }

    private Date GetDateFromFloat(float fdate) {
        long mseconds = (long)((double)(fdate - 1970.0f) * 365.25 * 24.0 * 60.0 * 60.0 * 1000.0);
        Date date = new Date(mseconds);
        return date;
    }

    private String GetStringDateFromFloat(float fdate) {
        Date date = this.GetDateFromFloat(fdate);
        StringBuffer buff = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm MM/dd/yyyy");
        String datestring = sdf.format(date);
        return datestring;
    }

    private void drawGraphAxes() {
        int top = this.frame_y + 50;
        int bottom = this.frame_y + this.frame_height_ - 50;
        int left = this.frame_x + 50;
        int right = this.frame_x + this.frame_width_ - 50;
        String min_year_string = this.GetStringDateFromFloat(this.min_year_);
        String max_year_string = this.GetStringDateFromFloat(this.max_year_);
        OMLine year_axis = this.createPlotLine(left, bottom, right, bottom, this.plot_color_);
        OMLine temp_axis = this.createPlotLine(left, top, left, bottom, this.plot_color_);
        OMText year_min_label = this.createLabel(min_year_string + " ", left, bottom + 10);
        OMText year_max_label = this.createLabel(max_year_string + " ", right - 30, bottom + 10);
        OMText temp_min_label = this.createLabel(this.min_temp_ + " ", left, bottom, this.plot_color_, 2);
        OMText temp_max_label = this.createLabel(this.max_temp_ + " ", left, top, this.plot_color_, 2);
        OMText temp_axis_label = this.createLabel("Temp", left, this.frame_y + this.frame_height_ / 2, this.plot_color_, 2);
        OMText year_axis_label = this.createLabel("Year", this.frame_x + this.frame_width_ / 2, bottom + 15);
        OMRect background = new OMRect(this.frame_x, this.frame_y, this.frame_x + this.frame_width_, this.frame_y + this.frame_height_);
        background.setFillPaint(this.graph_bg_color);
        background.setLinePaint(this.graph_bg_color);
        year_axis.setAppObject(this);
        temp_axis.setAppObject(this);
        this.plot_background_.addOMGraphic(background);
        this.plot_background_.addOMGraphic(year_axis);
        this.plot_background_.addOMGraphic(temp_axis);
        this.plot_background_.addOMGraphic(temp_axis_label);
        this.plot_background_.addOMGraphic(year_axis_label);
        this.plot_background_.addOMGraphic(year_min_label);
        this.plot_background_.addOMGraphic(year_max_label);
        this.plot_background_.addOMGraphic(temp_min_label);
        this.plot_background_.addOMGraphic(temp_max_label);
        this.plot_graphics_.addOMGraphic(this.plot_background_);
        this.axes_displayed_ = true;
    }

    public OMGraphicList getPlotGraphics() {
        return this.plot_graphics_;
    }

    private OMGraphic plotPoint(float year, float temp) {
        int x = this.findYearPoint(year);
        int y = this.findTempPoint(temp);
        String yearstring = this.GetStringDateFromFloat(year);
        String name = "Time: " + yearstring + ", Temperature: " + temp + "C (" + (int)(1.8 * (double)temp + 32.0) + "F)";
        OMCircle graphic = new OMCircle(x, y, 2, 2);
        graphic.setLinePaint(this.plot_color_);
        graphic.setFillPaint(this.plot_color_);
        graphic.setSelectPaint(this.select_color_);
        graphic.setAppObject(name);
        return graphic;
    }

    private Enumeration sortEnumerationOfFloats(Enumeration enumeration) {
        Vector vec = new Vector();
        while (enumeration.hasMoreElements()) {
            vec.addElement(enumeration.nextElement());
        }
        Object[] result = new Float[vec.size()];
        vec.copyInto(result);
        Vector<Object> resultvec = new Vector<Object>(vec.size());
        int i = 0;
        while (i < vec.size()) {
            int j = i + 1;
            while (j < vec.size()) {
                if (((Float)result[i]).floatValue() > ((Float)result[j]).floatValue()) {
                    Object t = result[i];
                    result[i] = result[j];
                    result[j] = t;
                }
                ++j;
            }
            resultvec.addElement(result[i]);
            ++i;
        }
        return resultvec.elements();
    }

    public void plotData() {
        Debug.message("basic", "ScatterGraph.plotData()");
        Enumeration all_sites = this.sites_displayed_.elements();
        int num_elements = 0;
        int num_sites = 0;
        this.plot_points_.clear();
        if (!this.axes_displayed_) {
            this.drawGraphAxes();
        }
        while (all_sites.hasMoreElements()) {
            GLOBESite site = (GLOBESite)all_sites.nextElement();
            Enumeration years = this.sortEnumerationOfFloats(site.getAllYears());
            float last_year = Float.NaN;
            float last_temp = Float.NaN;
            ++num_sites;
            while (years.hasMoreElements()) {
                float year = ((Float)years.nextElement()).floatValue();
                float temp = site.getValueForYear(year);
                OMGraphic point = this.plotPoint(year, temp);
                this.plot_points_.addOMGraphic(point);
                if (!Float.isNaN(last_year)) {
                    OMLine line = this.createGraphLine(last_year, last_temp, year, temp);
                    this.plot_points_.addOMGraphic(line);
                }
                last_year = year;
                last_temp = temp;
                ++num_elements;
            }
        }
        this.plot_graphics_.addOMGraphic(this.plot_points_);
    }

    public OMGraphic selectPoint(int x, int y, float range) {
        OMGraphic selection = this.plot_points_.selectClosest(x, y, range);
        return selection;
    }
}

