/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.mif;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.mif.MIFLoader;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class MIFLayer
extends OMGraphicHandlerLayer {
    public static final String MIF_FileProperty = "mifFile";
    public static final String textVisibleProperty = "textVisible";
    public static final String pointVisibleProperty = "pointVisible";
    boolean accurate = true;
    MIFLoader mifl = null;

    public MIFLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String mifFileName = props.getProperty(prefix + MIF_FileProperty);
        float textVisible = PropUtils.floatFromProperties(props, prefix + textVisibleProperty, -1.0f);
        float pointVisible = PropUtils.floatFromProperties(props, prefix + pointVisibleProperty, -1.0f);
        try {
            BufferedReader bfr = new BufferedReader(new FileReader(mifFileName));
            this.mifl = new MIFLoader(bfr, this.accurate, textVisible, pointVisible);
        }
        catch (IOException ioe) {
            Debug.error("MIFLayer: didn't find file " + mifFileName);
            return;
        }
    }

    public void setAccuracy(boolean accurate) {
        this.accurate = accurate;
    }

    public synchronized OMGraphicList prepare() {
        if (this.mifl != null) {
            OMGraphicList list = this.mifl.getList();
            if (list != null) {
                list.generate(this.getProjection());
            }
            return list;
        }
        return new OMGraphicList();
    }
}

