/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.layer.DeclutterMatrix;
import com.bbn.openmap.layer.location.Location;
import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.layer.location.LocationMenuItem;
import com.bbn.openmap.layer.location.LocationPopupMenu;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.SwingWorker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class LocationLayer
extends Layer
implements MapMouseListener {
    protected DeclutterMatrix declutterMatrix = null;
    protected boolean useDeclutterMatrix = false;
    protected boolean allowPartials = true;
    protected Vector omGraphics;
    protected LocationHandler[] dataHandlers;
    protected String[] dataHandlerNames;
    protected MapBean map;
    protected LocationPopupMenu backgroundMenu;
    protected LocationPopupMenu locMenu;
    public static final String recenter = "Re-center map";
    public static final String cancel = "Cancel";
    public static final String UseDeclutterMatrixProperty = "useDeclutter";
    public static final String DeclutterMatrixClassProperty = "declutterMatrix";
    public static final String AllowPartialsProperty = "allowPartials";
    public static final String LocationHandlerListProperty = "locationHandlers";
    protected LocationWorker currentWorker;
    protected boolean cancelled = false;
    protected Box box = null;
    boolean setNameOnLine = false;

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        String realPrefix = "";
        if (prefix != null) {
            realPrefix = prefix + ".";
        }
        this.setLocationHandlers(realPrefix, properties);
        this.declutterMatrix = (DeclutterMatrix)PropUtils.objectFromProperties(properties, realPrefix + DeclutterMatrixClassProperty);
        this.allowPartials = PropUtils.booleanFromProperties(properties, realPrefix + AllowPartialsProperty, true);
        if (this.declutterMatrix != null) {
            this.useDeclutterMatrix = PropUtils.booleanFromProperties(properties, realPrefix + UseDeclutterMatrixProperty, this.useDeclutterMatrix);
            this.declutterMatrix.setAllowPartials(this.allowPartials);
            Debug.message("location", "LocationLayer: Found DeclutterMatrix to use");
        } else {
            this.useDeclutterMatrix = false;
        }
    }

    public synchronized void setGraphicList(Vector aList) {
        this.omGraphics = aList;
    }

    public synchronized Vector getGraphicList() {
        return this.omGraphics;
    }

    public void setDeclutterMatrix(DeclutterMatrix dm) {
        this.declutterMatrix = dm;
    }

    public DeclutterMatrix getDeclutterMatrix() {
        return this.declutterMatrix;
    }

    public void setUseDeclutterMatrix(boolean set) {
        this.useDeclutterMatrix = set;
    }

    public boolean getUseDeclutterMatrix() {
        return this.useDeclutterMatrix;
    }

    public synchronized void setCancelled(boolean set) {
        this.cancelled = set;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized MapMouseListener getMapMouseListener() {
        return this;
    }

    public void reloadData() {
        if (this.dataHandlers != null) {
            int i = 0;
            while (i < this.dataHandlers.length) {
                this.dataHandlers[i].reloadData();
                ++i;
            }
        }
    }

    public synchronized void renderDataForProjection(Projection proj, Graphics g) {
        if (proj == null) {
            Debug.error("LocationLayer.renderDataForProjection: null projection!");
            return;
        }
        if (!proj.equals(this.getProjection())) {
            this.setProjection(proj.makeClone());
            this.setGraphicList(this.prepare());
        }
        this.paint(g);
    }

    public void projectionChanged(ProjectionEvent e) {
        if (Debug.debugging("basic")) {
            Debug.output(this.getName() + "|LocationLayer.projectionChanged()");
        }
        if (this.setProjection(e) == null) {
            this.repaint();
            return;
        }
        this.setGraphicList(null);
        this.doPrepare();
    }

    protected synchronized void workerComplete(LocationWorker worker) {
        if (!this.isCancelled()) {
            this.currentWorker = null;
            this.setGraphicList((Vector)worker.get());
            this.repaint();
        } else {
            this.setCancelled(false);
            this.currentWorker = new LocationWorker();
            this.currentWorker.execute();
        }
    }

    public void doPrepare() {
        if (this.currentWorker == null) {
            this.currentWorker = new LocationWorker();
            this.currentWorker.execute();
        } else {
            this.setCancelled(true);
        }
    }

    public synchronized Vector prepare() {
        if (this.isCancelled()) {
            if (Debug.debugging("location")) {
                Debug.output(this.getName() + "|LocationLayer.prepare(): aborted.");
            }
            return null;
        }
        Vector omGraphicList = new Vector();
        Projection projection = this.getProjection();
        if (projection == null) {
            if (Debug.debugging("location")) {
                Debug.output(this.getName() + "|LocationLayer.prepare(): null projection, layer not ready.");
            }
            return omGraphicList;
        }
        if (Debug.debugging("location")) {
            Debug.output(this.getName() + "|LocationLayer.prepare(): doing it");
        }
        if (this.useDeclutterMatrix && this.declutterMatrix != null) {
            this.declutterMatrix.setWidth(projection.getWidth());
            this.declutterMatrix.setHeight(projection.getHeight());
            this.declutterMatrix.create();
        }
        if (Debug.debugging("location")) {
            Debug.output(this.getName() + "|LocationLayer.prepare(): " + "calling prepare with projection: " + projection + " ul = " + projection.getUpperLeft() + " lr = " + projection.getLowerRight());
        }
        LatLonPoint ul = projection.getUpperLeft();
        LatLonPoint lr = projection.getLowerRight();
        if (Debug.debugging("location")) {
            float delta = lr.getLongitude() - ul.getLongitude();
            Debug.output(this.getName() + "|LocationLayer.prepare(): " + " ul.lon =" + ul.getLongitude() + " lr.lon = " + lr.getLongitude() + " delta = " + delta);
        }
        if (this.dataHandlers != null) {
            int i = 0;
            while (i < this.dataHandlers.length) {
                this.dataHandlers[i].get(ul.getLatitude(), ul.getLongitude(), lr.getLatitude(), lr.getLongitude(), omGraphicList);
                ++i;
            }
        }
        int size = 0;
        if (omGraphicList != null) {
            size = omGraphicList.size();
            if (Debug.debugging("basic")) {
                Debug.output(this.getName() + "|LocationLayer.prepare(): finished with " + size + " graphics");
            }
            Enumeration things = omGraphicList.elements();
            while (things.hasMoreElements()) {
                OMGraphic thingy = (OMGraphic)things.nextElement();
                if (this.useDeclutterMatrix && thingy instanceof Location) {
                    Location loc = (Location)thingy;
                    loc.generate(projection, this.declutterMatrix);
                    continue;
                }
                thingy.generate(projection);
            }
        } else if (Debug.debugging("basic")) {
            Debug.output(this.getName() + "|LocationLayer.prepare(): finished with null graphics list");
        }
        return omGraphicList;
    }

    public void paint(Graphics g) {
        if (Debug.debugging("location")) {
            Debug.output(this.getName() + "|LocationLayer.paint()");
        }
        Vector vlist = this.getGraphicList();
        Object[] list = null;
        if (vlist != null) {
            list = vlist.toArray();
        }
        if (list != null) {
            int j = 0;
            while (j < 2) {
                int i = list.length - 1;
                while (i >= 0) {
                    OMGraphic loc = (OMGraphic)list[i];
                    if (j == 0) {
                        if (loc instanceof Location) {
                            ((Location)loc).renderLocation(g);
                        } else {
                            loc.render(g);
                        }
                    } else if (loc instanceof Location) {
                        ((Location)loc).renderName(g);
                    }
                    --i;
                }
                ++j;
            }
        } else if (Debug.debugging("location")) {
            Debug.error(this.getName() + "|LocationLayer: paint(): Null list...");
        }
    }

    protected void setLocationHandlers(String prefix, Properties p) {
        String handlersValue = p.getProperty(prefix + LocationHandlerListProperty);
        if (Debug.debugging("location")) {
            Debug.output(this.getName() + "| handlers = \"" + handlersValue + "\"");
        }
        if (handlersValue == null) {
            if (Debug.debugging("location")) {
                Debug.output("No property \"" + prefix + LocationHandlerListProperty + "\" found in application properties.");
            }
            return;
        }
        StringTokenizer tokens = new StringTokenizer(handlersValue, " ");
        Vector<String> handlerNames = new Vector<String>();
        while (tokens.hasMoreTokens()) {
            handlerNames.addElement(tokens.nextToken());
        }
        if (Debug.debugging("location")) {
            Debug.output("OpenMap.getLocationHandlers(): " + handlerNames);
        }
        int nHandlerNames = handlerNames.size();
        Vector<LocationHandler> handlers = new Vector<LocationHandler>(nHandlerNames);
        Vector<String> goodNames = new Vector<String>(nHandlerNames);
        int i = 0;
        while (i < nHandlerNames) {
            String handlerName = (String)handlerNames.elementAt(i);
            String classProperty = handlerName + ".class";
            String className = p.getProperty(classProperty);
            String nameProperty = handlerName + ".prettyName";
            String prettyName = p.getProperty(nameProperty);
            if (className == null) {
                Debug.error("Failed to locate property \"" + classProperty + "\"\nSkipping handler \"" + handlerName + "\"");
            } else {
                try {
                    Object obj;
                    if (Debug.debugging("location")) {
                        Debug.output("OpenMap.getHandlers():instantiating handler \"" + className + "\"");
                    }
                    if ((obj = Class.forName(className).newInstance()) instanceof LocationHandler) {
                        LocationHandler lh = (LocationHandler)obj;
                        lh.setProperties(handlerName, p);
                        lh.setLayer(this);
                        handlers.addElement(lh);
                        goodNames.addElement(prettyName != null ? prettyName : "");
                    }
                }
                catch (ClassNotFoundException e) {
                    Debug.error("Handler class not found: \"" + className + "\"\nSkipping handler \"" + handlerName + "\"");
                }
                catch (IOException e) {
                    Debug.error("IO Exception instantiating class \"" + className + "\"\nSkipping handler \"" + handlerName + "\"");
                }
                catch (Exception e) {
                    Debug.error("Exception instantiating class \"" + className + "\": " + e);
                }
            }
            ++i;
        }
        int nHandlers = handlers.size();
        this.dataHandlers = new LocationHandler[nHandlers];
        this.dataHandlerNames = new String[nHandlers];
        if (nHandlers != 0) {
            handlers.copyInto(this.dataHandlers);
            goodNames.copyInto(this.dataHandlerNames);
        }
    }

    public void removed(Container cont) {
        if (this.dataHandlers != null) {
            int i = 0;
            while (i < this.dataHandlers.length) {
                this.dataHandlers[i].removed(cont);
                ++i;
            }
        }
    }

    public void setLocationHandlers(LocationHandler[] handlers) {
        this.dataHandlers = handlers;
        int i = 0;
        while (i < handlers.length) {
            handlers[i].setLayer(this);
            ++i;
        }
        this.resetPalette();
    }

    public LocationHandler[] getLocationHandlers() {
        return this.dataHandlers;
    }

    public void setLocationHandlerNames(String[] handlerNames) {
        this.dataHandlerNames = handlerNames;
        this.resetPalette();
    }

    public String[] getLocationHandlerNames() {
        return this.dataHandlerNames;
    }

    protected void resetPalette() {
        this.box = null;
        super.resetPalette();
    }

    protected WindowSupport createWindowSupport() {
        return new WindowSupport(this.getGUI(), this.getName());
    }

    public Component getGUI() {
        if (this.box == null) {
            this.box = Box.createVerticalBox();
            int nHandlers = 0;
            if (this.dataHandlers != null) {
                nHandlers = this.dataHandlers.length;
            }
            JPanel[] panels = new JPanel[nHandlers];
            Box box2 = Box.createVerticalBox();
            int i = 0;
            while (i < nHandlers) {
                String handlerName = this.dataHandlerNames != null && i < this.dataHandlerNames.length ? this.dataHandlerNames[i] : "";
                panels[i] = PaletteHelper.createPaletteJPanel(handlerName);
                panels[i].add(this.dataHandlers[i].getGUI());
                box2.add(panels[i]);
                ++i;
            }
            JScrollPane scrollPane = new JScrollPane(box2, 20, 30);
            scrollPane.setAlignmentX(0.5f);
            scrollPane.setAlignmentY(0.0f);
            this.box.add(scrollPane);
            if (this.declutterMatrix != null) {
                JPanel dbp = new JPanel(new GridLayout(0, 1));
                JCheckBox declutterButton = new JCheckBox("Declutter Names", this.useDeclutterMatrix);
                declutterButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        JCheckBox jcb = (JCheckBox)ae.getSource();
                        LocationLayer.this.useDeclutterMatrix = jcb.isSelected();
                        if (LocationLayer.this.isVisible()) {
                            LocationLayer.this.doPrepare();
                        }
                    }
                });
                declutterButton.setToolTipText("<HTML><BODY>Move location names so they don't overlap.<br>This may take awhile if you are zoomed out.</BODY></HTML>");
                dbp.add(declutterButton);
                this.box.add(dbp);
            }
        }
        return this.box;
    }

    public Location findClosestLocation(MouseEvent evt) {
        Vector graphics = this.getGraphicList();
        if (graphics != null) {
            int x = evt.getX();
            int y = evt.getY();
            float limit = 4.0f;
            Location ret = null;
            float closestDistance = Float.MAX_VALUE;
            int size = graphics.size();
            int i = 0;
            while (i < size) {
                Location loc = (Location)graphics.elementAt(i);
                float currentDistance = loc.distance(x, y);
                if (currentDistance < closestDistance) {
                    ret = loc;
                    closestDistance = currentDistance;
                }
                ++i;
            }
            if (closestDistance <= limit) {
                return ret;
            }
        }
        return null;
    }

    public String[] getMouseModeServiceList() {
        String[] services = new String[]{SelectMouseMode.modeID};
        return services;
    }

    protected void showMapPopup(MouseEvent evt, MapBean map) {
        if (this.backgroundMenu == null) {
            this.backgroundMenu = new LocationPopupMenu();
            this.backgroundMenu.add(new LocationMenuItem(recenter, this.backgroundMenu, this));
            this.backgroundMenu.add(new LocationMenuItem(cancel, this.backgroundMenu, this));
            this.backgroundMenu.setMap(map);
        }
        this.backgroundMenu.setEvent(evt);
        this.backgroundMenu.show(this, evt.getX(), evt.getY());
    }

    protected void showLocationPopup(MouseEvent evt, Location loc, MapBean map) {
        if (this.locMenu == null) {
            this.locMenu = new LocationPopupMenu();
            this.locMenu.setMap(map);
        }
        this.locMenu.removeAll();
        this.locMenu.setEvent(evt);
        this.locMenu.setLoc(loc);
        this.locMenu.add(new LocationMenuItem(recenter, this.locMenu, this));
        this.locMenu.add(new LocationMenuItem(cancel, this.locMenu, this));
        this.locMenu.addSeparator();
        LocationHandler lh = loc.getLocationHandler();
        if (lh != null) {
            lh.fillLocationPopUpMenu(this.locMenu);
        }
        this.locMenu.show(this, evt.getX(), evt.getY());
    }

    public boolean mousePressed(MouseEvent evt) {
        if (!this.isVisible()) {
            return false;
        }
        Location loc = this.findClosestLocation(evt);
        if (this.map == null) {
            try {
                this.map = (MapBean)SwingUtilities.getAncestorOfClass(Class.forName("com.bbn.openmap.MapBean"), this);
            }
            catch (ClassNotFoundException e) {
                Debug.error("LocationLayer: Whatza MapBean??");
            }
        }
        if (loc == null) {
            Debug.message("location", "Clicked on background");
            this.showMapPopup(evt, this.map);
        } else {
            Debug.message("location", "Clicked on location");
            this.showLocationPopup(evt, loc, this.map);
        }
        return true;
    }

    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    public boolean mouseClicked(MouseEvent evt) {
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public boolean mouseMoved(MouseEvent evt) {
        if (!this.isVisible()) {
            return false;
        }
        Location loc = this.findClosestLocation(evt);
        if (loc == null) {
            if (this.setNameOnLine) {
                this.fireRequestInfoLine("");
                this.setNameOnLine = false;
            }
            return false;
        }
        this.fireRequestInfoLine(loc.getName());
        this.setNameOnLine = true;
        return true;
    }

    public void mouseMoved() {
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + UseDeclutterMatrixProperty, new Boolean(this.useDeclutterMatrix).toString());
        if (this.declutterMatrix != null) {
            props.put(prefix + DeclutterMatrixClassProperty, this.declutterMatrix.getClass().getName());
            props.put(prefix + AllowPartialsProperty, new Boolean(this.declutterMatrix.isAllowPartials()).toString());
        }
        StringBuffer handlerList = new StringBuffer();
        if (this.dataHandlers != null) {
            int i = 0;
            while (i < this.dataHandlers.length) {
                String pp = this.dataHandlers[i].getPropertyPrefix();
                handlerList.append(" " + pp);
                props.put(pp + ".prettyName", this.dataHandlerNames[i]);
                this.dataHandlers[i].getProperties(props);
                ++i;
            }
        }
        props.put(prefix + LocationHandlerListProperty, handlerList.toString());
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put(UseDeclutterMatrixProperty, "Flag for using the declutter matrix (true/false)");
        list.put(DeclutterMatrixClassProperty, "Class name of the declutter matrix to use");
        list.put(AllowPartialsProperty, "Flag to allow labels to run off the edge of the map (true/false)");
        list.put(LocationHandlerListProperty, "Space-separated list of unique names to use to scope the LocationHandler property definitions");
        if (this.dataHandlers != null) {
            int i = 0;
            while (i < this.dataHandlers.length) {
                this.dataHandlers[i].getPropertyInfo(list);
                ++i;
            }
        }
        return list;
    }

    class LocationWorker
    extends SwingWorker {
        public Object construct() {
            if (Debug.debugging("location")) {
                Debug.output(LocationLayer.this.getName() + "|LocationWorker.construct()");
            }
            LocationLayer.this.fireStatusUpdate(8342);
            try {
                return LocationLayer.this.prepare();
            }
            catch (OutOfMemoryError e) {
                String msg = LocationLayer.this.getName() + "|LocationLayer.LocationWorker.construct(): " + e;
                Debug.error(msg);
                e.printStackTrace();
                LocationLayer.this.fireRequestMessage(new InfoDisplayEvent(this, msg));
                LocationLayer.this.fireStatusUpdate(8359);
                return null;
            }
        }

        public void finished() {
            LocationLayer.this.workerComplete(this);
            LocationLayer.this.fireStatusUpdate(8359);
        }
    }
}

