/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.layer.DeclutterMatrix;
import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class Location
extends OMGraphic {
    public float lat = 0.0f;
    public float lon = 0.0f;
    public int xOffset = 0;
    public int yOffset = 0;
    public int x = 0;
    public int y = 0;
    public String name = null;
    public LocationHandler handler;
    public static final int DECLUTTER_LOCALLY = -1;
    public static final int DECLUTTER_ANYWHERE = -2;
    protected OMText label = null;
    protected OMGraphic location = null;
    protected String details = "";
    protected boolean showLocation = true;
    protected boolean showName = true;
    public int origYLabelOffset = 0;
    public int origXLabelOffset = 0;
    public static final int DEFAULT_SPACING = 6;
    protected int declutterLimit = -1;
    protected boolean allowDecluttering = true;
    protected int horizontalLabelBuffer = 0;
    protected int currentFontDescent = 0;

    public Location() {
    }

    public Location(float latitude, float longitude, String name, OMGraphic locationMarker) {
        this.setLocation(latitude, longitude);
        this.name = name;
        if (Debug.debugging("locationdetail")) {
            Debug.output("Location Lat/Lon(" + latitude + ", " + longitude + ", " + name + ")");
        }
        this.location = locationMarker == null ? new OMPoint(this.lat, this.lon) : locationMarker;
        this.label = new OMText(this.lat, this.lon, 0, 0, name, 0);
    }

    public Location(int x, int y, String name, OMGraphic locationMarker) {
        this.setLocation(x, y);
        this.name = name;
        if (Debug.debugging("locationdetail")) {
            Debug.output("Location XY(" + x + ", " + y + ", " + name + ")");
        }
        this.location = locationMarker == null ? new OMPoint(x, y) : locationMarker;
        this.label = new OMText(x, y, name, 0);
    }

    public Location(float latitude, float longitude, int xOffset, int yOffset, String name, OMGraphic locationMarker) {
        this.setLocation(latitude, longitude, xOffset, yOffset);
        this.name = name;
        if (Debug.debugging("locationdetail")) {
            Debug.output("Location(" + latitude + ", " + longitude + ", offset " + this.x + ", " + this.y + ", " + name + ")");
        }
        this.location = locationMarker == null ? new OMPoint(this.lat, this.lon, xOffset, yOffset) : locationMarker;
        this.label = new OMText(this.lat, this.lon, xOffset, yOffset, name, 0);
    }

    public void setLocation(float latitude, float longitude) {
        this.lat = latitude;
        this.lon = longitude;
        this.origYLabelOffset = 0;
        this.origXLabelOffset = 6;
        this.setRenderType(1);
        if (this.location != null && this.label != null) {
            this.setGraphicLocations(latitude, longitude);
        }
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        this.origYLabelOffset = y;
        this.origXLabelOffset = x + 6;
        this.setRenderType(2);
        if (this.location != null && this.label != null) {
            this.setGraphicLocations(x, y);
        }
    }

    public void setLocation(float latitude, float longitude, int xOffset, int yOffset) {
        this.lat = latitude;
        this.lon = longitude;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.origYLabelOffset = yOffset;
        this.origXLabelOffset = xOffset + 6;
        this.setRenderType(3);
        if (this.location != null && this.label != null) {
            this.setGraphicLocations(latitude, longitude, xOffset, yOffset);
        }
    }

    public void setLocation(int x, int y, Projection proj) {
        int renderType = this.getRenderType();
        switch (renderType) {
            case 1: {
                if (proj != null) {
                    LatLonPoint llp = proj.inverse(x, y);
                    this.setLocation(llp.getLatitude(), llp.getLongitude());
                    break;
                }
                Debug.error("Location can't set lat/lon coordinates without a projection");
                break;
            }
            case 3: {
                if (proj != null) {
                    LatLonPoint llp = proj.inverse(x, y);
                    this.setLocation(llp.getLatitude(), llp.getLongitude(), this.xOffset, this.yOffset);
                    break;
                }
                Debug.error("Location can't set lat/lon coordinates without a projection");
                break;
            }
            default: {
                this.setLocation(x, y);
            }
        }
    }

    public abstract void setGraphicLocations(float var1, float var2);

    public abstract void setGraphicLocations(int var1, int var2);

    public abstract void setGraphicLocations(float var1, float var2, int var3, int var4);

    public void setLocationHandler(LocationHandler lh) {
        this.handler = lh;
    }

    public LocationHandler getLocationHandler() {
        return this.handler;
    }

    public void setLocationPaint(Paint locationPaint) {
        if (this.location != null) {
            this.location.setLinePaint(locationPaint);
        }
    }

    public OMText getLabel() {
        return this.label;
    }

    public void setLabel(OMText lable) {
        this.label = lable;
    }

    public OMGraphic getLocationMarker() {
        return this.location;
    }

    public void setLocationMarker(OMGraphic graphic) {
        this.location = graphic;
    }

    public void setShowLocation(boolean showLocations) {
        this.showLocation = showLocations;
    }

    public boolean isShowLocation() {
        return this.showLocation;
    }

    public void setShowName(boolean showNames) {
        this.showName = showNames;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.label != null) {
            this.label.setData(name);
        }
    }

    public void setDetails(String det) {
        this.details = det;
    }

    public String getDetails() {
        return this.details;
    }

    public void showDetails(Layer layer) {
        if (this.details != null) {
            layer.fireRequestBrowserContent(this.details);
        }
    }

    public void setAllowDecluttering(boolean allow) {
        this.allowDecluttering = allow;
    }

    public boolean isAllowDecluttering() {
        return this.allowDecluttering;
    }

    public void setHorizontalLabelBuffer(int buffer) {
        this.horizontalLabelBuffer = buffer;
    }

    public int getHorizontalLabelBuffer() {
        return this.horizontalLabelBuffer;
    }

    public boolean generate(Projection proj, DeclutterMatrix declutterMatrix) {
        boolean ret = this.generate(proj);
        if (declutterMatrix != null && this.label != null && this.allowDecluttering) {
            this.declutterLabel(declutterMatrix, proj);
        }
        return ret;
    }

    public void setDeclutterLimit(int value) {
        this.declutterLimit = value < 0 && value != -1 ? -2 : value;
    }

    public int getDeclutterLimit() {
        return this.declutterLimit;
    }

    public boolean generate(Projection proj) {
        Graphics2D g;
        if (this.label != null) {
            this.label.setY(this.origYLabelOffset);
            this.label.setX(this.origXLabelOffset);
        }
        if ((g = DeclutterMatrix.getGraphics()) != null && this.label != null) {
            g.setFont(this.label.getFont());
            int height = g.getFontMetrics().getAscent();
            this.currentFontDescent = g.getFontMetrics().getDescent();
            this.label.setX(this.label.getX() + this.horizontalLabelBuffer);
            this.label.setY(this.label.getY() + height / 2 - 2);
        }
        if (this.label != null) {
            this.label.generate(proj);
            this.label.prepareForRender(g);
        }
        if (this.location != null) {
            this.location.generate(proj);
        }
        return true;
    }

    public void render(Graphics g) {
        this.renderLocation(g);
        this.renderName(g);
    }

    public void renderName(Graphics g) {
        boolean globalShowNames = false;
        boolean forceGlobal = false;
        if (this.handler != null) {
            globalShowNames = this.handler.isShowNames();
            forceGlobal = this.handler.isForceGlobal();
        }
        if (this.label != null && (forceGlobal && globalShowNames || !forceGlobal && this.showName)) {
            this.label.render(g);
        }
    }

    public void renderLocation(Graphics g) {
        boolean globalShowLocations = false;
        boolean forceGlobal = false;
        if (this.handler != null) {
            globalShowLocations = this.handler.isShowLocations();
            forceGlobal = this.handler.isForceGlobal();
        }
        if (this.location != null && (forceGlobal && globalShowLocations || !forceGlobal && this.showLocation)) {
            this.location.render(g);
        }
    }

    public float distance(int x, int y) {
        float labelDist = Float.MAX_VALUE;
        float locationDist = Float.MAX_VALUE;
        boolean globalShowLocations = false;
        boolean globalShowNames = false;
        if (this.handler != null) {
            globalShowLocations = this.handler.isShowLocations();
            globalShowNames = this.handler.isShowNames();
        }
        if (this.showLocation && this.location != null) {
            locationDist = this.location.distance(x, y);
        }
        if (this.showName && this.label != null) {
            labelDist = this.label.distance(x, y);
        }
        return locationDist > labelDist ? labelDist : locationDist;
    }

    protected void declutterLabel(DeclutterMatrix declutter, Projection proj) {
        if (Debug.debugging("locationdetail")) {
            Debug.output("\nLocation::RepositionText => " + this.label.getData());
        }
        if (this.isShowName() || this.handler.isShowNames()) {
            if (this.label == null || this.label.getPolyBounds() == null) {
                return;
            }
            Rectangle bounds = this.label.getPolyBounds().getBounds();
            int height = (int)(bounds.getHeight() - (double)(this.currentFontDescent / 2));
            int width = (int)bounds.getWidth();
            Point p = this.label.getMapLocation();
            if (Debug.debugging("locationdetail")) {
                Debug.output("old point X Y =>" + p.x + " " + p.y + "    height = " + height + " width = " + width);
            }
            int limit = this.declutterLimit == -1 ? height * 2 : this.declutterLimit;
            Point newpoint = declutter.setNextOpen(p, width, height, limit);
            if (Debug.debugging("locationdetail")) {
                Debug.output("new point X Y =>" + newpoint.x + " " + newpoint.y);
            }
            this.label.setMapLocation(newpoint);
        }
    }

    public static float convertCoordinateString(String coord) throws NumberFormatException {
        String mantissa;
        float ret = 0.0f;
        char direction = coord.charAt(0);
        if (direction == 'N' || direction == 'S' || direction == 'n' || direction == 's') {
            float whole = new Float(coord.substring(1, 3)).floatValue();
            ret += whole;
            mantissa = coord.substring(3);
        } else if (direction == 'W' || direction == 'E' || direction == 'w' || direction == 'e') {
            ret += new Float(coord.substring(1, 4)).floatValue();
            mantissa = coord.substring(4);
        } else {
            throw new NumberFormatException("Location.convertCoordinateString wants <[NSWE]XXXXXXXX>, not getting it.");
        }
        ret += new Float(mantissa).floatValue() / (float)Math.pow(10.0, mantissa.length());
        if (direction == 'W' || direction == 'S' || direction == 'w' || direction == 's') {
            ret *= -1.0f;
        }
        return ret;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            Debug.output("  usage: java com.bbn.openmap.layer.location.Location <[NSWE]XXXXXXXX>");
            return;
        }
        float ret = Location.convertCoordinateString(args[0]);
        System.out.println(ret);
    }
}

