/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkActionList;
import com.bbn.openmap.layer.link.LinkActionRequest;
import com.bbn.openmap.layer.link.LinkGraphicList;
import com.bbn.openmap.layer.link.LinkMapRequest;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.layer.link.LinkUtil;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.net.Socket;

public class LinkServer
extends Thread
implements LinkPropertiesConstants {
    protected Link link;

    public LinkServer() {
    }

    public LinkServer(Socket s) {
        try {
            this.link = new Link(s);
        }
        catch (IOException ioe) {
            System.err.println("LinkServer: IOException while creating child server:");
            System.err.println(ioe);
        }
    }

    public void run() {
        try {
            this.handleClient();
        }
        catch (IOException ioe) {
            this.link.cleanUp();
            this.link = null;
            if (Debug.debugging("link")) {
                System.err.println(ioe);
            }
            Debug.output("LinkServer: Client disconnected");
            System.gc();
        }
    }

    public void handleClient() throws IOException {
        while (true) {
            this.link.readAndParse();
            boolean validQuery = false;
            if (validQuery) continue;
            this.huh(this.link);
        }
    }

    public void huh(Link link) throws IOException {
        link.start("<OMLINK:HUH?>");
        link.end("\r");
    }

    public void getRectangle(LinkMapRequest query, Link link) throws IOException {
        boolean count = false;
        LinkGraphicList lgl = new LinkGraphicList(link, new LinkProperties());
        lgl.end("\n");
        int des = LinkUtil.setMask(0, 1);
        new LinkActionRequest(link, des, "\r");
    }

    public void handleGesture(LinkActionRequest lar, Link link) throws IOException {
        LinkProperties properties = new LinkProperties();
        properties.setProperty("info", "Mouse Clicked at: x = " + lar.getX() + ", y = " + lar.getY());
        LinkActionList lal = new LinkActionList(link, properties);
        int descriptor = lar.getDescriptor();
        String gid = lar.getProperties().getProperty("graphicID");
        if (gid == null) {
            System.out.println("Deselecting graphics");
            lal.deselectGraphics();
        } else {
            System.out.println("Selecting graphic");
            lal.modifyGraphic(8, lar.getProperties());
        }
        lal.end("\r");
    }
}

