/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.asrp;

import com.bbn.openmap.dataAccess.asrp.ASRPConstants;
import com.bbn.openmap.dataAccess.asrp.ASRPDirectory;
import com.bbn.openmap.dataAccess.asrp.ASRPDirectoryHandler;
import com.bbn.openmap.dataAccess.asrp.TransmittalHeaderFile;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.DataBoundsProvider;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ASRPLayer
extends OMGraphicHandlerLayer
implements DataBoundsProvider,
ASRPConstants {
    protected ASRPDirectoryHandler asrpHandler;
    protected String[] thfPaths = null;
    protected String[] asrpDirs = null;
    protected boolean showCoverage = true;
    protected DrawingAttributes coverageDrawingAttributes;
    public static final String ShowCoverageProperty = "showCoverage";
    public static final String ASRPDirectoryProperty = "asrpDirs";
    public static final String THFProperty = "thf";
    protected JPanel guiPanel = null;
    static /* synthetic */ Class class$com$bbn$openmap$layer$asrp$ASRPLayer;

    public ASRPLayer() {
        this.setName("ASRP");
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
        this.coverageDrawingAttributes = DrawingAttributes.getDefaultClone();
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList ret = null;
        Projection proj = this.getProjection();
        if (proj == null) {
            return ret;
        }
        try {
            if (this.asrpHandler == null) {
                this.asrpHandler = this.initialize();
            }
            if (!(proj instanceof EqualArc)) {
                this.fireRequestInfoLine("ASRP data requires an Equal Arc projection (CADRG/LLXY)");
            } else {
                ret = this.asrpHandler.getImagesForProjection((EqualArc)proj);
            }
            if (ret == null && this.showCoverage) {
                ret = this.asrpHandler.getCoverageBounds(proj, this.coverageDrawingAttributes);
            }
        }
        catch (IOException ioe) {
            Debug.error("ASRPLayer(" + this.getName() + ") caught exception fetching images:\n" + ioe.getMessage());
        }
        return ret;
    }

    protected ASRPDirectoryHandler initialize() {
        ASRPDirectoryHandler asrpDirHandler;
        block5: {
            block4: {
                asrpDirHandler = new ASRPDirectoryHandler();
                if (this.thfPaths == null) break block4;
                int i = 0;
                while (i < this.thfPaths.length) {
                    try {
                        asrpDirHandler.add(new TransmittalHeaderFile(this.thfPaths[i]));
                    }
                    catch (IOException ioe) {
                        Debug.error("ASRPLayer (" + this.getName() + ") caught exception trying to read " + "TRANSH01.THF" + ": " + ioe.getMessage());
                    }
                    ++i;
                }
                break block5;
            }
            if (this.asrpDirs == null) break block5;
            int i = 0;
            while (i < this.asrpDirs.length) {
                asrpDirHandler.add(new ASRPDirectory(this.asrpDirs[i]));
                ++i;
            }
        }
        return asrpDirHandler;
    }

    public ASRPDirectoryHandler getASRPHandler() {
        return this.asrpHandler;
    }

    public void setASRPHandler(ASRPDirectoryHandler asrpHandlerIn) {
        this.asrpHandler = asrpHandlerIn;
    }

    public void setPaths(String[] pathsIn) {
        if (pathsIn != null) {
            if (pathsIn[0].indexOf("TRANSH01.THF") != -1) {
                this.thfPaths = pathsIn;
            } else {
                this.asrpDirs = pathsIn;
            }
            this.asrpHandler = null;
        }
    }

    public String[] getPaths() {
        if (this.thfPaths != null) {
            return this.thfPaths;
        }
        return this.asrpDirs;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.coverageDrawingAttributes.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.thfPaths = PropUtils.initPathsFromProperties(props, prefix + THFProperty, this.thfPaths);
        if (this.thfPaths == null) {
            this.asrpDirs = PropUtils.initPathsFromProperties(props, prefix + ASRPDirectoryProperty, this.asrpDirs);
        }
        this.showCoverage = PropUtils.booleanFromProperties(props, prefix + ShowCoverageProperty, this.showCoverage);
    }

    public Properties getProperties(Properties props) {
        int i;
        StringBuffer pathString;
        String[] p;
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.thfPaths != null) {
            p = this.thfPaths;
            pathString = new StringBuffer();
            if (p != null) {
                i = 0;
                while (i < p.length) {
                    if (p[i] != null) {
                        pathString.append(p[i]);
                        if (i < p.length - 1) {
                            pathString.append(";");
                        }
                    }
                    ++i;
                }
            }
            props.put(prefix + THFProperty, pathString.toString());
        } else {
            props.put(prefix + THFProperty, "");
        }
        if (this.asrpDirs != null) {
            p = this.asrpDirs;
            pathString = new StringBuffer();
            if (p != null) {
                i = 0;
                while (i < p.length) {
                    if (p[i] != null) {
                        pathString.append(p[i]);
                        if (i < p.length - 1) {
                            pathString.append(";");
                        }
                    }
                    ++i;
                }
            }
            props.put(prefix + ASRPDirectoryProperty, pathString.toString());
        } else {
            props.put(prefix + ASRPDirectoryProperty, "");
        }
        props.put(prefix + ShowCoverageProperty, new Boolean(this.showCoverage).toString());
        this.coverageDrawingAttributes.setPropertyPrefix(prefix);
        this.coverageDrawingAttributes.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String interString = this.i18n.get(class$com$bbn$openmap$layer$asrp$ASRPLayer == null ? (class$com$bbn$openmap$layer$asrp$ASRPLayer = ASRPLayer.class$("com.bbn.openmap.layer.asrp.ASRPLayer")) : class$com$bbn$openmap$layer$asrp$ASRPLayer, THFProperty, 3, "Paths to TRANSH01.THF files, takes precedence over ASRP property.  Separated by ;");
        props.put(THFProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$asrp$ASRPLayer == null ? (class$com$bbn$openmap$layer$asrp$ASRPLayer = ASRPLayer.class$("com.bbn.openmap.layer.asrp.ASRPLayer")) : class$com$bbn$openmap$layer$asrp$ASRPLayer, THFProperty, "TRANSH01.THF files");
        props.put("thf.label", interString);
        props.put("thf.editor", "com.bbn.openmap.util.propertyEditor.MultiDirFilePropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$asrp$ASRPLayer == null ? (class$com$bbn$openmap$layer$asrp$ASRPLayer = ASRPLayer.class$("com.bbn.openmap.layer.asrp.ASRPLayer")) : class$com$bbn$openmap$layer$asrp$ASRPLayer, ASRPDirectoryProperty, 3, "Paths to ASRP Directories (if no TRANSH01.THF files)");
        props.put(ASRPDirectoryProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$asrp$ASRPLayer == null ? (class$com$bbn$openmap$layer$asrp$ASRPLayer = ASRPLayer.class$("com.bbn.openmap.layer.asrp.ASRPLayer")) : class$com$bbn$openmap$layer$asrp$ASRPLayer, ASRPDirectoryProperty, "ASRP directories");
        props.put("asrpDirs.label", interString);
        props.put("asrpDirs.editor", "com.bbn.openmap.util.propertyEditor.MultiDirectoryPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$asrp$ASRPLayer == null ? (class$com$bbn$openmap$layer$asrp$ASRPLayer = ASRPLayer.class$("com.bbn.openmap.layer.asrp.ASRPLayer")) : class$com$bbn$openmap$layer$asrp$ASRPLayer, ShowCoverageProperty, 3, "Show coverage areas when images can't be displayed.");
        props.put(ShowCoverageProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$asrp$ASRPLayer == null ? (class$com$bbn$openmap$layer$asrp$ASRPLayer = ASRPLayer.class$("com.bbn.openmap.layer.asrp.ASRPLayer")) : class$com$bbn$openmap$layer$asrp$ASRPLayer, ShowCoverageProperty, "Show Coverage Areas");
        props.put("showCoverage.label", interString);
        props.put("showCoverage.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        this.coverageDrawingAttributes.getPropertyInfo(props);
        props.put("initProperties", "thf asrpDirs showCoverage " + this.coverageDrawingAttributes.getInitPropertiesOrder());
        return props;
    }

    public DataBounds getDataBounds() {
        DataBounds box = null;
        if (this.asrpHandler != null) {
            box = this.asrpHandler.getDataBounds();
        }
        return box;
    }

    public void setShowCoverage(boolean showCoverageIn) {
        this.showCoverage = showCoverageIn;
    }

    public boolean getShowCoverage() {
        return this.showCoverage;
    }

    public Component getGUI() {
        if (this.guiPanel == null) {
            JPanel gp = new JPanel();
            gp.setLayout(new GridLayout(0, 1));
            String interString = this.i18n.get(class$com$bbn$openmap$layer$asrp$ASRPLayer == null ? (class$com$bbn$openmap$layer$asrp$ASRPLayer = ASRPLayer.class$("com.bbn.openmap.layer.asrp.ASRPLayer")) : class$com$bbn$openmap$layer$asrp$ASRPLayer, "showCoverageCheck", "Show Coverage");
            JCheckBox coverageCheck = new JCheckBox(interString, this.getShowCoverage());
            interString = this.i18n.get(class$com$bbn$openmap$layer$asrp$ASRPLayer == null ? (class$com$bbn$openmap$layer$asrp$ASRPLayer = ASRPLayer.class$("com.bbn.openmap.layer.asrp.ASRPLayer")) : class$com$bbn$openmap$layer$asrp$ASRPLayer, "showCoverageCheck", 3, "Show coverage areas when images can't be displayed.");
            coverageCheck.setToolTipText(interString);
            coverageCheck.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JCheckBox jcb = (JCheckBox)ae.getSource();
                    ASRPLayer.this.setShowCoverage(jcb.isSelected());
                    ASRPLayer.this.doPrepare();
                }
            });
            this.coverageDrawingAttributes.getPropertyChangeSupport().addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent pce) {
                    ASRPLayer.this.doPrepare();
                }
            });
            interString = this.i18n.get(class$com$bbn$openmap$layer$asrp$ASRPLayer == null ? (class$com$bbn$openmap$layer$asrp$ASRPLayer = ASRPLayer.class$("com.bbn.openmap.layer.asrp.ASRPLayer")) : class$com$bbn$openmap$layer$asrp$ASRPLayer, "coveragePanelTitle", "Coverage Controls");
            JPanel covPanel = PaletteHelper.createVerticalPanel(interString);
            covPanel.add(coverageCheck);
            covPanel.add(this.coverageDrawingAttributes.getGUI());
            gp.add(covPanel);
            this.guiPanel = gp;
        }
        return this.guiPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

