/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.gui.AbstractOpenMapMenu;
import com.bbn.openmap.gui.menu.SaveAsGifMenuItem;
import com.bbn.openmap.gui.menu.SaveAsImageMenuItem;
import com.bbn.openmap.gui.menu.SaveAsJpegMenuItem;
import com.bbn.openmap.gui.menu.SaveAsVirtualImageMenuItem;
import com.bbn.openmap.image.AbstractImageFormatter;
import com.bbn.openmap.image.SunJPEGFormatter;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SaveAsMenu
extends AbstractOpenMapMenu {
    public SaveAsMenu() {
        this("Save Map As");
    }

    public SaveAsMenu(String title) {
        super(title);
        this.add(new SaveAsJpegMenuItem());
        this.add(new SaveAsGifMenuItem());
        this.addSVGMenuItem(this);
    }

    public JMenuItem createSaveAsVirtualJpegMenuItem() {
        SunJPEGFormatter formatter = new SunJPEGFormatter();
        formatter.setImageQuality(1.0f);
        SaveAsVirtualImageMenuItem virtualJpegMenuItem = new SaveAsVirtualImageMenuItem("Custom JPEG...", formatter);
        if (this.getMapHandler() != null) {
            virtualJpegMenuItem.setMapHandler(this.getMapHandler());
        }
        return virtualJpegMenuItem;
    }

    public void addSVGMenuItem(JMenu menu) {
        try {
            Object obj = ComponentFactory.create("com.bbn.openmap.image.SVGFormatter");
            if (obj != null) {
                Object batikTest = Class.forName("org.apache.batik.swing.JSVGCanvas").newInstance();
                menu.add(new SaveAsImageMenuItem("SVG", (AbstractImageFormatter)obj));
                return;
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (InstantiationException ie) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (NoClassDefFoundError ncdfe) {
            // empty catch block
        }
        if (Debug.debugging("basic")) {
            Debug.output("SVG not added to the Save As options, because Batik was not found in classpath.");
        }
    }
}

