/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader.scenario;

import com.bbn.openmap.graphicLoader.scenario.ScenarioGraphic;
import com.bbn.openmap.graphicLoader.scenario.TimeStamp;
import com.bbn.openmap.layer.location.URLRasterLocation;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ScenarioPoint
extends URLRasterLocation
implements ScenarioGraphic {
    List timeStamps;
    OMGraphicList renderList;
    protected int radius = 5;
    protected int pathStep = 100;
    protected boolean DEBUG = Debug.debugging("scenariopoint");

    public ScenarioPoint(String name, String iconURL) {
        super(90.0f, -180.0f, name.intern(), iconURL);
        this.init();
    }

    public ScenarioPoint(String name, URL iconURL) {
        super(90.0f, -180.0f, name.intern(), iconURL);
        this.init();
    }

    protected void init() {
        this.timeStamps = new LinkedList();
        this.showName = false;
        this.renderList = new OMGraphicList();
    }

    public boolean thisIsYou(String n) {
        return this.name == n.intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeStamp(TimeStamp timeStamp) {
        List list = this.timeStamps;
        synchronized (list) {
            int count = 0;
            Iterator it = this.timeStamps.iterator();
            while (it.hasNext()) {
                TimeStamp ts = (TimeStamp)it.next();
                if (timeStamp.time < ts.time) break;
                ++count;
            }
            this.timeStamps.add(count, timeStamp);
            if (this.DEBUG) {
                Debug.output("ScenarioPoint (" + this.getName() + ") adding " + timeStamp);
            }
        }
        this.setNeedToRegenerate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTimeStamp(TimeStamp timeStamp) {
        boolean result = false;
        List list = this.timeStamps;
        synchronized (list) {
            result = this.timeStamps.remove(timeStamp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimeStamps() {
        List list = this.timeStamps;
        synchronized (list) {
            this.timeStamps.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setPosition(long time) {
        TimeStamp previous = null;
        TimeStamp next = null;
        boolean POSITION_DEBUG = this.DEBUG;
        List list = this.timeStamps;
        // MONITORENTER : list
        Iterator it = this.timeStamps.iterator();
        while (it.hasNext()) {
            TimeStamp ts = (TimeStamp)it.next();
            if (ts.time < time) {
                previous = ts;
                continue;
            }
            if (ts.time > time) {
                next = ts;
                break;
            }
            if (POSITION_DEBUG) {
                Debug.output("ScenarioPoint (" + this.getName() + ").setPosition(): " + ts.latitude + ", " + ts.longitude + " at time " + time);
            }
            this.setLocation(ts.latitude, ts.longitude);
            this.setVisible(true);
            // MONITOREXIT : list
            return;
        }
        // MONITOREXIT : list
        if (previous == null) {
            this.setVisible(false);
            if (next == null) {
                if (!POSITION_DEBUG) return;
                Debug.output("ScenarioPoint (" + this.getName() + ").setPosition(): no TimeStamps ");
                return;
            }
            if (POSITION_DEBUG) {
                Debug.output("ScenarioPoint (" + this.getName() + ").setPosition(): premature time, invisible at " + next.latitude + ", " + next.longitude);
            }
            this.setLocation(next.latitude, next.longitude);
            return;
        }
        if (next == null) {
            this.setVisible(false);
            if (POSITION_DEBUG) {
                Debug.output("ScenarioPoint (" + this.getName() + ").setPosition(): expired time, invisible at " + previous.latitude + ", " + previous.longitude);
            }
            this.setLocation(previous.latitude, previous.longitude);
            return;
        }
        float[] points = GreatCircle.great_circle(ProjMath.degToRad(previous.latitude), ProjMath.degToRad(previous.longitude), ProjMath.degToRad(next.latitude), ProjMath.degToRad(next.longitude), this.pathStep, true);
        float numSegsCovered = (float)this.pathStep * (float)(time - previous.time) / (float)(next.time - previous.time);
        int index = Math.round(numSegsCovered) * 2;
        float la = ProjMath.radToDeg(points[index]);
        float lo = ProjMath.radToDeg(points[index + 1]);
        if (POSITION_DEBUG) {
            Debug.output("ScenarioPoint (" + this.getName() + ").setPosition(): good time, " + 100.0f * numSegsCovered / (float)this.pathStep + "% to the next location, visible at " + la + ", " + lo);
        }
        this.setLocation(la, lo);
        points = null;
        this.setVisible(true);
    }

    public void generateSnapshot(Projection p, long time) {
        this.renderList.clear();
        if (this.DEBUG) {
            Debug.output("ScenarioPoint (" + this.getName() + ") calculating snapshot location.");
        }
        this.setPosition(time);
        if (this.location.isVisible() && this.isShowLocation()) {
            if (this.DEBUG) {
                Debug.output("ScenarioPoint (" + this.getName() + ") adding location (" + this.location.getClass().getName() + ")");
            }
            this.renderList.add(this.location);
        }
        if (this.label.isVisible() && this.isShowName()) {
            if (this.DEBUG) {
                Debug.output("ScenarioPoint (" + this.getName() + ") adding label (" + this.label.getData() + ")");
            }
            this.renderList.add(this.label);
        }
        super.generate(p);
        this.setNeedToRegenerate(false);
    }

    public void setGraphicLocations(float latitude, float longitude) {
        if (this.location instanceof OMPoint) {
            OMPoint point = (OMPoint)this.location;
            point.set(latitude, longitude);
            point.setOval(true);
            point.setRadius(this.radius);
            point.setFillPaint(this.getFillPaint());
            point.setLinePaint(this.getLinePaint());
            this.label.setLat(latitude);
            this.label.setLon(longitude);
            this.setHorizontalLabelBuffer(((OMPoint)this.location).getRadius() + this.SPACING);
        } else {
            super.setGraphicLocations(latitude, longitude);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTotalScenario(Projection p) {
        this.renderList.clear();
        OMGraphicList icons = new OMGraphicList();
        Image image = null;
        if (this.location instanceof OMRaster) {
            image = ((OMRaster)this.location).getImage();
        }
        float lastLat = 0.0f;
        float lastLon = 0.0f;
        boolean firstLine = true;
        List list = this.timeStamps;
        synchronized (list) {
            Iterator it = this.timeStamps.iterator();
            while (it.hasNext()) {
                TimeStamp ts = (TimeStamp)it.next();
                if (image != null) {
                    if (this.DEBUG) {
                        Debug.output("ScenarioPoint (" + this.getName() + ") represented by image");
                    }
                    OMRaster icon = new OMRaster(ts.latitude, ts.longitude, -((OMRaster)this.location).getWidth() / 2, -((OMRaster)this.location).getHeight() / 2, image);
                    icon.generate(p);
                    icons.add(icon);
                } else {
                    if (this.DEBUG) {
                        Debug.output("ScenarioPoint (" + this.getName() + ") represented by OMPoint");
                    }
                    OMPoint point = new OMPoint(ts.latitude, ts.longitude, this.radius);
                    point.setOval(true);
                    point.setFillPaint(this.getFillPaint());
                    point.setLinePaint(this.getLinePaint());
                    point.generate(p);
                    icons.add(point);
                }
                if (firstLine) {
                    lastLat = ts.latitude;
                    lastLon = ts.longitude;
                    firstLine = false;
                    continue;
                }
                float currentLat = ts.latitude;
                float currentLon = ts.longitude;
                OMLine path = new OMLine(lastLat, lastLon, currentLat, currentLon, 3);
                path.addArrowHead(0, 95, 2, 8);
                path.setLinePaint(this.getSelectPaint());
                path.generate(p);
                this.renderList.add(path);
                lastLat = currentLat;
                lastLon = currentLon;
            }
        }
        this.renderList.add(icons);
        this.setVisible(true);
        this.setNeedToRegenerate(false);
    }

    public boolean generate(Projection p) {
        super.generate(p);
        return this.renderList.generate(p);
    }

    public void render(Graphics g) {
        if (this.DEBUG) {
            Debug.output("ScenarioPoint (" + this.getName() + ") " + (this.isVisible() ? "is " : "is not ") + "visible, " + (this.getNeedToRegenerate() ? "needs regeneration." : "all set"));
        }
        if (this.isVisible() && !this.getNeedToRegenerate()) {
            this.renderList.render(g);
        }
    }
}

