/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape.input;

import com.bbn.openmap.dataAccess.shape.input.LittleEndianInputStream;
import com.bbn.openmap.util.Debug;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;

public class DbfInputStream {
    private LittleEndianInputStream _leis = null;
    private String[] _columnNames = null;
    private int[] _lengths = null;
    private byte[] _decimalCounts = null;
    private byte[] _types = null;
    private int _columnCount = -1;
    private int _rowCount = -1;
    private short _headerLength = (short)-1;
    private short _recordLength = (short)-1;
    private ArrayList _records = null;

    public DbfInputStream(InputStream is) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(is);
        this._leis = new LittleEndianInputStream(bis);
        this.readHeader();
        this.readFieldDescripters();
        this.readData();
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public int[] getLengths() {
        return this._lengths;
    }

    public byte[] getDecimalCounts() {
        return this._decimalCounts;
    }

    public byte[] getTypes() {
        return this._types;
    }

    public ArrayList getRecords() {
        return this._records;
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    private void readHeader() throws IOException {
        byte description = this._leis.readByte();
        byte year = this._leis.readByte();
        byte month = this._leis.readByte();
        byte day = this._leis.readByte();
        this._rowCount = this._leis.readLEInt();
        this._headerLength = this._leis.readLEShort();
        this._recordLength = this._leis.readLEShort();
        this._columnCount = (this._headerLength - 32 - 1) / 32;
        this._leis.skipBytes(20);
    }

    private void readFieldDescripters() throws IOException {
        this._columnNames = new String[this._columnCount];
        this._types = new byte[this._columnCount];
        this._lengths = new int[this._columnCount];
        this._decimalCounts = new byte[this._columnCount];
        int n = 0;
        while (n <= this._columnCount - 1) {
            this._columnNames[n] = this._leis.readString(11);
            this._types[n] = this._leis.readByte();
            this._leis.skipBytes(4);
            this._lengths[n] = this._leis.readUnsignedByte();
            this._decimalCounts[n] = this._leis.readByte();
            this._leis.skipBytes(14);
            ++n;
        }
    }

    public void readData() throws IOException {
        DecimalFormat df = new DecimalFormat();
        this._leis.skipBytes(2);
        this._records = new ArrayList();
        int r = 0;
        while (r <= this._rowCount - 1) {
            ArrayList<Object> record = new ArrayList<Object>();
            int c = 0;
            while (c <= this._columnCount - 1) {
                int length = this._lengths[c];
                if (length == -1) {
                    length = 255;
                }
                byte type = this._types[c];
                String cell = this._leis.readString(length);
                if (type == 78 && !cell.equals("")) {
                    try {
                        record.add(c, new Double(df.parse(cell).doubleValue()));
                    }
                    catch (ParseException pe) {
                        Debug.error("DbfInputStream:  error parsing column " + c + ", row " + r + ", expected number and got " + cell);
                        record.add(c, new Double(0.0));
                    }
                } else {
                    record.add(c, cell);
                }
                ++c;
            }
            this._records.add(record);
            this._leis.skipBytes(1);
            ++r;
        }
    }
}

