/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.BufferedMapBean;
import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapBeanRepaintPolicy;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.layer.BufferedLayer;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ContainerEvent;

public class BufferedLayerMapBean
extends BufferedMapBean {
    protected BufferedLayer bufferedLayer;
    protected boolean DEBUG = Debug.debugging("mapbean");

    public void setBackgroundColor(Color color) {
        super.setBackground(color);
        this.getBufferedLayer().setBackground(color);
    }

    public void setBckgrnd(Paint paint) {
        super.setBckgrnd(paint);
        this.getBufferedLayer().setBckgrnd(paint);
    }

    public synchronized void setBufferedLayer(BufferedLayer bl) {
        this.bufferedLayer = bl;
    }

    public synchronized BufferedLayer getBufferedLayer() {
        if (this.bufferedLayer == null) {
            this.bufferedLayer = new BufferedLayer();
            this.addPropertyChangeListener(this.bufferedLayer);
            this.bufferedLayer.setName("Background Layers");
        }
        return this.bufferedLayer;
    }

    public void setMapBeanRepaintPolicy(MapBeanRepaintPolicy mbrp) {
        super.setMapBeanRepaintPolicy(mbrp);
        MapBeanRepaintPolicy mbrp2 = (MapBeanRepaintPolicy)mbrp.clone();
        MapBean mb = this.getBufferedLayer().getMapBean();
        if (mb != null) {
            mb.setMapBeanRepaintPolicy(mbrp2);
            mbrp2.setMap(mb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayers(LayerEvent evt) {
        BufferedLayer bufLayer;
        this.bufferDirty = true;
        Layer[] layers = evt.getLayers();
        int type = evt.getType();
        if (type == 403) {
            return;
        }
        if (layers == null) {
            System.err.println("MapBean.setLayers(): layers is null!");
            return;
        }
        boolean oldChange = this.getDoContainerChange();
        this.setDoContainerChange(false);
        BufferedLayerMapBean bufferedLayerMapBean = this;
        synchronized (bufferedLayerMapBean) {
            bufLayer = this.getBufferedLayer();
        }
        if (type == 402) {
            if (this.DEBUG) {
                this.debugmsg("Replacing all layers");
            }
            this.removeAll();
            bufLayer.clearLayers();
            int i = 0;
            while (i < layers.length) {
                if (layers[i] == null) {
                    System.err.println("MapBean.setLayers(): layer " + i + " is null");
                } else {
                    if (this.DEBUG) {
                        this.debugmsg("Adding layer[" + i + "]= " + layers[i].getName());
                    }
                    if (layers[i].getAddAsBackground()) {
                        if (this.DEBUG) {
                            Debug.output("Adding layer[" + i + "]= " + layers[i].getName() + " to background");
                        }
                        bufLayer.addLayer(layers[i]);
                    } else {
                        this.add(layers[i]);
                    }
                    layers[i].setVisible(true);
                }
                ++i;
            }
            if (bufLayer.hasLayers()) {
                this.add(bufLayer);
            }
        } else if (type == 400) {
            this.remove(bufLayer);
            if (this.DEBUG) {
                this.debugmsg("Adding new layers");
            }
            int i = 0;
            while (i < layers.length) {
                if (this.DEBUG) {
                    this.debugmsg("Adding layer[" + i + "]= " + layers[i].getName());
                }
                layers[i].setVisible(true);
                if (layers[i].getAddAsBackground()) {
                    if (this.DEBUG) {
                        Debug.output("Adding layer[" + i + "]= " + layers[i].getName() + " to background");
                    }
                    bufLayer.addLayer(layers[i]);
                } else {
                    this.add(layers[i]);
                }
                ++i;
            }
            if (bufLayer.hasLayers()) {
                this.add(bufLayer);
            }
        } else if (type == 401) {
            if (this.DEBUG) {
                this.debugmsg("Removing layers");
            }
            int i = 0;
            while (i < layers.length) {
                if (this.DEBUG) {
                    this.debugmsg("Removing layer[" + i + "]= " + layers[i].getName());
                }
                this.remove(layers[i]);
                bufLayer.removeLayer(layers[i]);
                ++i;
            }
        }
        if (!this.layerRemovalDelayed) {
            this.purgeAndNotifyRemovedLayers();
        }
        this.setDoContainerChange(oldChange);
        this.repaint();
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeLayers(ContainerEvent e) {
        BufferedLayer bufLayer;
        if (!this.doContainerChange) {
            return;
        }
        Component[] comps = this.getComponents();
        int ncomponents = comps.length;
        int nBufLayerComponents = 0;
        BufferedLayerMapBean bufferedLayerMapBean = this;
        synchronized (bufferedLayerMapBean) {
            bufLayer = this.getBufferedLayer();
        }
        if (ncomponents == 0 || comps[ncomponents - 1] != bufLayer) {
            super.changeLayers(e);
            return;
        }
        Component[] bufLayers = bufLayer.getLayers();
        nBufLayerComponents = bufLayers.length;
        Layer[] newLayers = new Layer[ncomponents + nBufLayerComponents - 1];
        System.arraycopy(comps, 0, newLayers, 0, ncomponents - 1);
        System.arraycopy(bufLayers, 0, newLayers, ncomponents - 1, nBufLayerComponents);
        if (this.DEBUG) {
            this.debugmsg("changeLayers() - firing change");
        }
        this.firePropertyChange("MapBean.layers", this.currentLayers, newLayers);
        int i = 0;
        while (i < this.addedLayers.size()) {
            ((Layer)this.addedLayers.elementAt(i)).added(this);
            ++i;
        }
        this.addedLayers.removeAllElements();
        this.currentLayers = newLayers;
    }
}

