/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.IfNetwork;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkAttrHelper;
import edu.iris.Fissures.IfNetwork.StationHelper;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfNetwork.StationIdHelper;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationHelper;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.TimeRangeHelper;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.StreamableValue;

public abstract class Station
implements StreamableValue {
    protected StationId id;
    protected String name;
    private Location my_location;
    private TimeRange effective_time;
    protected String operator;
    protected String description;
    protected String comment;
    private NetworkAttr my_network;
    private static String[] _OB_truncatableIds_ = new String[]{StationHelper.id()};
    private static Map<String, WeakReference<Station>> knownStations = Collections.synchronizedMap(new HashMap());

    public abstract StationId get_id();

    public abstract String get_code();

    public String[] _truncatable_ids() {
        return _OB_truncatableIds_;
    }

    public void _read(InputStream in) {
        this.id = StationIdHelper.read(in);
        this.name = in.read_string();
        this.setLocation(LocationHelper.read(in));
        this.setEffectiveTime(TimeRangeHelper.read(in));
        this.operator = in.read_string();
        this.description = in.read_string();
        this.comment = in.read_string();
        this.setNetworkAttr(NetworkAttrHelper.read(in));
    }

    public void _write(OutputStream out) {
        StationIdHelper.write(out, this.id);
        out.write_string(this.name);
        LocationHelper.write(out, this.getLocation());
        TimeRangeHelper.write(out, this.getEffectiveTime());
        out.write_string(this.operator);
        out.write_string(this.description);
        out.write_string(this.comment);
        NetworkAttrHelper.write(out, this.getNetworkAttr());
    }

    public TypeCode _type() {
        return StationHelper.type();
    }

    public String getName() {
        return this.name;
    }

    public Location getLocation() {
        return this.my_location;
    }

    public TimeRange getEffectiveTime() {
        return this.effective_time;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getDescription() {
        return this.description;
    }

    public String getComment() {
        return this.comment;
    }

    public NetworkAttr getNetworkAttr() {
        return this.my_network;
    }

    public StationId getId() {
        if (this.id != null && this.id.network_id == null && this.getNetworkAttr() != null) {
            this.id.network_id = this.getNetworkAttr().getId();
        }
        return this.id;
    }

    public static void intern(StationId id) {
        id.network_id = NetworkAttr.intern(id.network_id);
        id.station_code = NetworkAttr.intern(id.station_code);
        id.begin_time = NetworkAttr.intern(id.begin_time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Station intern(Station station) {
        Map<String, WeakReference<Station>> map = knownStations;
        synchronized (map) {
            String key = station.getNetworkAttr().getId().network_code + station.getNetworkAttr().getId().begin_time.date_time + ":" + station.getId().station_code + station.getId().begin_time.date_time;
            Station interned = null;
            if (knownStations.containsKey(key)) {
                interned = (Station)knownStations.get(key).get();
            }
            if (interned == null) {
                knownStations.put(key, new WeakReference<Station>(station));
                Station.intern(station.getId());
                station.setNetworkAttr(NetworkAttr.intern(station.getNetworkAttr()));
                station.getId().network_id = station.getNetworkAttr().getId();
                station.setName(NetworkAttr.intern(station.getName()));
                station.setDescription(NetworkAttr.intern(station.getDescription()));
                station.setOperator(NetworkAttr.intern(station.getOperator()));
                station.setComment(NetworkAttr.intern(station.getComment()));
                station.setEffectiveTime(NetworkAttr.intern(station.getEffectiveTime()));
                return station;
            }
            return interned;
        }
    }

    protected void setId(StationId id) {
        this.id = id;
        if (id.network_id != null) {
            if (this.getNetworkAttr() != null) {
                this.getNetworkAttr().setId(id.network_id);
            }
        } else if (this.getNetworkAttr() != null) {
            id.network_id = this.getNetworkAttr().get_id();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLocation(Location loc) {
        this.my_location = loc;
    }

    protected void setEffectiveTime(TimeRange eff) {
        this.effective_time = eff;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setNetworkAttr(NetworkAttr attr) {
        this.my_network = attr;
        if (this.my_network != null && this.id != null && this.my_network.get_id() != null) {
            this.id.network_id = this.my_network.get_id();
        }
    }

    public Time getBeginTime() {
        return this.get_id().begin_time;
    }

    public void setBeginTime(Time beginTime) {
        if (this.getEffectiveTime() == null) {
            this.setEffectiveTime(new TimeRange());
        }
        this.getEffectiveTime().start_time = beginTime;
        this.get_id().begin_time = beginTime;
    }

    public Time getEndTime() {
        return this.getEffectiveTime().end_time;
    }

    public void setEndTime(Time endTime) {
        if (this.getEffectiveTime() == null) {
            this.setEffectiveTime(new TimeRange());
            this.getEffectiveTime().start_time = this.get_id().begin_time;
        }
        this.getEffectiveTime().end_time = endTime;
    }
}

