/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import com.isti.util.propertyeditor.AbstractPropertyEditor;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BooleanPropertyEditor
extends AbstractPropertyEditor {
    public static int TRUE_FALSE_BUTTONS = 0;
    public static int CHECK_BOX = 1;
    public static int RADIO_BUTTON = 2;
    public static int defaultInterfaceType = CHECK_BOX;
    public static int defaultAlignment = 2;
    private final int interfaceType;
    private static final String TrueString = Boolean.TRUE.toString();
    private static final String FalseString = Boolean.FALSE.toString();
    private final AbstractButton actionButton;
    private final AbstractButton trueButton;
    private final AbstractButton falseButton;
    private final Component customEditor;

    public BooleanPropertyEditor() {
        this(defaultInterfaceType);
    }

    public BooleanPropertyEditor(int interfaceType) {
        this.interfaceType = interfaceType;
        if (interfaceType == TRUE_FALSE_BUTTONS) {
            JPanel buttonPanel = new JPanel();
            ButtonGroup buttonGroup = new ButtonGroup();
            this.trueButton = new JRadioButton(TrueString);
            this.falseButton = new JRadioButton(FalseString);
            this.trueButton.setActionCommand(TrueString);
            this.falseButton.setActionCommand(FalseString);
            buttonGroup.add(this.trueButton);
            buttonGroup.add(this.falseButton);
            buttonPanel.add(this.trueButton);
            buttonPanel.add(this.falseButton);
            this.actionButton = this.trueButton;
            this.customEditor = buttonPanel;
        } else if (interfaceType == RADIO_BUTTON) {
            JRadioButton radioButton = new JRadioButton();
            this.falseButton = this.actionButton = radioButton;
            this.trueButton = this.actionButton;
            this.customEditor = this.actionButton;
        } else {
            JCheckBox checkBoxButton = new JCheckBox();
            this.falseButton = this.actionButton = checkBoxButton;
            this.trueButton = this.actionButton;
            this.customEditor = this.actionButton;
        }
        this.setHorizontalAlignment(defaultAlignment);
        this.setSelected(true);
    }

    public int getHorizontalAlignment() {
        return this.actionButton.getHorizontalAlignment();
    }

    public int getInterfaceType() {
        return this.interfaceType;
    }

    protected boolean isEnabled() {
        return this.actionButton.isEnabled();
    }

    protected boolean isSelected() {
        return this.actionButton.isSelected();
    }

    protected void setEnabled(boolean b) {
        this.trueButton.setEnabled(b);
        if (this.falseButton != this.trueButton) {
            this.falseButton.setEnabled(b);
        }
    }

    protected void setHorizontalAlignment(int alignment) {
        this.trueButton.setHorizontalAlignment(alignment);
        if (this.falseButton != this.trueButton) {
            this.falseButton.setHorizontalAlignment(alignment);
        }
    }

    protected void setSelected(boolean b) {
        this.trueButton.setSelected(b);
        if (this.falseButton != this.trueButton) {
            this.falseButton.setSelected(!b);
        }
    }

    protected void setSelected(boolean b, boolean doClick) {
        if (doClick) {
            if (this.isSelected() != b) {
                if (b) {
                    this.trueButton.doClick();
                } else {
                    this.falseButton.doClick();
                }
            }
        } else {
            this.setSelected(b);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this.customEditor;
    }

    public void setValue(Object someObj) {
        if (someObj == null) {
            return;
        }
        boolean b = new Boolean(someObj.toString());
        this.setSelected(b, true);
    }

    public void setAsText(String text) {
        if (text == null) {
            return;
        }
        this.setValue(text);
    }

    public Object getValue() {
        return new Boolean(this.isSelected());
    }

    public String getAsText() {
        return this.getValue().toString();
    }

    public void addActionListener(ActionListener l) {
        this.actionButton.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionButton.removeActionListener(l);
    }
}

