/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.BasicColumnFilter;
import com.isti.util.BasicRowFilter;
import com.isti.util.IstiColumnFilter;
import com.isti.util.IstiRowFilter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class IstiTableModel
implements IstiColumnFilter,
IstiRowFilter,
TableModel,
TableModelListener {
    private final AbstractTableModel abstractTableModel;
    private final TableModel tableModel;
    private int[] columnIndexValues = null;
    private int visibleColumnCount;
    private int[] rowIndexValues = null;
    private int visibleRowCount;
    private IstiColumnFilter columnFilter = null;
    private IstiRowFilter rowFilter = null;

    public IstiTableModel(AbstractTableModel tableModel) {
        this.abstractTableModel = tableModel;
        this.tableModel = tableModel;
        tableModel.addTableModelListener(this);
    }

    public void addTableModelListener(TableModelListener listener) {
        this.tableModel.addTableModelListener(listener);
    }

    public void fireTableStructureChanged() {
        if (this.abstractTableModel != null) {
            this.abstractTableModel.fireTableStructureChanged();
        } else {
            this.tableChanged(new TableModelEvent(this, -1));
        }
    }

    public int getActualColumnIndex(int columnIndex) {
        if (this.columnFilter == null) {
            return columnIndex;
        }
        if (this.columnIndexValues == null) {
            this.updateColumnInfo();
        }
        if (this.columnIndexValues == null) {
            return columnIndex;
        }
        return this.columnIndexValues[columnIndex];
    }

    public int getActualRowIndex(int rowIndex) {
        if (this.rowFilter == null) {
            return rowIndex;
        }
        if (this.rowIndexValues == null) {
            this.updateRowInfo();
        }
        if (this.rowIndexValues == null) {
            return rowIndex;
        }
        return this.rowIndexValues[rowIndex];
    }

    public Class getColumnClass(int columnIndex) {
        columnIndex = this.getActualColumnIndex(columnIndex);
        return this.tableModel.getColumnClass(columnIndex);
    }

    public int getColumnCount() {
        if (this.columnFilter == null) {
            return this.tableModel.getColumnCount();
        }
        if (this.columnIndexValues == null) {
            this.updateColumnInfo();
        }
        return this.visibleColumnCount;
    }

    public IstiColumnFilter getColumnFilter() {
        return this.columnFilter;
    }

    public String getColumnName(int columnIndex) {
        columnIndex = this.getActualColumnIndex(columnIndex);
        return this.tableModel.getColumnName(columnIndex);
    }

    public int getRowCount() {
        if (this.rowFilter == null) {
            return this.tableModel.getRowCount();
        }
        if (this.rowIndexValues == null) {
            this.updateRowInfo();
        }
        return this.visibleRowCount;
    }

    public IstiRowFilter getRowFilter() {
        return this.rowFilter;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        rowIndex = this.getActualRowIndex(rowIndex);
        columnIndex = this.getActualColumnIndex(columnIndex);
        return this.tableModel.getValueAt(rowIndex, columnIndex);
    }

    protected void initColumnInfo() {
        this.columnFilter = new BasicColumnFilter(this.tableModel.getColumnCount());
    }

    protected void initRowInfo() {
        this.rowFilter = new BasicRowFilter(this.tableModel.getRowCount());
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        rowIndex = this.getActualRowIndex(rowIndex);
        columnIndex = this.getActualColumnIndex(columnIndex);
        return this.tableModel.isCellEditable(rowIndex, columnIndex);
    }

    public boolean isColumnVisible(int columnIndex) {
        if (this.columnFilter == null) {
            return true;
        }
        return this.columnFilter.isColumnVisible(columnIndex);
    }

    public boolean isRowVisible(int rowIndex) {
        if (this.rowFilter == null) {
            return true;
        }
        return this.rowFilter.isRowVisible(rowIndex);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.tableModel.removeTableModelListener(listener);
    }

    public void setColumnFilter(IstiColumnFilter columnFilter) {
        this.columnFilter = columnFilter;
        this.fireTableStructureChanged();
    }

    public void setColumnVisible(int columnIndex, boolean b) {
        if (!(this.columnFilter instanceof BasicColumnFilter)) {
            this.initColumnInfo();
        }
        BasicColumnFilter basicColumnFilter = (BasicColumnFilter)this.columnFilter;
        basicColumnFilter.setColumnVisible(columnIndex, b);
        this.fireTableStructureChanged();
    }

    public void setRowFilter(IstiRowFilter rowFilter) {
        this.rowFilter = rowFilter;
        this.fireTableStructureChanged();
    }

    public void setRowVisible(int rowIndex, boolean b) {
        if (!(this.rowFilter instanceof BasicRowFilter)) {
            this.initRowInfo();
        }
        BasicRowFilter basicRowFilter = (BasicRowFilter)this.rowFilter;
        basicRowFilter.setRowVisible(rowIndex, b);
        this.fireTableStructureChanged();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        rowIndex = this.getActualRowIndex(rowIndex);
        columnIndex = this.getActualColumnIndex(columnIndex);
        this.tableModel.setValueAt(aValue, rowIndex, columnIndex);
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getFirstRow() == -1) {
            this.columnIndexValues = null;
            this.visibleColumnCount = 0;
        }
        this.rowIndexValues = null;
        this.visibleRowCount = 0;
    }

    protected void updateColumnInfo() {
        this.visibleColumnCount = 0;
        int columnCount = this.tableModel.getColumnCount();
        this.columnIndexValues = new int[columnCount];
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            if (!this.isColumnVisible(columnIndex)) continue;
            this.columnIndexValues[this.visibleColumnCount++] = columnIndex;
        }
    }

    protected void updateRowInfo() {
        this.visibleRowCount = 0;
        int rowCount = this.tableModel.getRowCount();
        this.rowIndexValues = new int[rowCount];
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            if (!this.isRowVisible(rowIndex)) continue;
            this.rowIndexValues[this.visibleRowCount++] = rowIndex;
        }
    }
}

