/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.UtilFns;
import com.isti.util.gui.IstiPopupMenu;
import com.isti.util.menu.IstiMenuPopper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.Timer;

public class IstiClockPanel
extends JPanel
implements ActionListener {
    public static final int SHOW_ALL_TIME_ZONES_COMMAND = 0;
    public static final int SHOW_SECONDS_COMMAND = 1;
    public static final int SHOW_24_HOUR_COMMAND = 2;
    public static final int SHOW_SECOND_TIME_ZONE_COMMAND = 3;
    public static final TimeZone DEFAULT_TIME_ZONE = null;
    public static final int DISPMODE_DEFAULT = 0;
    public static final int DISPMODE_ALWAYS_SHOW_DEFAULT_TIME_ZONE = 1;
    public static final int DISPMODE_SHOW_LOCAL_WHEN_DEFAULT = 2;
    private static final String[] defaultPopupCommands = new String[]{"Show All Time Zones", "Show Seconds", "Show 24 Hour", ""};
    private static final String[] popupCommands = new String[defaultPopupCommands.length];
    private boolean[] enableCommands = new boolean[defaultPopupCommands.length];
    private JToolBar toolBar = new JToolBar();
    private static final Dimension toolBarSeparatorDimension = new Dimension(10, 0);
    private static final int secondsDelayTime = 1000;
    private static final int minutesDelayTime = 60000;
    private static final TimeZone localTimeZone = TimeZone.getDefault();
    private int timerDelay = 60000;
    private TimeZone zone = DEFAULT_TIME_ZONE;
    private int displayMode = 0;
    private final TimeZone defaultTimeZone;
    private final JLabel firstClockLabel = new JLabel();
    private final JLabel secondClockLabel = new JLabel();
    private DateFormat firstDateFormatter;
    private DateFormat secondDateFormatter;
    private final IstiPopupMenu popupMenu = new IstiPopupMenu();
    private final IstiMenuPopper menuPopper;
    private Timer timer;

    public IstiClockPanel() {
        this(DEFAULT_TIME_ZONE);
    }

    public IstiClockPanel(TimeZone zone) {
        this(zone, 0);
    }

    public IstiClockPanel(TimeZone zone, int displayMode) {
        this(zone, displayMode, DEFAULT_TIME_ZONE);
    }

    public IstiClockPanel(TimeZone zone, int displayMode, TimeZone defaultZone) {
        this.defaultTimeZone = defaultZone != null ? defaultZone : localTimeZone;
        this.setLayout(new BorderLayout());
        this.menuPopper = IstiMenuPopper.createMenuPopper(this.popupMenu, this.toolBar);
        for (int i = 0; i < defaultPopupCommands.length; ++i) {
            this.enableCommands[i] = true;
        }
        this.init(zone, displayMode);
        this.add((Component)this.toolBar, "Center");
    }

    public synchronized void init(TimeZone zone, int displayMode) {
        boolean showLocalTimeZone;
        boolean showDefaultTimeZone = (displayMode & 1) != 0;
        boolean bl = showLocalTimeZone = (displayMode & 2) != 0;
        if (zone == null) {
            zone = this.defaultTimeZone;
        }
        this.zone = zone;
        this.displayMode = displayMode;
        for (int i = 0; i < defaultPopupCommands.length; ++i) {
            IstiClockPanel.popupCommands[i] = defaultPopupCommands[i];
        }
        this.firstDateFormatter = null;
        this.secondDateFormatter = null;
        this.toolBar.removeAll();
        this.toolBar.addSeparator(toolBarSeparatorDimension);
        TimeZone secondTimeZone = showDefaultTimeZone && !zone.hasSameRules(this.defaultTimeZone) ? this.defaultTimeZone : (showLocalTimeZone && !zone.hasSameRules(localTimeZone) ? localTimeZone : null);
        this.firstDateFormatter = DateFormat.getTimeInstance();
        this.firstDateFormatter.setTimeZone(zone);
        this.toolBar.add(this.firstClockLabel);
        this.toolBar.addSeparator(toolBarSeparatorDimension);
        if (secondTimeZone != null) {
            IstiClockPanel.popupCommands[3] = "Show " + secondTimeZone.getDisplayName(false, 0) + " Time";
            this.secondDateFormatter = DateFormat.getTimeInstance();
            this.secondDateFormatter.setTimeZone(secondTimeZone);
            this.toolBar.add(this.secondClockLabel);
            this.toolBar.addSeparator(toolBarSeparatorDimension);
        }
        for (int i = 0; i < popupCommands.length; ++i) {
            this.addMenuItem(i);
        }
        this.updateCommandState(1);
    }

    public void setTimeZone(TimeZone zone) {
        this.init(zone, this.displayMode);
        this.restart();
    }

    public boolean getCommandState(int command) {
        JCheckBoxMenuItem mi = this.getMenuItem(command);
        return mi != null && mi.isSelected();
    }

    public boolean disableCommand(int command) {
        return this.setCommandEnable(command, false);
    }

    public boolean setCommandEnable(int command, boolean b) {
        JCheckBoxMenuItem mi = this.getMenuItem(command);
        if (mi != null) {
            this.enableCommands[command] = b;
            this.setMenuItemEnable(mi, b);
            return true;
        }
        return false;
    }

    protected JCheckBoxMenuItem getMenuItem(int command) {
        JCheckBoxMenuItem mi = null;
        try {
            mi = (JCheckBoxMenuItem)this.popupMenu.getComponent(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mi;
    }

    protected void setMenuItemEnable(JCheckBoxMenuItem mi, boolean b) {
        mi.setEnabled(b && mi.getText() != null && mi.getText().length() > 0);
        mi.setVisible(mi.isEnabled());
    }

    public boolean isCommandEnabled(int command) {
        return this.enableCommands[command];
    }

    public boolean setCommandState(int command, boolean b) {
        JCheckBoxMenuItem mi = this.getMenuItem(command);
        if (mi != null) {
            mi.setSelected(b);
            return this.updateCommandState(command, b);
        }
        return false;
    }

    public void setPopupEnabled(boolean b) {
        this.menuPopper.setEnabled(b);
    }

    protected synchronized boolean updateCommandState(int command, boolean b) {
        switch (command) {
            case 1: {
                this.timerDelay = b ? 1000 : 60000;
            }
        }
        this.updateDateFormatString(false);
        this.updateDateFormatString(true);
        this.restart();
        return true;
    }

    protected boolean updateCommandState(int command) {
        return this.updateCommandState(command, this.getCommandState(command));
    }

    protected boolean updateCommandState(String actionCommand) {
        for (int i = 0; i < popupCommands.length; ++i) {
            if (!popupCommands[i].equals(actionCommand)) continue;
            return this.updateCommandState(i);
        }
        return false;
    }

    protected void updateDateFormatString(boolean firstTimeZone) {
        DateFormat df = firstTimeZone ? this.firstDateFormatter : this.secondDateFormatter;
        if (df == null) {
            return;
        }
        String dateFormatStr = "";
        if (firstTimeZone || this.getCommandState(3)) {
            dateFormatStr = this.getCommandState(2) ? "HH" : "hh";
            dateFormatStr = dateFormatStr + ":mm";
            if (this.getCommandState(1)) {
                dateFormatStr = dateFormatStr + ":ss";
            }
            if (!this.getCommandState(2)) {
                dateFormatStr = dateFormatStr + " a";
            }
            if (this.getCommandState(0) || !df.getTimeZone().hasSameRules(localTimeZone)) {
                dateFormatStr = dateFormatStr + " z";
            }
        }
        UtilFns.setDateFormatPattern(df, dateFormatStr);
    }

    protected void addMenuItem(int command) {
        JCheckBoxMenuItem mi = this.getMenuItem(command);
        if (mi == null) {
            mi = new JCheckBoxMenuItem();
            mi.addActionListener(this);
            mi.setState(true);
            this.popupMenu.add(mi);
        }
        String text = popupCommands[command];
        mi.setActionCommand(text);
        mi.setText(text);
        this.setMenuItemEnable(mi, this.isCommandEnabled(command));
    }

    public void start() {
        if (this.timer == null) {
            this.timer = new Timer(this.timerDelay, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IstiClockPanel.this.updateTime();
                }
            });
        } else {
            this.timer.setDelay(this.timerDelay);
        }
        Calendar cal = this.updateTime();
        int currentMillisecond = cal.get(13) * 1000 + cal.get(14);
        int initialDelay = this.timerDelay - currentMillisecond;
        this.timer.setInitialDelay(initialDelay >= 0 ? initialDelay : 0);
        this.timer.start();
    }

    public boolean isRunning() {
        return this.timer != null && this.timer.isRunning();
    }

    public void restart() {
        if (this.isRunning()) {
            this.timer.stop();
            this.firstClockLabel.setText(null);
            this.secondClockLabel.setText(null);
            this.start();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Calendar updateTime() {
        Calendar cal = Calendar.getInstance(this.zone);
        Date date = cal.getTime();
        IstiClockPanel istiClockPanel = this;
        synchronized (istiClockPanel) {
            if (this.firstDateFormatter != null) {
                this.firstClockLabel.setText(this.firstDateFormatter.format(date));
            }
            if (this.secondDateFormatter != null) {
                this.secondClockLabel.setText(this.secondDateFormatter.format(date));
            }
            this.toolBar.repaint();
        }
        return cal;
    }

    public void actionPerformed(ActionEvent e) {
        this.updateCommandState(e.getActionCommand());
    }

    public void setFloatable(boolean flgVal) {
        this.toolBar.setFloatable(flgVal);
    }

    public boolean isFloatable() {
        return this.toolBar.isFloatable();
    }
}

