/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gis;

public class DistAz {
    private double delta;
    private double az;
    private double baz;
    private double stalat;
    private double stalon;
    private double evtlat;
    private double evtlon;
    private int hash;
    private boolean hashSet = false;

    public DistAz(double lat1, double lon1, double lat2, double lon2) {
        this.stalat = lat1;
        this.stalon = lon1;
        this.evtlat = lat2;
        this.evtlon = lon2;
        if (lat1 == lat2 && lon1 == lon2) {
            this.delta = 0.0;
            this.az = 0.0;
            this.baz = 0.0;
            return;
        }
        double rad = Math.PI / 180;
        double sph = 0.0033528131778969143;
        double scolat = 1.5707963267948966 - Math.atan((1.0 - sph) * (1.0 - sph) * Math.tan(lat1 * rad));
        double ecolat = 1.5707963267948966 - Math.atan((1.0 - sph) * (1.0 - sph) * Math.tan(lat2 * rad));
        double slon = lon1 * rad;
        double elon = lon2 * rad;
        double a = Math.sin(scolat) * Math.cos(slon);
        double b = Math.sin(scolat) * Math.sin(slon);
        double c = Math.cos(scolat);
        double d = Math.sin(slon);
        double e = -Math.cos(slon);
        double g = -c * e;
        double h = c * d;
        double k = -Math.sin(scolat);
        double aa = Math.sin(ecolat) * Math.cos(elon);
        double bb = Math.sin(ecolat) * Math.sin(elon);
        double cc = Math.cos(ecolat);
        double dd = Math.sin(elon);
        double ee = -Math.cos(elon);
        double gg = -cc * ee;
        double hh = cc * dd;
        double kk = -Math.sin(ecolat);
        double del = Math.acos(a * aa + b * bb + c * cc);
        this.delta = del / rad;
        double rhs1 = (aa - d) * (aa - d) + (bb - e) * (bb - e) + cc * cc - 2.0;
        double rhs2 = (aa - g) * (aa - g) + (bb - h) * (bb - h) + (cc - k) * (cc - k) - 2.0;
        double dbaz = Math.atan2(rhs1, rhs2);
        if (dbaz < 0.0) {
            dbaz += Math.PI * 2;
        }
        this.baz = dbaz / rad;
        rhs1 = (a - dd) * (a - dd) + (b - ee) * (b - ee) + c * c - 2.0;
        rhs2 = (a - gg) * (a - gg) + (b - hh) * (b - hh) + (c - kk) * (c - kk) - 2.0;
        double daz = Math.atan2(rhs1, rhs2);
        if (daz < 0.0) {
            daz += Math.PI * 2;
        }
        this.az = daz / rad;
        if (Math.abs(this.baz - 360.0) < 1.0E-5) {
            this.baz = 0.0;
        }
        if (Math.abs(this.az - 360.0) < 1.0E-5) {
            this.az = 0.0;
        }
    }

    public double getDelta() {
        return this.delta;
    }

    public double getAz() {
        return this.az;
    }

    public double getBaz() {
        return this.baz;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DistAz) {
            DistAz oAz = (DistAz)o;
            if (oAz.stalat == this.stalat && oAz.stalon == this.stalon && oAz.evtlat == this.evtlat && oAz.evtlon == this.evtlon) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (!this.hashSet) {
            int result = 24;
            result = 37 * result + DistAz.hashDouble(this.stalat);
            result = 37 * result + DistAz.hashDouble(this.stalon);
            result = 37 * result + DistAz.hashDouble(this.evtlat);
            this.hash = result = 37 * result + DistAz.hashDouble(this.evtlon);
        }
        return this.hash;
    }

    private static int hashDouble(double d) {
        long bits = Double.doubleToLongBits(d);
        return (int)(bits ^ bits >>> 32);
    }

    public static double degreesToKilometers(double degrees) {
        return degrees * 111.19;
    }

    public static double kilometersToDegrees(double kilometers) {
        return kilometers / 111.19;
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("Usage: java DistAz sta_lat sta_lon evt_lat evt_lon");
            System.out.println("       Returns:  Delta Baz Az");
        } else {
            double stalat = Double.valueOf(args[0]);
            double stalon = Double.valueOf(args[1]);
            double evtlat = Double.valueOf(args[2]);
            double evtlon = Double.valueOf(args[3]);
            DistAz distaz = new DistAz(stalat, stalon, evtlat, evtlon);
            System.out.println("   dist=" + distaz.delta + "   baz=" + distaz.baz + "   az=" + distaz.az);
        }
    }
}

