/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.Archivable;
import com.isti.util.BooleanCp;
import com.isti.util.CfgPropValidator;
import com.isti.util.DataChangedListener;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Timer;
import java.util.Vector;

public class UtilFns {
    public static final String BOOLEAN_TRUE_TEXT = Boolean.TRUE.toString();
    public static final String BOOLEAN_FALSE_TEXT = Boolean.FALSE.toString();
    public static final long MS_PER_SECOND = 1000L;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long MS_PER_MINUTE = 60000L;
    public static final long MINUTES_PER_HOUR = 60L;
    public static final long MS_PER_HOUR = 3600000L;
    public static final long HOURS_PER_DAY = 24L;
    public static final long MINUTES_PER_DAY = 1440L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final long MS_PER_DAY = 86400000L;
    public static final String EMPTY_STRING = "";
    public static final String SPACE_STRING = " ";
    public static final String QUOTE_STRING = "\"";
    public static final String ALPHANUM_CHARS_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String INVALID_FILENAME_CHARS = "%\"*<>?|/\\:";
    public static final String DATE_FORMAT24_STR = "MMM dd yyyy HH:mm:ss z";
    public static final String DATE_FORMAT_AMPM_STR = "MMM dd yyyy hh:mm:ss a z";
    public static final TimeZone GMT_TIME_ZONE_OBJ = TimeZone.getTimeZone("GMT");
    public static final String DEFAULT_JAVA_VERSION_STRING = "(Unknown)";
    public static final int colorPropertyStringLength = 8;
    public static final String DEFAULT_SEP_STR = ", ";
    public static final String DEFAULT_NULL_STR = "null";
    private static final Vector listenersVec = new Vector();
    private static final Locale systemLocaleObj = Locale.getDefault();
    private static final Object defaultLocaleSyncObj = new Object();
    private static Locale defaultLocaleObj = systemLocaleObj;
    private static char decimalSeparator = new DecimalFormatSymbols(defaultLocaleObj).getDecimalSeparator();
    private static final DateFormat dateFormatter = UtilFns.createDateFormatObj("MMM dd yyyy HH:mm:ss z");
    private static final DateFormat dateFormatterGMT = UtilFns.createDateFormatObj("MMM dd yyyy HH:mm:ss z", GMT_TIME_ZONE_OBJ);
    private static final DateFormat dateFormatterAmPm = UtilFns.createDateFormatObj("MMM dd yyyy hh:mm:ss a z");
    private static final DateFormat dateFormatterGMTAmPm = UtilFns.createDateFormatObj("MMM dd yyyy hh:mm:ss a z", GMT_TIME_ZONE_OBJ);
    public static final String DATE_FORMAT_RFC_822_STR = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final DateFormat rfc_822DateFormatObj = UtilFns.createDateFormatObj("EEE, dd MMM yyyy HH:mm:ss z", GMT_TIME_ZONE_OBJ);
    private static final Runtime systemRuntimeObj = Runtime.getRuntime();
    private static final NumberFormat floatNumberFormatObj = UtilFns.createFloatNumberFormat("#0.0#");
    private static final NumberFormat variableNumberFormatObj = UtilFns.createFloatNumberFormat("#0.0#");
    private static final int variableNumberFormatMaximumIntegerDigits = variableNumberFormatObj.getMaximumIntegerDigits();
    private static String[] timeZoneIDs = TimeZone.getAvailableIDs();
    public static final CfgPropValidator timeZoneValidator;
    public static final String newline;
    private static String blanksString;
    private static int blanksStringLen;
    private static final Object blanksStringSyncObj;
    private static ThreadGroup rootThreadGroupObj;
    private static Integer[] COLOR_HASH_VALUES;
    private static String[] COLOR_HASH_STRINGS;
    private static String[] COLOR_DISPLAY_STRINGS;
    private static Hashtable strToClrHashtable;
    private static Hashtable clrToStrHashtable;
    public static final String[] FAKE_IP_ADDRS;
    public static final String DEF_SPECIAL_CHARS_STR = "\"\r\n\t\\";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Timer;
    static /* synthetic */ Class class$com$isti$util$BooleanCp;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$com$isti$util$Archivable$Marker;

    private UtilFns() {
    }

    public static boolean checkJavaVersion(String javaVersionString, String minJavaVersionString) {
        if (javaVersionString != DEFAULT_JAVA_VERSION_STRING && UtilFns.parseVersionNumbers(javaVersionString).length > 0) {
            return UtilFns.compareVersionStrings(javaVersionString, minJavaVersionString) >= 0;
        }
        return true;
    }

    public static String getJavaVersion() {
        String javaVersionString = System.getProperty("java.version");
        if (javaVersionString == null) {
            javaVersionString = DEFAULT_JAVA_VERSION_STRING;
        }
        return javaVersionString;
    }

    public static long getSystemTimeSec() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long intTimeToLong(int intTime) {
        if (intTime >= 0) {
            return intTime;
        }
        return (long)intTime + 0x100000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String dateToRFC_822String(Date date) {
        DateFormat dateFormat = rfc_822DateFormatObj;
        synchronized (dateFormat) {
            return rfc_822DateFormatObj.format(date);
        }
    }

    public static final String timeMillisToRFC_822String(long millis) {
        return UtilFns.dateToRFC_822String(new Date(millis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String timeMillisToString(long millis, boolean gmtFlag, boolean amPmFlag) {
        DateFormat formatterObj;
        DateFormat dateFormat = formatterObj = UtilFns.getLocalDateFormatObj(gmtFlag, amPmFlag);
        synchronized (dateFormat) {
            return formatterObj.format(new Date(millis));
        }
    }

    public static String timeMillisToString(long millis, boolean gmtFlag) {
        return UtilFns.timeMillisToString(millis, gmtFlag, false);
    }

    public static String timeMillisToString(long millis) {
        return UtilFns.timeMillisToString(millis, false, false);
    }

    public static String timeMillisToString() {
        return UtilFns.timeMillisToString(System.currentTimeMillis(), false, false);
    }

    public static String durationMillisToString(long durationMs, boolean showDaysFlag, boolean showSecsFlag, boolean verboseFlag) {
        int sec;
        int min;
        int hrs;
        int days;
        if (showDaysFlag) {
            days = (int)(durationMs / 86400000L);
            if (days > 0) {
                durationMs -= (long)days * 86400000L;
            }
        } else {
            days = 0;
        }
        if ((hrs = (int)(durationMs / 3600000L)) > 0) {
            durationMs -= (long)hrs * 3600000L;
        }
        if ((min = (int)(durationMs / 60000L)) > 0) {
            durationMs -= (long)min * 60000L;
        }
        if ((sec = (int)(durationMs / 1000L)) > 0) {
            durationMs -= (long)sec * 1000L;
        }
        if ((int)durationMs >= 500) {
            ++sec;
        }
        if (!showSecsFlag && sec >= 30) {
            ++min;
        }
        if (verboseFlag) {
            return (days > 0 ? days + " day" + (days != 1 ? "s" : EMPTY_STRING) + SPACE_STRING : EMPTY_STRING) + (hrs > 0 ? hrs + " hour" + (hrs != 1 ? "s" : EMPTY_STRING) + SPACE_STRING : EMPTY_STRING) + (!showSecsFlag || min > 0 ? min + " minute" + (min != 1 ? "s" : EMPTY_STRING) + SPACE_STRING : EMPTY_STRING) + (showSecsFlag ? sec + " second" + (sec != 1 ? "s" : EMPTY_STRING) + SPACE_STRING : EMPTY_STRING);
        }
        return (days > 0 ? days + " day" + (days > 1 ? "s" : EMPTY_STRING) + SPACE_STRING : EMPTY_STRING) + hrs + ':' + (min < 10 ? "0" : EMPTY_STRING) + min + (showSecsFlag ? ':' + (sec < 10 ? "0" : EMPTY_STRING) + sec : EMPTY_STRING);
    }

    public static String durationMillisToString(long durationMs, boolean showDaysFlag, boolean showSecsFlag) {
        return UtilFns.durationMillisToString(durationMs, showDaysFlag, showSecsFlag, false);
    }

    public static String durationMillisToString(long durationMs, boolean showDaysFlag) {
        return UtilFns.durationMillisToString(durationMs, showDaysFlag, true);
    }

    public static String durationMillisToString(long durationMs) {
        return UtilFns.durationMillisToString(durationMs, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseStringToDate(String dateStr, boolean gmtFlag, boolean amPmFlag) {
        DateFormat formatterObj = UtilFns.getLocalDateFormatObj(gmtFlag, amPmFlag);
        try {
            DateFormat dateFormat = formatterObj;
            synchronized (dateFormat) {
                return formatterObj.parse(dateStr);
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Date parseStringToDate(String s, boolean gmtFlag) {
        return UtilFns.parseStringToDate(s, gmtFlag, false);
    }

    public static Date parseStringToDate(String s) {
        return UtilFns.parseStringToDate(s, false, false);
    }

    private static DateFormat getLocalDateFormatObj(boolean gmtFlag, boolean amPmFlag) {
        if (amPmFlag) {
            return gmtFlag ? dateFormatterGMTAmPm : dateFormatterAmPm;
        }
        return gmtFlag ? dateFormatterGMT : dateFormatter;
    }

    public static boolean setDateFormatPattern(DateFormat formatObj, String patternStr) {
        try {
            if (formatObj instanceof SimpleDateFormat && patternStr != null) {
                ((SimpleDateFormat)formatObj).applyPattern(patternStr);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDataChangedListener(DataChangedListener listenerObj) {
        if (listenerObj != null) {
            Vector vector = listenersVec;
            synchronized (vector) {
                if (!listenersVec.contains(listenerObj)) {
                    listenersVec.add(listenerObj);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDataChangedListener(DataChangedListener listenerObj) {
        if (listenerObj != null) {
            Vector vector = listenersVec;
            synchronized (vector) {
                listenersVec.remove(listenerObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireDataChanged(Object sourceObj) {
        Vector localListenersVec;
        Vector vector = listenersVec;
        synchronized (vector) {
            localListenersVec = (Vector)listenersVec.clone();
        }
        Enumeration e = localListenersVec.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof DataChangedListener)) continue;
            ((DataChangedListener)obj).dataChanged(sourceObj);
        }
    }

    public static Locale getDefaultLocale() {
        return defaultLocaleObj;
    }

    public static Locale getSystemLocale() {
        return systemLocaleObj;
    }

    public static char getDecimalSeparator() {
        return decimalSeparator;
    }

    public static void setDateFormatSymbols(DateFormat formatObj, DateFormatSymbols newSymbols) {
        if (formatObj instanceof SimpleDateFormat) {
            ((SimpleDateFormat)formatObj).setDateFormatSymbols(newSymbols);
        }
    }

    public static void setDecimalFormatSymbols(NumberFormat formatObj, DecimalFormatSymbols newSymbols) {
        if (formatObj instanceof DecimalFormat) {
            ((DecimalFormat)formatObj).setDecimalFormatSymbols(newSymbols);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultLocale(Locale localeObj) {
        if (localeObj == null) {
            localeObj = systemLocaleObj;
        }
        Object object = defaultLocaleSyncObj;
        synchronized (object) {
            if (defaultLocaleObj.equals(localeObj)) {
                return;
            }
            defaultLocaleObj = localeObj;
        }
        decimalSeparator = new DecimalFormatSymbols(localeObj).getDecimalSeparator();
        DecimalFormatSymbols newSymbols = new DecimalFormatSymbols(localeObj);
        UtilFns.setDecimalFormatSymbols(floatNumberFormatObj, newSymbols);
        UtilFns.setDecimalFormatSymbols(variableNumberFormatObj, newSymbols);
        DateFormatSymbols newFormatSymbols = new DateFormatSymbols(localeObj);
        UtilFns.setDateFormatSymbols(dateFormatter, newFormatSymbols);
        UtilFns.setDateFormatSymbols(dateFormatterGMT, newFormatSymbols);
        UtilFns.setDateFormatSymbols(dateFormatterAmPm, newFormatSymbols);
        UtilFns.setDateFormatSymbols(dateFormatterGMTAmPm, newFormatSymbols);
        UtilFns.fireDataChanged(localeObj);
    }

    public static DateFormat createDateFormatObj(String patternStr, TimeZone timeZoneObj) {
        return UtilFns.createDateFormatObj(patternStr, timeZoneObj, UtilFns.getDefaultLocale());
    }

    public static DateFormat createDateFormatObj(String patternStr, TimeZone timeZoneObj, Locale localeObj) {
        DateFormat formatObj = DateFormat.getDateTimeInstance(2, 2, localeObj);
        if (!UtilFns.setDateFormatPattern(formatObj, patternStr)) {
            formatObj = new SimpleDateFormat(patternStr, localeObj);
        }
        if (timeZoneObj != null) {
            formatObj.setTimeZone(timeZoneObj);
        }
        return formatObj;
    }

    public static DateFormat createDateFormatObj(String patternStr) {
        return UtilFns.createDateFormatObj(patternStr, (TimeZone)null);
    }

    public static DateFormat createDateFormatObj(String patternStr, Locale localeObj) {
        return UtilFns.createDateFormatObj(patternStr, null, localeObj);
    }

    public static NumberFormat createFloatNumberFormat() {
        NumberFormat floatFormatterObj = NumberFormat.getNumberInstance(UtilFns.getDefaultLocale());
        return floatFormatterObj;
    }

    public static NumberFormat createFloatNumberFormat(Locale localeObj) {
        NumberFormat floatFormatterObj = NumberFormat.getNumberInstance(localeObj);
        return floatFormatterObj;
    }

    public static NumberFormat createFloatNumberFormat(int numDigits) {
        return UtilFns.createFloatNumberFormat(numDigits, numDigits);
    }

    public static NumberFormat createFloatNumberFormat(int numDigits, Locale localeObj) {
        return UtilFns.createFloatNumberFormat(numDigits, numDigits, localeObj);
    }

    public static NumberFormat createFloatNumberFormat(int minDigits, int maxDigits) {
        return UtilFns.createFloatNumberFormat(minDigits, maxDigits, UtilFns.getDefaultLocale());
    }

    public static NumberFormat createFloatNumberFormat(int minDigits, int maxDigits, Locale localeObj) {
        NumberFormat floatFormatterObj = UtilFns.createFloatNumberFormat(localeObj);
        floatFormatterObj.setMinimumFractionDigits(minDigits);
        floatFormatterObj.setMaximumFractionDigits(maxDigits);
        return floatFormatterObj;
    }

    public static NumberFormat createFloatNumberFormat(String patternStr) {
        return UtilFns.createFloatNumberFormat(patternStr, UtilFns.getDefaultLocale());
    }

    public static NumberFormat createFloatNumberFormat(String patternStr, Locale localeObj) {
        DecimalFormat floatFormatterObj = new DecimalFormat(patternStr, new DecimalFormatSymbols(localeObj));
        return floatFormatterObj;
    }

    public static Timer createNamedTimerObj(String nameStr, boolean daemonFlag) {
        try {
            Constructor timerConstructorObj = (class$java$util$Timer == null ? (class$java$util$Timer = UtilFns.class$("java.util.Timer")) : class$java$util$Timer).getConstructor(class$java$lang$String == null ? (class$java$lang$String = UtilFns.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
            return (Timer)timerConstructorObj.newInstance(nameStr, daemonFlag ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception exception) {
            return new Timer(daemonFlag);
        }
    }

    public static String[] getTimeZoneIDs() {
        return timeZoneIDs;
    }

    public static TimeZone parseTimeZoneID(String id) {
        return TimeZone.getTimeZone(id);
    }

    public static boolean sleep(long millisecs) {
        try {
            Thread.sleep(millisecs);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public static String shortClassString(Class classObj) {
        String str;
        if (classObj == null || (str = classObj.getName()) == null) {
            return EMPTY_STRING;
        }
        int p = str.lastIndexOf(46);
        if (p >= 0) {
            str = str.substring(p + 1);
        }
        return str;
    }

    public static String stripBrackets(String str) {
        int len;
        if (str == null || (len = str.length()) < 2 || str.charAt(0) != '[' || str.charAt(len - 1) != ']') {
            return str;
        }
        return str.substring(1, len - 1);
    }

    public static String stripChar(String str, char ch) {
        StringBuffer buff = new StringBuffer(str);
        int pos = 0;
        int c = 0;
        while ((pos = buff.toString().indexOf(ch, pos)) >= 0) {
            buff.deleteCharAt(pos);
            ++c;
        }
        return c > 0 ? buff.toString() : str;
    }

    public static String stripTrailingString(String dataStr, String stripStr) {
        if (dataStr != null && stripStr != null && dataStr.endsWith(stripStr)) {
            return dataStr.substring(0, dataStr.length() - stripStr.length());
        }
        return dataStr;
    }

    public static String stripTrailingNewline(String dataStr) {
        return UtilFns.stripTrailingString(dataStr, newline);
    }

    public static Number parseNumber(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) < 1) {
            return null;
        }
        try {
            if (str.charAt(0) >= 'A') {
                if (str.equalsIgnoreCase(BOOLEAN_TRUE_TEXT)) {
                    return new BooleanCp(true);
                }
                if (str.equalsIgnoreCase(BOOLEAN_FALSE_TEXT)) {
                    return new BooleanCp(false);
                }
            }
            for (int p = 0; p < strLen; ++p) {
                char ch = str.charAt(p);
                if (ch != '.' && ch != 'E' && ch != 'e') continue;
                return new Double(str);
            }
            if (decimalSeparator != '.' && str.indexOf(decimalSeparator) >= 0) {
                return new Double(str.replace(decimalSeparator, '.'));
            }
            if (str.charAt(0) < 'A') {
                return new Integer(str);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Number parseNumber(String str, Class valueClass) {
        try {
            Number numberObj;
            if ((class$com$isti$util$BooleanCp == null ? (class$com$isti$util$BooleanCp = UtilFns.class$("com.isti.util.BooleanCp")) : class$com$isti$util$BooleanCp).equals(valueClass)) {
                return new BooleanCp(str);
            }
            if (decimalSeparator != '.') {
                str = str.replace('.', decimalSeparator);
            }
            if (!(numberObj = floatNumberFormatObj.parse(str)).getClass().equals(valueClass)) {
                if ((class$java$lang$Integer == null ? (class$java$lang$Integer = UtilFns.class$("java.lang.Integer")) : class$java$lang$Integer).equals(valueClass)) {
                    return new Integer(numberObj.intValue());
                }
                if ((class$java$lang$Long == null ? (class$java$lang$Long = UtilFns.class$("java.lang.Long")) : class$java$lang$Long).equals(valueClass)) {
                    return new Long(numberObj.longValue());
                }
                if ((class$java$lang$Float == null ? (class$java$lang$Float = UtilFns.class$("java.lang.Float")) : class$java$lang$Float).equals(valueClass)) {
                    return new Float(numberObj.floatValue());
                }
                if ((class$java$lang$Double == null ? (class$java$lang$Double = UtilFns.class$("java.lang.Double")) : class$java$lang$Double).equals(valueClass)) {
                    return new Double(numberObj.doubleValue());
                }
                if ((class$java$lang$Byte == null ? (class$java$lang$Byte = UtilFns.class$("java.lang.Byte")) : class$java$lang$Byte).equals(valueClass)) {
                    return new Byte(numberObj.byteValue());
                }
                if ((class$java$lang$Short == null ? (class$java$lang$Short = UtilFns.class$("java.lang.Short")) : class$java$lang$Short).equals(valueClass)) {
                    return new Short(numberObj.shortValue());
                }
            }
            return numberObj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getUserConsoleString() {
        try {
            return new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static int getColorDisplayNameIndex(int value) {
        for (int i = 0; i < COLOR_HASH_VALUES.length; ++i) {
            if (COLOR_HASH_VALUES[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int getColorDisplayNameValue(int index) {
        return COLOR_HASH_VALUES[index];
    }

    public static String getColorDisplayName(int value) {
        int index = UtilFns.getColorDisplayNameIndex(value);
        String displayName = index >= 0 ? COLOR_DISPLAY_STRINGS[index] : UtilFns.colorRGBToString(value, true);
        return displayName;
    }

    public static String[] getColorDisplayNames() {
        return COLOR_DISPLAY_STRINGS;
    }

    public static Integer stringToColorRGB(String str) {
        return UtilFns.stringToColorRGB(str, false);
    }

    public static Integer stringToColorRGB(String str, boolean tryRGBFlag) {
        Object obj;
        if (strToClrHashtable == null) {
            strToClrHashtable = new Hashtable();
            for (int i = 0; i < COLOR_HASH_STRINGS.length; ++i) {
                strToClrHashtable.put(COLOR_HASH_STRINGS[i], COLOR_HASH_VALUES[i]);
            }
        }
        if ((obj = strToClrHashtable.get(str.toLowerCase())) instanceof Integer) {
            return (Integer)obj;
        }
        if (tryRGBFlag) {
            Color colorObj;
            int p = str.indexOf(44);
            if (p >= 0) {
                int[] intArr = new int[3];
                int len = str.length();
                int c = 0;
                int stPos = 0;
                while (true) {
                    try {
                        intArr[c] = Integer.parseInt(str.substring(stPos, p));
                    }
                    catch (Exception ex) {
                        return null;
                    }
                    if (++c >= 3) break;
                    stPos = p + 1;
                    if (stPos >= len) {
                        return null;
                    }
                    p = str.indexOf(44, stPos);
                    if (p >= 0) continue;
                    p = len;
                }
                if (p < len) {
                    return null;
                }
                try {
                    colorObj = new Color(intArr[0], intArr[1], intArr[2]);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            try {
                int value;
                boolean hasalpha = false;
                try {
                    value = Integer.parseInt(str);
                }
                catch (NumberFormatException ex) {
                    value = Long.decode(str).intValue();
                    hasalpha = true;
                }
                colorObj = new Color(value, hasalpha);
            }
            catch (Exception ex) {
                return null;
            }
            try {
                return new Integer(colorObj.getRGB());
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static String booleanToString(boolean b) {
        return b ? BOOLEAN_TRUE_TEXT : BOOLEAN_FALSE_TEXT;
    }

    public static Boolean booleanValueOf(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Boolean booleanValueOf(String s) {
        return UtilFns.booleanValueOf(UtilFns.stringToBoolean(s));
    }

    public static boolean stringToBoolean(String s) {
        return UtilFns.stringToBoolean(s, false);
    }

    public static boolean stringToBoolean(String s, boolean defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return s.equalsIgnoreCase(BOOLEAN_TRUE_TEXT);
    }

    public static String colorRGBToString(int colorRGBVal) {
        Object obj;
        if (clrToStrHashtable == null) {
            clrToStrHashtable = new Hashtable();
            for (int i = 0; i < COLOR_HASH_VALUES.length; ++i) {
                clrToStrHashtable.put(COLOR_HASH_VALUES[i], COLOR_HASH_STRINGS[i]);
            }
        }
        if ((obj = clrToStrHashtable.get(new Integer(colorRGBVal))) == null || !(obj instanceof String)) {
            return null;
        }
        return (String)obj;
    }

    public static String colorRGBToString(int colorRGBVal, boolean useHexFlag) {
        String colorStr = UtilFns.colorRGBToString(colorRGBVal);
        if (colorStr == null && useHexFlag) {
            colorStr = UtilFns.toHexString(colorRGBVal, 8).toUpperCase();
            if (colorStr.startsWith("FF")) {
                colorStr = colorStr.substring(2);
            }
            colorStr = "0x" + colorStr;
        }
        return colorStr;
    }

    public static String toHexString(int i, int numDigits) {
        String hexString = Integer.toHexString(i);
        for (int len = hexString.length(); len < numDigits; ++len) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    public static String colorToPropertyString(Color colorObj) {
        return UtilFns.toHexString(colorObj.getRGB(), 8).toUpperCase();
    }

    public static String floatNumberToPropertyString(Object value) {
        return floatNumberFormatObj.format(value);
    }

    public static String floatNumberToString(double value) {
        int digits = 1;
        if (value > 0.0 && value < 0.1) {
            double x = value;
            while (true) {
                double d;
                x *= 10.0;
                if (!(d < 1.0)) break;
                ++digits;
            }
        }
        return UtilFns.floatNumberToString(value, digits);
    }

    public static String floatNumberToString(double value, int digits) {
        return UtilFns.floatNumberToString(value, digits, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String floatNumberToString(double value, int digits, int columns, Comparable maxValueObj) {
        String retVal;
        NumberFormat numberFormat = variableNumberFormatObj;
        synchronized (numberFormat) {
            Double newValue;
            if (columns > 0) {
                variableNumberFormatObj.setMaximumIntegerDigits(columns);
            } else {
                variableNumberFormatObj.setMaximumIntegerDigits(variableNumberFormatMaximumIntegerDigits);
            }
            variableNumberFormatObj.setMaximumFractionDigits(digits);
            retVal = variableNumberFormatObj.format(value);
            int decimalSeparatorIndex = retVal.indexOf(decimalSeparator);
            if (columns > 0 && retVal.length() > columns) {
                digits = columns - 1 - decimalSeparatorIndex;
                variableNumberFormatObj.setMaximumFractionDigits(digits);
                retVal = variableNumberFormatObj.format(value);
            }
            if (maxValueObj != null && maxValueObj.compareTo(newValue = new Double(retVal)) < 0) {
                int numFracDigits = retVal.length() - 1 - decimalSeparatorIndex;
                if (decimalSeparatorIndex >= 0 && numFracDigits > 0) {
                    double subValue = Math.pow(10.0, -numFracDigits);
                    retVal = variableNumberFormatObj.format(value - subValue);
                }
            }
        }
        return retVal;
    }

    public static Object parseObject(Class valueClass, String dataStr) {
        try {
            Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = UtilFns.class$("java.lang.String")) : class$java$lang$String};
            Constructor c = valueClass.getConstructor(parameterTypes);
            Object[] initargs = new Object[]{dataStr};
            return c.newInstance(initargs);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parseObject(Object defaultValueObj, String dataStr) {
        try {
            return UtilFns.parseObject(defaultValueObj.getClass(), dataStr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Archivable parseArchivable(Class valueClass, String dataStr) {
        try {
            Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = UtilFns.class$("java.lang.String")) : class$java$lang$String, class$com$isti$util$Archivable$Marker == null ? (class$com$isti$util$Archivable$Marker = UtilFns.class$("com.isti.util.Archivable$Marker")) : class$com$isti$util$Archivable$Marker};
            Constructor c = valueClass.getConstructor(parameterTypes);
            Object[] initargs = new Object[]{dataStr, null};
            Object obj = c.newInstance(initargs);
            if (obj instanceof Archivable) {
                return (Archivable)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Archivable parseArchivable(Archivable defaultValueObj, String dataStr) {
        try {
            return UtilFns.parseArchivable(defaultValueObj.getClass(), dataStr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Color parseColor(String colorString) throws NumberFormatException {
        int value = (int)Long.parseLong(colorString, 16);
        if (colorString.length() < 7 && !colorString.equals("0")) {
            return new Color(value);
        }
        return new Color(value, true);
    }

    public static Color createOpaqueColor(Color colorObj) {
        return new Color(colorObj.getRed(), colorObj.getGreen(), colorObj.getBlue());
    }

    public static String insertQuoteChars(String dataStr, String specialChars) {
        boolean changedFlag = false;
        if (dataStr == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer(dataStr);
        if (specialChars != null && specialChars.length() > 0) {
            for (int p = 0; p < buff.length(); ++p) {
                if (specialChars.indexOf(buff.charAt(p)) < 0) continue;
                buff.insert(p, '\\');
                switch (buff.charAt(++p)) {
                    case '\r': {
                        buff.setCharAt(p, 'r');
                        break;
                    }
                    case '\n': {
                        buff.setCharAt(p, 'n');
                        break;
                    }
                    case '\t': {
                        buff.setCharAt(p, 't');
                        break;
                    }
                }
                changedFlag = true;
            }
        }
        return changedFlag ? buff.toString() : dataStr;
    }

    public static String removeQuoteChars(String dataStr, boolean removeDblFlag) {
        if (dataStr == null) {
            return null;
        }
        int p = dataStr.indexOf(92);
        if (p >= 0) {
            StringBuffer buff = new StringBuffer(dataStr);
            while (p < buff.length() - 1) {
                buff.deleteCharAt(p);
                switch (buff.charAt(p)) {
                    case 'r': {
                        buff.setCharAt(p, '\r');
                        break;
                    }
                    case 'n': {
                        buff.setCharAt(p, '\n');
                        break;
                    }
                    case 't': {
                        buff.setCharAt(p, '\t');
                        break;
                    }
                }
                ++p;
                p = buff.toString().indexOf(92, p);
                if (p > 0) continue;
            }
            if (removeDblFlag && (p = buff.length()) > 1 && buff.charAt(0) == '\"' && buff.charAt(p - 1) == '\"') {
                return buff.substring(1, p - 1);
            }
            return buff.toString();
        }
        if (removeDblFlag && (p = dataStr.length()) > 1 && dataStr.charAt(0) == '\"' && dataStr.charAt(p - 1) == '\"') {
            return dataStr.substring(1, p - 1);
        }
        return dataStr;
    }

    public static String removeQuoteChars(String dataStr) {
        return UtilFns.removeQuoteChars(dataStr, false);
    }

    public static int findCharPos(String str, char ch, int startPos) {
        if (startPos >= str.length()) {
            return -1;
        }
        int foundPos;
        while ((foundPos = str.indexOf(ch, startPos)) >= 0) {
            if (foundPos == 0) {
                return foundPos;
            }
            if (str.charAt(foundPos - 1) != '\\') {
                --startPos;
                do {
                    if ((startPos = str.indexOf(34, startPos + 1)) >= 0) continue;
                    return foundPos;
                } while (startPos > 0 && str.charAt(startPos - 1) == '\\');
                if (startPos > foundPos) {
                    return foundPos;
                }
                do {
                    if ((startPos = str.indexOf(34, startPos + 1)) >= 0) continue;
                    return -1;
                } while (str.charAt(startPos - 1) == '\\');
                ++startPos;
                continue;
            }
            startPos = foundPos + 1;
        }
        return -1;
    }

    public static int findCharPos(String str, char ch) {
        return UtilFns.findCharPos(str, ch, 0);
    }

    public static int findCharPos(String str, String searchCharsStr, int startPos) {
        int strLen;
        if (searchCharsStr == null) {
            return -1;
        }
        int minPos = strLen = str.length();
        int searchCharsStrLen = searchCharsStr.length();
        for (int i = 0; i < searchCharsStrLen; ++i) {
            int p = UtilFns.findCharPos(str, searchCharsStr.charAt(i), startPos);
            if (p < 0 || p >= minPos) continue;
            minPos = p;
        }
        return minPos < strLen ? minPos : -1;
    }

    public static int findCharPos(String str, String searchCharsStr) {
        return UtilFns.findCharPos(str, searchCharsStr, 0);
    }

    public static int indexOfWhitespace(String str, int startPos) {
        if (startPos >= 0) {
            int len = str.length();
            for (int p = startPos; p < len; ++p) {
                if (!Character.isWhitespace(str.charAt(p))) continue;
                return p;
            }
        }
        return -1;
    }

    public static int indexOfWhitespace(String str) {
        return UtilFns.indexOfWhitespace(str, 0);
    }

    public static Enumeration iteratorToEnum(final Iterator it) {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        };
    }

    public static Iterator enumToIterator(final Enumeration e) {
        return new Iterator(){

            public boolean hasNext() {
                return e.hasMoreElements();
            }

            public Object next() {
                return e.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String enumToListString(Enumeration e) {
        StringBuffer buff = new StringBuffer();
        if (e.hasMoreElements()) {
            while (true) {
                Object obj;
                if ((obj = e.nextElement()) != null) {
                    buff.append(obj.toString());
                } else {
                    buff.append("(null)");
                }
                if (!e.hasMoreElements()) break;
                buff.append(DEFAULT_SEP_STR);
            }
        }
        return buff.toString();
    }

    public static String enumToString(Enumeration e) {
        StringBuffer buff = new StringBuffer();
        buff.append("{");
        if (e.hasMoreElements()) {
            while (true) {
                Object obj;
                if ((obj = e.nextElement()) != null) {
                    buff.append(obj.toString());
                } else {
                    buff.append("(null)");
                }
                if (!e.hasMoreElements()) break;
                buff.append(DEFAULT_SEP_STR);
            }
        }
        buff.append("}");
        return buff.toString();
    }

    public static String enumToQuotedStrings(Enumeration enumObj, String sepStr, boolean quoteCharsFlag) {
        StringBuffer retBuff = new StringBuffer();
        if (enumObj != null && enumObj.hasMoreElements()) {
            if (quoteCharsFlag) {
                while (true) {
                    Object obj;
                    if ((obj = enumObj.nextElement()) != null) {
                        retBuff.append(QUOTE_STRING + UtilFns.insertQuoteChars(obj.toString(), DEF_SPECIAL_CHARS_STR) + QUOTE_STRING);
                    }
                    if (enumObj.hasMoreElements()) {
                        retBuff.append(sepStr);
                        continue;
                    }
                    break;
                }
            } else {
                while (true) {
                    Object obj;
                    if ((obj = enumObj.nextElement()) != null) {
                        retBuff.append(QUOTE_STRING + obj.toString() + QUOTE_STRING);
                    }
                    if (!enumObj.hasMoreElements()) break;
                    retBuff.append(sepStr);
                }
            }
        }
        return retBuff.toString();
    }

    public static String enumToQuotedStrings(Enumeration enumObj, char sepChar, boolean quoteCharsFlag) {
        return UtilFns.enumToQuotedStrings(enumObj, new String(new char[]{sepChar}), quoteCharsFlag);
    }

    public static String enumToQuotedStrings(Enumeration enumObj) {
        return UtilFns.enumToQuotedStrings(enumObj, ',', true);
    }

    public static String listObjToListStr(List listObj, String sepStr) {
        if (listObj == null) {
            return EMPTY_STRING;
        }
        StringBuffer buffObj = new StringBuffer();
        Iterator iterObj = listObj.iterator();
        if (iterObj.hasNext()) {
            while (true) {
                Object obj;
                if ((obj = iterObj.next()) != null) {
                    buffObj.append(obj.toString());
                }
                if (!iterObj.hasNext()) break;
                buffObj.append(sepStr);
            }
        }
        return buffObj.toString();
    }

    public static Vector quotedStringsToVector(String str, char sepChar, boolean strictFlag) {
        int ePos;
        if (str == null) {
            return null;
        }
        Vector<String> retVec = new Vector<String>();
        int strLen = str.length();
        if (strLen <= 0) {
            return retVec;
        }
        int sPos = 0;
        do {
            if ((ePos = UtilFns.findCharPos(str, sepChar, sPos)) < sPos) {
                ePos = strLen;
            }
            String subStr = str.substring(sPos, ePos);
            if (strictFlag) {
                int p = subStr.length();
                if (p <= 0) break;
                if (p < 2 || subStr.charAt(0) != '\"' || subStr.charAt(p - 1) != '\"') {
                    return null;
                }
            } else if ((subStr = subStr.trim()).length() <= 0) break;
            subStr = UtilFns.removeQuoteChars(subStr, true);
            retVec.add(subStr);
        } while ((sPos = ePos + 1) < strLen);
        return retVec;
    }

    public static Vector quotedStringsToVector(String str, char sepChar) {
        return UtilFns.quotedStringsToVector(str, sepChar, true);
    }

    public static Vector quotedStringsToVector(String str) {
        return UtilFns.quotedStringsToVector(str, ',', true);
    }

    public static Vector quotedStringsToVector(String str, String sepCharsStr, boolean strictFlag) {
        int ePos;
        if (str == null) {
            return null;
        }
        if (sepCharsStr == null || sepCharsStr.length() <= 0) {
            sepCharsStr = " ,;";
        }
        Vector<String> retVec = new Vector<String>();
        int strLen = str.length();
        if (strLen <= 0) {
            return retVec;
        }
        int sPos = 0;
        do {
            if (!strictFlag) {
                while (Character.isWhitespace(str.charAt(sPos)) && ++sPos < strLen - 1) {
                }
            }
            if ((ePos = UtilFns.findCharPos(str, sepCharsStr, sPos)) < sPos) {
                ePos = strLen;
            }
            String subStr = str.substring(sPos, ePos);
            if (strictFlag) {
                int p = subStr.length();
                if (p <= 0) break;
                if (p < 2 || subStr.charAt(0) != '\"' || subStr.charAt(p - 1) != '\"') {
                    return null;
                }
            } else {
                while (ePos < strLen - 1 && Character.isWhitespace(str.charAt(ePos + 1))) {
                    ++ePos;
                }
                if ((subStr = subStr.trim()).length() <= 0) break;
            }
            subStr = UtilFns.removeQuoteChars(subStr, true);
            retVec.add(subStr);
        } while ((sPos = ePos + 1) < strLen);
        return retVec;
    }

    public static Vector listStringToVector(String str) {
        return UtilFns.listStringToVector(str, ',', true);
    }

    public static Vector listStringToVector(String str, char sepChar, boolean trimFlag) {
        int ePos;
        Vector<String> retVec = new Vector<String>();
        if (str == null) {
            return retVec;
        }
        int strLen = str.length();
        if (strLen <= 0) {
            return retVec;
        }
        int sPos = 0;
        do {
            if ((ePos = UtilFns.findCharPos(str, sepChar, sPos)) < sPos) {
                ePos = strLen;
            }
            String subStr = str.substring(sPos, ePos);
            if (trimFlag) {
                subStr = subStr.trim();
            }
            if (subStr.length() > 0 && subStr.charAt(0) == '\"') {
                subStr = UtilFns.removeQuoteChars(subStr, true);
            }
            retVec.add(subStr);
        } while ((sPos = ePos + 1) < strLen);
        return retVec;
    }

    public static boolean moveListElement(List listObj, int index, Object element) {
        int currentIndex = listObj.indexOf(element);
        if (currentIndex != index) {
            if (currentIndex >= 0) {
                listObj.remove(currentIndex);
            }
            try {
                listObj.add(index, element);
            }
            catch (Exception ex) {
                listObj.add(element);
            }
            return true;
        }
        return false;
    }

    public static String getTableContentsString(Map tableObj, String sepStr) {
        StringBuffer buff = new StringBuffer();
        try {
            Iterator iterObj = tableObj.keySet().iterator();
            if (iterObj.hasNext()) {
                while (true) {
                    buff.append(QUOTE_STRING);
                    Object obj = iterObj.next();
                    buff.append(obj);
                    buff.append("\" = \"");
                    buff.append(tableObj.get(obj));
                    buff.append(QUOTE_STRING);
                    if (iterObj.hasNext()) {
                        buff.append(sepStr);
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            return "getTableContentsString() error:  " + ex;
        }
        return buff.toString();
    }

    public static String getTableContentsString(Map tableObj) {
        return UtilFns.getTableContentsString(tableObj, DEFAULT_SEP_STR);
    }

    public static Vector removeEmptyStrings(Vector vec) {
        if (vec == null) {
            return null;
        }
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if ((!(obj instanceof String) || ((String)obj).length() > 0) && obj != null) continue;
            vec.remove(obj);
        }
        return vec;
    }

    public static String fixStringLen(String inString, int outLen, boolean rightJustFlag, boolean truncateFlag) {
        int len;
        int bLen;
        if (outLen <= 0) {
            return EMPTY_STRING;
        }
        if (inString == null) {
            inString = EMPTY_STRING;
        }
        if ((bLen = outLen - (len = inString.length())) <= 0) {
            return truncateFlag ? inString.substring(0, outLen) : inString;
        }
        return rightJustFlag ? UtilFns.getSpacerString(bLen) + inString : inString + UtilFns.getSpacerString(bLen);
    }

    public static String fixStringLen(String inString, int outLen, boolean rightJustFlag) {
        return UtilFns.fixStringLen(inString, outLen, rightJustFlag, true);
    }

    public static String fixStringLen(String inString, int outLen) {
        return UtilFns.fixStringLen(inString, outLen, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSpacerString(int numSpaces) {
        Object object = blanksStringSyncObj;
        synchronized (object) {
            if (numSpaces > blanksStringLen) {
                blanksStringLen = numSpaces;
                char[] charArr = new char[blanksStringLen];
                Arrays.fill(charArr, ' ');
                blanksString = new String(charArr);
            }
            return blanksString.substring(0, numSpaces);
        }
    }

    public static String createCenteredString(String inString, int fieldLen) {
        int sLen = inString.length();
        int rmdr = fieldLen - sLen;
        if (rmdr > 0) {
            return UtilFns.fixStringLen(inString, sLen + rmdr / 2, true, false);
        }
        return inString;
    }

    public static String softWordWrapString(String srcStr, int lineWidth, String indentStr, String newLineStr, String sepCharsStr) {
        int ePos;
        if (lineWidth <= 0) {
            lineWidth = 40;
        }
        if (indentStr == null) {
            indentStr = EMPTY_STRING;
        }
        boolean spaceSepFlag = sepCharsStr == null || sepCharsStr.length() <= 0;
        srcStr = UtilFns.trimEndStr(srcStr);
        int srcStrLen = srcStr.length();
        int sPos = 0;
        int minBreakPos = lineWidth / 5;
        StringBuffer buff = new StringBuffer();
        block0: do {
            char ch;
            int chkEPos = (ePos = sPos + lineWidth) < srcStrLen ? ePos : srcStrLen;
            for (int p = sPos; p < chkEPos; ++p) {
                if (srcStr.charAt(p) != '\n') continue;
                buff.append(UtilFns.trimEndStr(srcStr.substring(sPos, p)));
                buff.append(newLineStr);
                sPos = p + 1;
                if (sPos >= srcStrLen) break block0;
                buff.append(indentStr);
                ePos = sPos + lineWidth;
                chkEPos = ePos < srcStrLen ? ePos : srcStrLen;
            }
            if (ePos >= srcStrLen) {
                buff.append(UtilFns.trimEndStr(srcStr.substring(sPos)));
                break;
            }
            ++ePos;
            do {
                ch = srcStr.charAt(--ePos);
                if (!(spaceSepFlag ? ch <= ' ' : sepCharsStr.indexOf(ch) >= 0)) continue;
                buff.append(UtilFns.trimEndStr(srcStr.substring(sPos, ePos + 1)));
                buff.append(newLineStr);
                buff.append(indentStr);
                continue block0;
            } while (ePos > minBreakPos);
            ePos = sPos + lineWidth;
            do {
                if (++ePos >= srcStrLen) {
                    buff.append(UtilFns.trimEndStr(srcStr.substring(sPos)));
                    continue block0;
                }
                ch = srcStr.charAt(ePos);
            } while (!(spaceSepFlag ? ch <= ' ' : sepCharsStr.indexOf(ch) >= 0));
            buff.append(UtilFns.trimEndStr(srcStr.substring(sPos, ePos + 1)));
            buff.append(newLineStr);
            buff.append(indentStr);
        } while ((sPos = ePos + 1) < srcStrLen);
        return buff.toString();
    }

    public static String softWordWrapString(String srcStr, int lineWidth, String indentStr, String newLineStr) {
        return UtilFns.softWordWrapString(srcStr, lineWidth, indentStr, newLineStr, null);
    }

    public static String softWordWrapString(String srcStr, int lineWidth, String indentStr) {
        return UtilFns.softWordWrapString(srcStr, lineWidth, indentStr, newline, null);
    }

    public static String trimEndStr(String str) {
        int p = str.length();
        if (p > 0 && Character.isWhitespace(str.charAt(--p))) {
            while (--p >= 0 && Character.isWhitespace(str.charAt(p))) {
            }
            return str.substring(0, p + 1);
        }
        return str;
    }

    public static String trimMultiLineString(String inString, String newLineStr, int centerFieldLen) {
        StringBuffer buff = new StringBuffer();
        if (inString != null) {
            inString = inString.trim();
            int inStrLen = inString.length();
            int sPos = 0;
            while (true) {
                String str;
                int sLen;
                int ePos;
                if ((ePos = inString.indexOf(10, sPos)) < 0) {
                    ePos = inStrLen;
                }
                if ((sLen = (str = inString.substring(sPos, ePos).trim()).length()) > 0) {
                    if (centerFieldLen > 0) {
                        str = UtilFns.createCenteredString(str, centerFieldLen);
                    }
                    buff.append(str);
                }
                if ((sPos = ePos + 1) >= inStrLen) break;
                buff.append(newLineStr);
            }
        }
        return buff.toString();
    }

    public static String trimMultiLineString(String inString, String newLineStr) {
        return UtilFns.trimMultiLineString(inString, newLineStr, 0);
    }

    public static String trimMultiLineString(String inString, int centerFieldLen) {
        return UtilFns.trimMultiLineString(inString, "\n", centerFieldLen);
    }

    public static String trimMultiLineString(String inString) {
        return UtilFns.trimMultiLineString(inString, 0);
    }

    public static String capFirstLetter(String str) {
        char ch;
        if (str == null || str.length() <= 0 || !Character.isLetter(ch = str.charAt(0)) || !Character.isLowerCase(ch)) {
            return str;
        }
        return Character.toUpperCase(ch) + str.substring(1);
    }

    public static String getPrettyString(String str, boolean allUpperFlag) {
        char ch;
        if (str == null) {
            return null;
        }
        str = str.replace('.', ' ');
        str = str.replace('_', ' ');
        if ((str = str.trim()).length() <= 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        String pretty = EMPTY_STRING;
        int i = 0;
        boolean addSpaceFlag = false;
        if (Character.isLowerCase(ch = chars[i++])) {
            ch = Character.toUpperCase(ch);
        }
        pretty = pretty + ch;
        if (str.length() <= 1) {
            return pretty;
        }
        char saveCh = ch;
        char nextCh = chars[i++];
        while (i <= chars.length) {
            char prevCh = saveCh;
            ch = saveCh = nextCh;
            char c = nextCh = i >= chars.length ? (char)'\u0000' : chars[i];
            if (Character.isWhitespace(ch)) {
                addSpaceFlag = true;
            } else if (!Character.isISOControl(ch)) {
                if (addSpaceFlag) {
                    addSpaceFlag = false;
                    pretty = pretty + ' ';
                    if (allUpperFlag) {
                        if (Character.isLowerCase(ch)) {
                            ch = Character.toUpperCase(ch);
                        }
                    } else if (Character.isUpperCase(ch) && Character.isLowerCase(nextCh)) {
                        ch = Character.toLowerCase(ch);
                    }
                } else if (Character.isUpperCase(ch) && (Character.isLowerCase(prevCh) || Character.isLowerCase(nextCh))) {
                    pretty = pretty + ' ';
                    if (!allUpperFlag && Character.isLowerCase(nextCh)) {
                        ch = Character.toLowerCase(ch);
                    }
                }
                pretty = pretty + ch;
            }
            ++i;
        }
        return pretty;
    }

    public static String getPrettyString(String str) {
        return UtilFns.getPrettyString(str, true);
    }

    public static String charToString(char ch) {
        return String.valueOf(new char[]{ch});
    }

    public static InetAddress getLocalHostAddrObj(boolean preferIP4Flag, StringBuffer addrInfoBuff) {
        InetAddress localHostAddr = null;
        try {
            String str;
            int pos;
            localHostAddr = InetAddress.getLocalHost();
            InetAddress[] addrArr = InetAddress.getAllByName(localHostAddr.getHostName());
            String sepStr = "; ";
            if (preferIP4Flag) {
                for (pos = 0; pos < addrArr.length; ++pos) {
                    if (addrArr[pos] == null || !(addrArr[pos] instanceof Inet4Address) || addrArr[pos].isLinkLocalAddress() || addrArr[pos].isSiteLocalAddress() || (str = addrArr[pos].getHostAddress()) == null || UtilFns.isFakeIPAddress(str)) continue;
                    if (addrInfoBuff != null) {
                        int i;
                        addrInfoBuff.append(addrArr[pos]);
                        for (i = 0; i < pos; ++i) {
                            addrInfoBuff.append("; " + addrArr[i]);
                        }
                        for (i = pos + 1; i < addrArr.length; ++i) {
                            addrInfoBuff.append("; " + addrArr[i]);
                        }
                    }
                    return addrArr[pos];
                }
            }
            for (pos = 0; pos < addrArr.length; ++pos) {
                if (addrArr[pos] == null || addrArr[pos].isLinkLocalAddress() || addrArr[pos].isSiteLocalAddress() || (str = addrArr[pos].getHostAddress()) == null || UtilFns.isFakeIPAddress(str)) continue;
                if (addrInfoBuff != null) {
                    int i;
                    addrInfoBuff.append(addrArr[pos]);
                    for (i = 0; i < pos; ++i) {
                        addrInfoBuff.append("; " + addrArr[i]);
                    }
                    for (i = pos + 1; i < addrArr.length; ++i) {
                        addrInfoBuff.append("; " + addrArr[i]);
                    }
                }
                return addrArr[pos];
            }
            if (preferIP4Flag) {
                for (pos = 0; pos < addrArr.length; ++pos) {
                    if (addrArr[pos] == null || !(addrArr[pos] instanceof Inet4Address) || addrArr[pos].isLoopbackAddress()) continue;
                    if (addrInfoBuff != null) {
                        int i;
                        addrInfoBuff.append(addrArr[pos]);
                        for (i = 0; i < pos; ++i) {
                            addrInfoBuff.append("; " + addrArr[i]);
                        }
                        for (i = pos + 1; i < addrArr.length; ++i) {
                            addrInfoBuff.append("; " + addrArr[i]);
                        }
                    }
                    return addrArr[pos];
                }
            }
            if (addrInfoBuff != null && addrArr.length > 0 && addrArr[0] != null) {
                addrInfoBuff.append(addrArr[0]);
                for (int i = 1; i < addrArr.length; ++i) {
                    addrInfoBuff.append("; " + addrArr[i]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localHostAddr;
    }

    public static InetAddress getLocalHostAddrObj(boolean preferIP4Flag) {
        return UtilFns.getLocalHostAddrObj(preferIP4Flag, null);
    }

    public static InetAddress getLocalHostAddrObj() {
        return UtilFns.getLocalHostAddrObj(false, null);
    }

    public static String getLocalHostIP() {
        return UtilFns.getLocalHostIP(UtilFns.getLocalHostAddrObj());
    }

    public static String getLocalHostIP(InetAddress addrObj) {
        String localHostIPString = EMPTY_STRING;
        if (addrObj != null) {
            try {
                localHostIPString = addrObj.getHostAddress();
            }
            catch (Exception ex) {
                UtilFns.toGlobalLogFileWarn("Error determining local IP address:  " + ex);
                UtilFns.toGlobalLogFileWarn(UtilFns.getStackTraceString(ex));
            }
        }
        if (localHostIPString == null) {
            localHostIPString = EMPTY_STRING;
        }
        return localHostIPString;
    }

    public static String getLocalHostName() {
        return UtilFns.getLocalHostName(UtilFns.getLocalHostAddrObj());
    }

    public static String getLocalHostName(InetAddress addrObj) {
        String localHostNameString = EMPTY_STRING;
        if (addrObj != null) {
            try {
                localHostNameString = addrObj.getHostName();
            }
            catch (Exception ex) {
                UtilFns.toGlobalLogFileWarn("Error determining local host name:  " + ex);
                UtilFns.toGlobalLogFileWarn(UtilFns.getStackTraceString(ex));
            }
        }
        if (localHostNameString == null) {
            localHostNameString = EMPTY_STRING;
        }
        return localHostNameString;
    }

    public static URL setURLReference(URL urlObj, String refStr) {
        String urlStr = urlObj.toString();
        String curRefStr = urlObj.getRef();
        if (curRefStr != null) {
            if (curRefStr.equals(refStr)) {
                return urlObj;
            }
            curRefStr = "#" + curRefStr;
            if (urlStr.endsWith(curRefStr)) {
                urlStr = urlStr.substring(0, urlStr.length() - curRefStr.length());
            }
        } else if (refStr == null) {
            return urlObj;
        }
        if (refStr != null) {
            urlStr = urlStr + "#" + refStr;
        }
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            return urlObj;
        }
    }

    public static boolean isURLAddress(String str) {
        if (str == null || str.length() <= 0) {
            return false;
        }
        int p = str.indexOf("://", 1);
        if (p <= 0 || p > 10) {
            return false;
        }
        while (--p >= 0) {
            if (Character.isLetterOrDigit(str.charAt(p))) continue;
            return false;
        }
        return true;
    }

    public static boolean isIPAddress(String str) {
        int ePos;
        int len;
        if (str == null || (len = str.length()) <= 0) {
            return false;
        }
        int sPos = 0;
        int count = 0;
        do {
            int val;
            if ((ePos = str.indexOf(46, sPos)) < 0) {
                ePos = len;
            }
            try {
                val = Integer.parseInt(str.substring(sPos, ePos));
            }
            catch (NumberFormatException ex) {
                return false;
            }
            if (val < 0 || val > 255) {
                return false;
            }
            ++count;
        } while ((sPos = ePos + 1) < len);
        return count == 4;
    }

    public static boolean isFakeIPAddress(String str) {
        if (str != null) {
            for (int i = 0; i < FAKE_IP_ADDRS.length; ++i) {
                if (!str.startsWith(FAKE_IP_ADDRS[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String replaceSubstring(String dataStr, String oldStr, String newStr) {
        int sPos = dataStr.indexOf(oldStr);
        if (sPos < 0) {
            return dataStr;
        }
        return dataStr.substring(0, sPos) + newStr + dataStr.substring(sPos + oldStr.length());
    }

    public static String replaceAllSubstrings(String dataStr, String oldStr, String newStr) {
        int i;
        int oldStrLen = oldStr.length();
        StringBuffer sb = new StringBuffer(dataStr);
        int fromIndex = Integer.MAX_VALUE;
        while ((i = dataStr.lastIndexOf(oldStr, fromIndex)) >= 0) {
            fromIndex = i - 1;
            sb.replace(i, i + oldStrLen, newStr);
        }
        return sb.toString();
    }

    public static String normalizeString(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        StringBuffer buff = new StringBuffer(str.trim());
        int len = buff.length();
        if (len <= 0) {
            return EMPTY_STRING;
        }
        boolean changedFlag = len != str.length();
        boolean wSpaceFlag = false;
        for (int i = 1; i < len; ++i) {
            char ch = buff.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (wSpaceFlag) {
                    buff.deleteCharAt(i);
                    --len;
                    changedFlag = true;
                } else if (ch != ' ') {
                    buff.setCharAt(i, ' ');
                    changedFlag = true;
                }
                wSpaceFlag = true;
                continue;
            }
            wSpaceFlag = false;
        }
        if (!changedFlag) {
            return str;
        }
        return buff.toString();
    }

    public static String removeSpecifiedChars(String str, String keepCharsStr) {
        if (str == null) {
            return EMPTY_STRING;
        }
        if (keepCharsStr == null) {
            return str;
        }
        StringBuffer buff = new StringBuffer();
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            if (keepCharsStr.indexOf(ch) < 0) continue;
            buff.append(ch);
        }
        String retStr = buff.toString();
        return str.equals(retStr) ? str : retStr;
    }

    public static String removeNonAlphanumChars(String str) {
        return UtilFns.removeSpecifiedChars(str, ALPHANUM_CHARS_STRING);
    }

    public static ArrayList parseSeparatedSubstrsToList(String dataStr, String sepStr) {
        int dataStrLen;
        ArrayList<String> listObj = new ArrayList<String>();
        if (dataStr != null && (dataStrLen = dataStr.length()) > 0) {
            int ePos;
            if (sepStr == null || sepStr.length() <= 0) {
                sepStr = ".";
            }
            int sepStrLen = sepStr.length();
            int sPos = 0;
            do {
                if ((ePos = dataStr.indexOf(sepStr, sPos)) < 0) {
                    ePos = dataStrLen;
                }
                listObj.add(dataStr.substring(sPos, ePos));
            } while ((sPos = ePos + sepStrLen) < dataStrLen);
        }
        return listObj;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ArrayList parseSeparatedSubstrsToList(String dataStr, String sepStr, char quoteChar, boolean trimFlag, boolean removeQuotesFlag) {
        int ePos;
        ArrayList<String> listObj = new ArrayList<String>();
        if (dataStr == null) return listObj;
        int dataStrLen = dataStr.length();
        if (dataStrLen <= 0) return listObj;
        if (sepStr == null || sepStr.length() <= 0) {
            sepStr = ".";
        }
        int sepStrLen = sepStr.length();
        boolean sepSpaceFlag = sepStr.trim().length() <= 0;
        int sPos = 0;
        do {
            String str;
            block12: {
                block11: {
                    int q;
                    if (sepSpaceFlag && Character.isWhitespace(dataStr.charAt(sPos))) {
                        do {
                            if (++sPos < dataStrLen) continue;
                            return listObj;
                        } while (Character.isWhitespace(dataStr.charAt(sPos)));
                    }
                    if ((ePos = dataStr.indexOf(sepStr, sPos)) < 0) {
                        ePos = dataStrLen;
                    }
                    if (quoteChar <= '\u0000') break block11;
                    int p = dataStr.indexOf(quoteChar, sPos);
                    if (p >= 0 && p < ePos && p + 1 < dataStrLen && (q = dataStr.indexOf(quoteChar, p + 1)) > ePos && (ePos = dataStr.indexOf(sepStr, q)) < 0) {
                        ePos = dataStrLen;
                    }
                    str = dataStr.substring(sPos, ePos);
                    String tStr = str.trim();
                    if (removeQuotesFlag && (q = tStr.length()) >= 2 && tStr.charAt(0) == quoteChar && tStr.charAt(q - 1) == quoteChar) {
                        str = tStr.substring(1, q - 1);
                        if (trimFlag) {
                            str = str.trim();
                        }
                        break block12;
                    } else if (trimFlag) {
                        str = tStr;
                    }
                    break block12;
                }
                str = dataStr.substring(sPos, ePos);
                if (trimFlag) {
                    str = str.trim();
                }
            }
            listObj.add(str);
        } while ((sPos = ePos + sepStrLen) < dataStrLen);
        return listObj;
    }

    public static ArrayList parseSeparatedSubstrsToList(String dataStr, String sepStr, char quoteChar, boolean trimFlag) {
        return UtilFns.parseSeparatedSubstrsToList(dataStr, sepStr, quoteChar, trimFlag, true);
    }

    public static String[] parseSeparatedSubstrings(String dataStr, String sepStr) {
        ArrayList listObj = UtilFns.parseSeparatedSubstrsToList(dataStr, sepStr);
        return listObj.toArray(new String[listObj.size()]);
    }

    public static String[] parseSeparatedSubstrings(String dataStr, String sepStr, char quoteChar, boolean trimFlag, boolean removeQuotesFlag) {
        ArrayList listObj = UtilFns.parseSeparatedSubstrsToList(dataStr, sepStr, quoteChar, trimFlag, removeQuotesFlag);
        return listObj.toArray(new String[listObj.size()]);
    }

    public static String[] parseSeparatedSubstrings(String dataStr, String sepStr, char quoteChar, boolean trimFlag) {
        ArrayList listObj = UtilFns.parseSeparatedSubstrsToList(dataStr, sepStr, quoteChar, trimFlag, true);
        return listObj.toArray(new String[listObj.size()]);
    }

    public static int parseLeadingInt(String numStr) throws NumberFormatException {
        int len;
        if (numStr == null || (len = (numStr = numStr.trim()).length()) <= 0) {
            throw new NumberFormatException("String contains no data");
        }
        int p = 0;
        while (Character.isDigit(numStr.charAt(p)) && ++p < len) {
        }
        if (p == 0) {
            throw new NumberFormatException("String contains no numeric data");
        }
        return Integer.parseInt(numStr.substring(0, p));
    }

    public static Integer[] parseVersionNumbers(String verStr) {
        String[] strArr = UtilFns.parseSeparatedSubstrings(verStr, ".");
        Integer[] integerArr = new Integer[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            try {
                integerArr[i] = new Integer(UtilFns.parseLeadingInt(strArr[i]));
                continue;
            }
            catch (NumberFormatException ex) {
                integerArr[i] = null;
            }
        }
        return integerArr;
    }

    public static int compareVersionStrings(String ver1Str, String ver2Str) {
        Integer[] integer2Arr;
        Integer[] integer1Arr = UtilFns.parseVersionNumbers(ver1Str);
        int len = integer1Arr.length;
        if (len > (integer2Arr = UtilFns.parseVersionNumbers(ver2Str)).length) {
            len = integer2Arr.length;
        }
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                int str2Len;
                String str1 = integer1Arr[i].toString();
                String str2 = integer2Arr[i].toString();
                int str1Len = str1.length();
                if (str1Len != (str2Len = str2.length())) {
                    if (str1Len < str2Len) {
                        while ((str1 = str1 + '0').length() < str2Len) {
                        }
                        integer1Arr[i] = new Integer(str1);
                    } else if (str2Len < str1Len) {
                        while ((str2 = str2 + '0').length() < str1Len) {
                        }
                        integer2Arr[i] = new Integer(str2);
                    }
                }
            }
            if (integer1Arr[i] != null) {
                if (integer2Arr[i] == null) {
                    return 1;
                }
                if (integer1Arr[i].equals(integer2Arr[i])) continue;
                return integer1Arr[i] > integer2Arr[i] ? 1 : -1;
            }
            if (integer2Arr[i] == null) continue;
            return -1;
        }
        if (integer1Arr.length != integer2Arr.length) {
            return integer1Arr.length > integer2Arr.length ? 1 : -1;
        }
        return 0;
    }

    public static String getStackTraceString(Throwable throwObj) {
        String retStr = EMPTY_STRING;
        StringWriter strWtrObj = new StringWriter();
        try {
            PrintWriter prtWtrObj = new PrintWriter(strWtrObj);
            throwObj.printStackTrace(new PrintWriter(prtWtrObj));
            prtWtrObj.flush();
            retStr = UtilFns.stripTrailingNewline(strWtrObj.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retStr;
    }

    public static String getMemoryInfoStr() {
        try {
            long totalVal = systemRuntimeObj.totalMemory();
            long freeVal = systemRuntimeObj.freeMemory();
            return "total=" + totalVal + ", free=" + freeVal + ", diff=" + (totalVal - freeVal);
        }
        catch (Exception ex) {
            return "Error in 'getMemoryInfoStr()':  " + ex;
        }
    }

    public static ThreadGroup getRootThreadGroupObj() {
        if (rootThreadGroupObj == null) {
            try {
                ThreadGroup gObj;
                ThreadGroup threadGroupObj = Thread.currentThread().getThreadGroup();
                while ((gObj = threadGroupObj.getParent()) != null) {
                    threadGroupObj = gObj;
                }
                rootThreadGroupObj = threadGroupObj;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rootThreadGroupObj;
    }

    public static int getTotalThreadCount() {
        try {
            ThreadGroup threadGroupObj = UtilFns.getRootThreadGroupObj();
            return threadGroupObj != null ? threadGroupObj.activeCount() : 0;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static void beep() {
        try {
            Class<?> tkClassObj = Class.forName("java.awt.Toolkit");
            Method gdtkMethObj = tkClassObj.getMethod("getDefaultToolkit", null);
            Object tkObj = gdtkMethObj.invoke(null, null);
            Method beepMethObj = tkClassObj.getMethod("beep", null);
            beepMethObj.invoke(tkObj, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isValidFileNameChar(char ch) {
        if (INVALID_FILENAME_CHARS.indexOf(ch) >= 0) {
            return false;
        }
        if (ch == File.separatorChar) {
            return false;
        }
        if (Character.isISOControl(ch)) {
            return false;
        }
        if (ch == ' ') {
            return true;
        }
        return !Character.isWhitespace(ch);
    }

    public static String stringToFileName(String str) {
        StringBuffer fileName = new StringBuffer();
        int strLen = str.length();
        boolean changedFlag = false;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            if (UtilFns.isValidFileNameChar(ch)) {
                fileName.append(ch);
                continue;
            }
            fileName.append('%' + UtilFns.toHexString(ch, 4));
            changedFlag = true;
        }
        String retStr = fileName.toString().trim();
        return !changedFlag && retStr.length() == strLen ? str : retStr;
    }

    public static String fileNameToString(String fNameStr) {
        String retStr;
        int fNameStrLen = fNameStr.length();
        int pos = fNameStr.indexOf(37);
        if (pos < 0 || pos > fNameStrLen - 5) {
            return fNameStr;
        }
        StringBuffer buff = new StringBuffer(fNameStr.substring(0, pos));
        while (true) {
            try {
                int val = Integer.parseInt(fNameStr.substring(pos + 1, pos + 5), 16);
                buff.append((char)val);
                pos += 5;
            }
            catch (Exception ex) {
                buff.append(fNameStr.substring(pos, pos + 1));
                ++pos;
            }
            int nPos = fNameStr.indexOf(37, pos);
            if (nPos < 0 || nPos > fNameStrLen - 5) {
                if (pos >= fNameStrLen) break;
                buff.append(fNameStr.substring(pos));
                break;
            }
            buff.append(fNameStr.substring(pos, nPos));
            pos = nPos;
        }
        return (retStr = buff.toString()).equals(fNameStr) ? fNameStr : retStr;
    }

    public static String stringArrayToString(String[] strArr, String sepStr) {
        StringWriter wtrObj = new StringWriter();
        if (sepStr == null) {
            sepStr = EMPTY_STRING;
        }
        if (strArr.length > 0) {
            int i = 0;
            while (true) {
                wtrObj.write(strArr[i]);
                if (++i >= strArr.length) break;
                wtrObj.write(sepStr);
            }
        }
        return wtrObj.toString();
    }

    public static String stringArrayToString(String[] strArr) {
        return UtilFns.stringArrayToString(strArr, SPACE_STRING);
    }

    public static void toGlobalLogFileWarn(String msgStr) {
        try {
            Class<?> logFileClassObj = Class.forName("com.isti.util.LogFile");
            Method getGlobalLogObjMethodObj = logFileClassObj.getMethod("getGlobalLogObj", Boolean.TYPE);
            Method warningMethodObj = logFileClassObj.getMethod("warning", class$java$lang$String == null ? (class$java$lang$String = UtilFns.class$("java.lang.String")) : class$java$lang$String);
            Object logFileInstanceObj = getGlobalLogObjMethodObj.invoke(null, Boolean.TRUE);
            warningMethodObj.invoke(logFileInstanceObj, msgStr);
        }
        catch (Throwable ex) {
            System.err.println(msgStr);
        }
    }

    public static List toList(Object[] a) {
        if (a == null) {
            return null;
        }
        return Arrays.asList(a);
    }

    public static String toString(Object obj) {
        return UtilFns.toString(obj, DEFAULT_NULL_STR, DEFAULT_SEP_STR);
    }

    public static String toString(Object obj, String nullStr, String sepStr) {
        return UtilFns.toString(obj, nullStr, sepStr, new ArrayList());
    }

    public static String toString(Object obj, String nullStr, String sepStr, Collection all) {
        Collection<Object> colObj;
        if (obj == null) {
            return nullStr;
        }
        if (all != null && all.contains(obj)) {
            return "[...]";
        }
        if (obj instanceof Object[]) {
            colObj = Arrays.asList((Object[])obj);
        } else if (obj instanceof Collection) {
            colObj = (Collection)obj;
        } else {
            return obj.toString();
        }
        if (all != null) {
            all.add(obj);
        }
        StringBuffer buffObj = new StringBuffer();
        buffObj.append('[');
        Iterator<Object> iterObj = colObj.iterator();
        if (iterObj.hasNext()) {
            while (true) {
                String s = all != null ? UtilFns.toString(iterObj.next(), nullStr, sepStr, all) : (obj != null ? obj.toString() : nullStr);
                buffObj.append(s);
                if (!iterObj.hasNext()) break;
                buffObj.append(sepStr);
            }
        }
        buffObj.append("]");
        if (all != null) {
            all.remove(obj);
        }
        return buffObj.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Arrays.sort(timeZoneIDs);
        timeZoneValidator = new CfgPropValidator(timeZoneIDs);
        floatNumberFormatObj.setMaximumFractionDigits(8);
        ByteArrayOutputStream btOutStream = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(btOutStream);
        out.println();
        out.flush();
        newline = btOutStream.toString();
        out.close();
        blanksString = "                                                                                ";
        blanksStringLen = blanksString.length();
        blanksStringSyncObj = new Object();
        rootThreadGroupObj = null;
        COLOR_HASH_VALUES = new Integer[]{new Integer(Color.white.getRGB()), new Integer(Color.lightGray.getRGB()), new Integer(Color.gray.getRGB()), new Integer(Color.darkGray.getRGB()), new Integer(Color.black.getRGB()), new Integer(Color.red.getRGB()), new Integer(Color.pink.getRGB()), new Integer(Color.orange.getRGB()), new Integer(Color.yellow.getRGB()), new Integer(Color.green.getRGB()), new Integer(Color.magenta.getRGB()), new Integer(Color.cyan.getRGB()), new Integer(Color.blue.getRGB())};
        COLOR_HASH_STRINGS = new String[]{"white".toLowerCase(), "lightGray".toLowerCase(), "gray".toLowerCase(), "darkGray".toLowerCase(), "black".toLowerCase(), "red".toLowerCase(), "pink".toLowerCase(), "orange".toLowerCase(), "yellow".toLowerCase(), "green".toLowerCase(), "magenta".toLowerCase(), "cyan".toLowerCase(), "blue".toLowerCase()};
        COLOR_DISPLAY_STRINGS = new String[]{UtilFns.getPrettyString("white"), UtilFns.getPrettyString("lightGray"), UtilFns.getPrettyString("gray"), UtilFns.getPrettyString("darkGray"), UtilFns.getPrettyString("black"), UtilFns.getPrettyString("red"), UtilFns.getPrettyString("pink"), UtilFns.getPrettyString("orange"), UtilFns.getPrettyString("yellow"), UtilFns.getPrettyString("green"), UtilFns.getPrettyString("magenta"), UtilFns.getPrettyString("cyan"), UtilFns.getPrettyString("blue")};
        strToClrHashtable = null;
        clrToStrHashtable = null;
        FAKE_IP_ADDRS = new String[]{"192.168.", "172.16.", "10.", "255.", "127.0.0.", "0.", "fe8", "fec", "fed", "fee", "fef", "FE8", "FEC", "FED", "FEE", "FEF", "2001:", "2002:", "0:0:0:0:0:0:"};
    }
}

