/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.BaseProperties;
import com.isti.util.CfgFileTokenizer;
import com.isti.util.CfgPropItem;
import com.isti.util.UtilFns;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class AppletProperties
extends BaseProperties {
    private CfgFileTokenizer inTokens;

    public AppletProperties() {
    }

    public AppletProperties(Vector vec) {
        super(vec);
    }

    public AppletProperties(CfgPropItem[] itemsArr) {
        super(itemsArr);
    }

    public AppletProperties(BaseProperties basePropObj) {
        super(basePropObj);
    }

    public boolean processAppletParams(Applet appletObj, String cfgFnParam, String defCfgFnStr) {
        this.loadedCfgFname = null;
        if (appletObj == null) {
            this.setErrorMessage("Handle for applet object is null");
            return false;
        }
        try {
            String cfgFnStr = cfgFnParam != null && cfgFnParam.length() > 0 ? appletObj.getParameter(cfgFnParam) : null;
            boolean defCfgFnFlag = cfgFnStr == null;
            if (defCfgFnFlag) {
                cfgFnStr = defCfgFnStr;
            }
            if (cfgFnStr != null && cfgFnStr.length() > 0) {
                String fileSpec;
                if (!cfgFnStr.startsWith("http://") && !cfgFnStr.startsWith("ftp://")) {
                    fileSpec = appletObj.getDocumentBase().toString();
                    int p = fileSpec.lastIndexOf(47);
                    if (p > 0) {
                        if (cfgFnStr.charAt(0) != '/') {
                            ++p;
                        }
                        fileSpec = fileSpec.substring(0, p) + cfgFnStr;
                    } else {
                        fileSpec = fileSpec + cfgFnStr;
                    }
                } else {
                    fileSpec = cfgFnStr;
                }
                try {
                    BufferedInputStream inStm = new BufferedInputStream(new URL(fileSpec).openStream());
                    this.loadedCfgFname = fileSpec;
                    this.load(inStm);
                    ((InputStream)inStm).close();
                }
                catch (FileNotFoundException ex) {
                    if (!defCfgFnFlag) {
                        this.setErrorMessage("Configuration file \"" + fileSpec + "\" not found");
                    }
                }
                catch (Exception ex) {
                    this.setErrorMessage("Error opening configuration file \"" + fileSpec + "\":  " + ex);
                }
            }
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                if (!(obj instanceof CfgPropItem)) continue;
                CfgPropItem item = (CfgPropItem)obj;
                String valueStr = appletObj.getParameter(item.getName());
                if (valueStr != null) {
                    if (item.setValueString(valueStr)) {
                        item.setLoadedFlag(true);
                        continue;
                    }
                    this.setErrorMessage("Error fetching \"" + item.getName() + "\":  Unable to convert \"" + valueStr + "\" to type " + UtilFns.shortClassString(item.getValueClass()));
                    continue;
                }
                if (!item.getRequiredFlag()) continue;
                this.setErrorMessage("Required item not loaded:  \"" + item.getName() + "\"");
            }
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.toString());
        }
        return !this.errMsgSetFlag;
    }

    public boolean processAppletParams(Applet appletObj) {
        return this.processAppletParams(appletObj, null, null);
    }
}

