/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.settings;

import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.plots.settings.SettingChangeEvent;
import de.erichseifert.gral.plots.settings.SettingsListener;
import de.erichseifert.gral.plots.settings.SettingsStorage;
import de.erichseifert.gral.util.SerializationUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSettingsStorage
implements SettingsStorage,
Serializable {
    private static final long serialVersionUID = 6918096150217655364L;
    private transient Set<SettingsListener> a = new HashSet<SettingsListener>();
    private Map<Key, Object> b = new HashMap<Key, Object>();
    private Map<Key, Object> c = new HashMap<Key, Object>();

    public boolean hasSetting(Key key) {
        return this.b.containsKey(key);
    }

    @Override
    public <T> T getSetting(Key key) {
        if (this.b.containsKey(key)) {
            return (T)this.b.get(key);
        }
        return (T)this.c.get(key);
    }

    @Override
    public <T> void setSetting(Key key, T t) {
        this.setSetting(key, t, false);
    }

    @Override
    public <T> void removeSetting(Key key) {
        Object object = this.b.get(key);
        this.b.remove(key);
        this.notifySettingChanged(key, object, null, false);
    }

    public boolean hasSettingDefault(Key key) {
        return this.c.containsKey(key);
    }

    @Override
    public <T> void setSettingDefault(Key key, T t) {
        this.setSetting(key, t, true);
    }

    @Override
    public <T> void removeSettingDefault(Key key) {
        Object object = this.c.get(key);
        this.c.remove(key);
        this.notifySettingChanged(key, object, null, true);
    }

    protected <T> void setSetting(Key key, T t, boolean bl) {
        Map<Key, Object> map = bl ? this.c : this.b;
        Object object = this.c.get(key);
        map.put(key, t);
        this.notifySettingChanged(key, object, t, true);
    }

    public void addSettingsListener(SettingsListener settingsListener) {
        this.a.add(settingsListener);
    }

    public void removeSettingsListener(SettingsListener settingsListener) {
        this.a.remove(settingsListener);
    }

    protected void notifySettingChanged(Key serializable, Object iterator, Object object, boolean bl) {
        serializable = new SettingChangeEvent(this, (Key)serializable, iterator, object, bl);
        iterator = this.a.iterator();
        while (iterator.hasNext()) {
            iterator.next().settingChanged((SettingChangeEvent)serializable);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.a = new HashSet<SettingsListener>();
        this.b = BasicSettingsStorage.b((Map)objectInputStream.readObject());
        this.c = BasicSettingsStorage.b((Map)objectInputStream.readObject());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.writeObject(BasicSettingsStorage.a(this.b));
        objectOutputStream.writeObject(BasicSettingsStorage.a(this.c));
    }

    private static Map<Key, Serializable> a(Map<Key, Object> object) {
        HashMap<Key, Serializable> hashMap = new HashMap<Key, Serializable>();
        for (Map.Entry entry : object.entrySet()) {
            hashMap.put((Key)entry.getKey(), SerializationUtils.wrap(entry.getValue()));
        }
        return hashMap;
    }

    private static Map<Key, Object> b(Map<Key, Serializable> object) {
        HashMap<Key, Object> hashMap = new HashMap<Key, Object>();
        for (Map.Entry entry : object.entrySet()) {
            hashMap.put((Key)entry.getKey(), SerializationUtils.unwrap((Serializable)entry.getValue()));
        }
        return hashMap;
    }
}

