/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.lines;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.lines.AbstractLineRenderer2D;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Orientation;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteLineRenderer2D
extends AbstractLineRenderer2D {
    private static final long serialVersionUID = 4648286099838467355L;
    public static final Key ASCENT_DIRECTION = new Key("line.discrete.ascentDirection");
    public static final Key ASCENDING_POINT = new Key("line.discrete.ascendingPoint");

    public DiscreteLineRenderer2D() {
        this.setSettingDefault(ASCENT_DIRECTION, Orientation.HORIZONTAL);
        this.setSettingDefault(ASCENDING_POINT, 0.5);
    }

    @Override
    public Drawable getLine(List<DataPoint> list, Shape shape) {
        return new AbstractDrawable(this, shape){
            private static final long serialVersionUID = -1686744943386843195L;
            private /* synthetic */ Shape a;
            private /* synthetic */ DiscreteLineRenderer2D b;
            {
                this.b = discreteLineRenderer2D;
                this.a = shape;
            }

            public final void draw(DrawingContext drawingContext) {
                Paint paint = (Paint)this.b.getSetting(LineRenderer.COLOR);
                GraphicsUtils.fillPaintedShape(drawingContext.getGraphics(), this.a, paint, null);
            }
        };
    }

    @Override
    public Shape getLineShape(List<DataPoint> list) {
        Orientation orientation = (Orientation)((Object)this.getSetting(ASCENT_DIRECTION));
        double d = ((Number)this.getSetting(ASCENDING_POINT)).doubleValue();
        Path2D.Double double_ = new Path2D.Double();
        Iterator<DataPoint> iterator = list.iterator();
        while (iterator.hasNext()) {
            double d2;
            Point2D point2D = iterator.next().position.getPoint2D();
            if (double_.getCurrentPoint() == null) {
                ((Path2D)double_).moveTo(point2D.getX(), point2D.getY());
                continue;
            }
            Point2D point2D2 = double_.getCurrentPoint();
            if (orientation == Orientation.HORIZONTAL) {
                d2 = point2D2.getX() + (point2D.getX() - point2D2.getX()) * d;
                ((Path2D)double_).lineTo(d2, point2D2.getY());
                ((Path2D)double_).lineTo(d2, point2D.getY());
            } else {
                d2 = point2D2.getY() + (point2D.getY() - point2D2.getY()) * d;
                ((Path2D)double_).lineTo(point2D2.getX(), d2);
                ((Path2D)double_).lineTo(point2D.getX(), d2);
            }
            ((Path2D)double_).lineTo(point2D.getX(), point2D.getY());
        }
        return this.punch(double_, list);
    }
}

